/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.advisors;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.application.advisors.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    public static final String IMPORTER_GROUP = "elexis.FileImports";
    public static final String ADDITIONS = "elexis.fileAdditions";
    private IWorkbenchWindow window;
    private IAction[] openPerspectiveActions = null;
    public static MenuManager fileMenu;
    public static MenuManager editMenu;
    public static MenuManager windowMenu;
    public static MenuManager helpMenu;
    private final IMenuListener reflectRightsListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    IAction action;
                    block18: {
                        IContributionItem iContributionItem = iContributionItemArray[n2];
                        if (!(iContributionItem instanceof ActionContributionItem)) break block17;
                        ActionContributionItem aci = (ActionContributionItem)iContributionItem;
                        action = aci.getAction();
                        if (!(action instanceof RestrictedAction)) break block18;
                        RestrictedAction ra = (RestrictedAction)aci.getAction();
                        ra.reflectRight();
                        break block17;
                    }
                    String id = action.getActionDefinitionId();
                    if (id == null) break block17;
                    switch (id) {
                        case "org.eclipse.ui.file.exit": {
                            action.setEnabled(CoreHub.acl.request(AccessControlDefaults.AC_EXIT));
                            break;
                        }
                        case "org.eclipse.ui.window.newWindow": {
                            action.setEnabled(CoreHub.acl.request(AccessControlDefaults.AC_NEWWINDOW));
                            break;
                        }
                        case "org.eclipse.ui.help.aboutAction": {
                            action.setEnabled(CoreHub.acl.request(AccessControlDefaults.AC_ABOUT));
                            break;
                        }
                        case "org.eclipse.ui.window.preferences": {
                            action.setEnabled(CoreHub.acl.request(AccessControlDefaults.AC_PREFS));
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
    };

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow win) {
        this.window = win;
        Hub.mainActions = new GlobalActions(this.window);
        this.register((IAction)GlobalActions.exitAction);
        if (CoreHub.localCfg.get("sidebar/toolbaritems", Boolean.toString(true)).equalsIgnoreCase(Boolean.toString(true))) {
            List ex = Extensions.getExtensions((String)"ch.elexis.core.ui.Sidebar");
            this.openPerspectiveActions = new IAction[ex.size()];
            int i = 0;
            for (IConfigurationElement ice : ex) {
                String name = ice.getAttribute("name");
                String id = ice.getAttribute("ID");
                String icon = ice.getAttribute("icon");
                IPerspectiveDescriptor perspectiveDescriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
                if (perspectiveDescriptor != null) {
                    this.openPerspectiveActions[i] = new OpenPerspectiveAction(perspectiveDescriptor, name, icon);
                }
                ++i;
            }
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_3, "file");
        fileMenu.addMenuListener(this.reflectRightsListener);
        editMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_4, "edit");
        editMenu.addMenuListener(this.reflectRightsListener);
        windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_5, "window");
        helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_6, "help");
        helpMenu.addMenuListener(this.reflectRightsListener);
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        fileMenu.add(GlobalActions.loginAction);
        fileMenu.add(GlobalActions.changeMandantAction);
        fileMenu.add(GlobalActions.connectWizardAction);
        fileMenu.add(GlobalActions.prefsAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(GlobalActions.importAction);
        fileMenu.add((IContributionItem)new GroupMarker(IMPORTER_GROUP));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker(ADDITIONS));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)GlobalActions.exitAction);
        editMenu.add((IAction)GlobalActions.copyAction);
        editMenu.add((IAction)GlobalActions.cutAction);
        editMenu.add((IAction)GlobalActions.pasteAction);
        GlobalActions.perspectiveMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_7, "openPerspective");
        GlobalActions.perspectiveMenu.add(GlobalActions.resetPerspectiveAction);
        GlobalActions.perspectiveMenu.add(GlobalActions.fixLayoutAction);
        windowMenu.add((IContributionItem)GlobalActions.perspectiveMenu);
        GlobalActions.viewMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_9);
        GlobalActions.viewList = ContributionItemFactory.VIEWS_SHORTLIST.create(this.window);
        GlobalActions.viewMenu.add(GlobalActions.viewList);
        windowMenu.add((IContributionItem)GlobalActions.viewMenu);
        windowMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    if ("viewsShortlist".equals(iContributionItem.getId())) {
                        iContributionItem.setVisible(CoreHub.acl.request(AccessControlDefaults.AC_SHOWVIEW));
                    }
                    ++n2;
                }
            }
        });
        helpMenu.add(GlobalActions.helpAction);
        helpMenu.add((IContributionItem)new Separator("additions"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add(GlobalActions.aboutAction);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager tbm = new ToolBarManager();
        tbm.add(GlobalActions.homeAction);
        tbm.add(GlobalActions.resetPerspectiveAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add(GlobalActions.printEtikette);
        tbm.add((IAction)new Action("", 4){
            private IMenuCreator menuCreator;

            public ImageDescriptor getImageDescriptor() {
                return GlobalActions.printVersionedEtikette.getImageDescriptor();
            }

            public String getText() {
                return GlobalActions.printVersionedEtikette.getText();
            }

            public String getToolTipText() {
                return GlobalActions.printVersionedEtikette.getToolTipText();
            }

            public IMenuCreator getMenuCreator() {
                if (this.menuCreator == null) {
                    this.menuCreator = new IMenuCreator(){
                        private Menu menu;

                        public Menu getMenu(Menu parent) {
                            return null;
                        }

                        public Menu getMenu(Control parent) {
                            if (this.menu == null) {
                                this.menu = new Menu(parent);
                                final MenuItem menuItem = new MenuItem(this.menu, 8);
                                Image image = GlobalActions.printVersionedEtikette.getImageDescriptor().createImage();
                                menuItem.setImage(image);
                                menuItem.setText("Mehrfach " + GlobalActions.printVersionedEtikette.getText());
                                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        InputDialog inputDlg = new InputDialog(Display.getDefault().getActiveShell(), menuItem.getText(), "Bitte die Anzahl eingeben", "1", new IInputValidator(){

                                            public String isValid(String newText) {
                                                try {
                                                    Integer.parseInt(newText);
                                                }
                                                catch (NumberFormatException e) {
                                                    return String.valueOf(newText) + " ist keine g\u00fcltige Anzahl";
                                                }
                                                return null;
                                            }
                                        }, 2048);
                                        if (inputDlg.open() == 0) {
                                            String amountStr = inputDlg.getValue();
                                            int amount = Integer.parseInt(amountStr);
                                            while (amount > 0) {
                                                GlobalActions.printVersionedEtikette.run();
                                                --amount;
                                            }
                                        }
                                    }
                                });
                            }
                            return this.menu;
                        }

                        public void dispose() {
                            this.menu.dispose();
                            this.menu = null;
                        }
                    };
                }
                return this.menuCreator;
            }

            public void run() {
                GlobalActions.printVersionedEtikette.run();
            }
        });
        tbm.add(GlobalActions.printAdresse);
        coolBar.add((IToolBarManager)tbm);
        if (CoreHub.localCfg.get("sidebar/toolbaritems", Boolean.toString(true)).equalsIgnoreCase(Boolean.toString(true))) {
            ToolBarManager tb2 = new ToolBarManager();
            ArrayList<IAction> l = new ArrayList<IAction>();
            IAction[] iActionArray = this.openPerspectiveActions;
            int n = this.openPerspectiveActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                if (action != null) {
                    l.add(action);
                }
                ++n2;
            }
            Collections.sort(l, new Comparator<IAction>(){

                @Override
                public int compare(IAction o1, IAction o2) {
                    if (o1.getToolTipText() != null && o2.getToolTipText() != null) {
                        return o1.getToolTipText().compareTo(o2.getToolTipText());
                    }
                    return o1.getToolTipText() != null ? 1 : -1;
                }
            });
            for (IAction action : l) {
                tb2.add(action);
            }
            coolBar.add((IToolBarManager)tb2);
        }
    }

    class OpenPerspectiveAction
    extends Action {
        private final IPerspectiveDescriptor perspectiveDescriptor;

        OpenPerspectiveAction(IPerspectiveDescriptor perspectiveDescriptor, String name, String icon) {
            super(perspectiveDescriptor.getLabel());
            this.setId(perspectiveDescriptor.getId());
            if (!StringTool.isNothing((Object)icon)) {
                this.setImageDescriptor(perspectiveDescriptor.getImageDescriptor());
            } else {
                this.setImageDescriptor(perspectiveDescriptor.getImageDescriptor());
            }
            this.setToolTipText(String.valueOf(StringTool.isNothing((Object)name) ? perspectiveDescriptor.getLabel() : name) + " " + Messages.ApplicationActionBarAdvisor_10);
            this.perspectiveDescriptor = perspectiveDescriptor;
        }

        public void run() {
            try {
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                PlatformUI.getWorkbench().showPerspective(this.perspectiveDescriptor.getId(), win);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
    }
}

