/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ICloneable;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.IExceptionHandler;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.EXMLParserFeature;
import com.phloc.commons.xml.EXMLParserProperty;
import com.phloc.commons.xml.serialize.ISAXReaderSettings;
import com.phloc.commons.xml.serialize.SAXReaderDefaultSettings;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@NotThreadSafe
public class SAXReaderSettings
implements ISAXReaderSettings,
ICloneable<SAXReaderSettings> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SAXReaderSettings.class);
    private EntityResolver m_aEntityResolver;
    private DTDHandler m_aDTDHandler;
    private ContentHandler m_aContentHandler;
    private ErrorHandler m_aErrorHandler;
    private final EnumMap<EXMLParserProperty, Object> m_aProperties = new EnumMap(EXMLParserProperty.class);
    private final EnumMap<EXMLParserFeature, Boolean> m_aFeatures = new EnumMap(EXMLParserFeature.class);
    private IExceptionHandler<Throwable> m_aExceptionHandler;
    private boolean m_bRequiresNewXMLParserExplicitly;

    public SAXReaderSettings() {
        this.setEntityResolver(SAXReaderDefaultSettings.getEntityResolver());
        this.setDTDHandler(SAXReaderDefaultSettings.getDTDHandler());
        this.setContentHandler(SAXReaderDefaultSettings.getContentHandler());
        this.setErrorHandler(SAXReaderDefaultSettings.getErrorHandler());
        this.setPropertyValues(SAXReaderDefaultSettings.getAllPropertyValues());
        this.setFeatureValues(SAXReaderDefaultSettings.getAllFeatureValues());
        this.setExceptionHandler(SAXReaderDefaultSettings.getExceptionHandler());
        this.setRequiresNewXMLParserExplicitly(SAXReaderDefaultSettings.isRequiresNewXMLParserExplicitly());
    }

    public SAXReaderSettings(@Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull(iSAXReaderSettings, "Other");
        this.setEntityResolver(iSAXReaderSettings.getEntityResolver());
        this.setDTDHandler(iSAXReaderSettings.getDTDHandler());
        this.setContentHandler(iSAXReaderSettings.getContentHandler());
        this.setErrorHandler(iSAXReaderSettings.getErrorHandler());
        this.setPropertyValues(iSAXReaderSettings.getAllPropertyValues());
        this.setFeatureValues(iSAXReaderSettings.getAllFeatureValues());
        this.setExceptionHandler(iSAXReaderSettings.getExceptionHandler());
        this.setRequiresNewXMLParserExplicitly(iSAXReaderSettings.isRequiresNewXMLParserExplicitly());
    }

    @Override
    @Nullable
    public EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    @Nonnull
    public final SAXReaderSettings setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.m_aEntityResolver = entityResolver;
        return this;
    }

    @Override
    @Nullable
    public DTDHandler getDTDHandler() {
        return this.m_aDTDHandler;
    }

    @Nonnull
    public final SAXReaderSettings setDTDHandler(@Nullable DTDHandler dTDHandler) {
        this.m_aDTDHandler = dTDHandler;
        return this;
    }

    @Override
    @Nullable
    public ContentHandler getContentHandler() {
        return this.m_aContentHandler;
    }

    @Nonnull
    public final SAXReaderSettings setContentHandler(@Nullable ContentHandler contentHandler) {
        this.m_aContentHandler = contentHandler;
        return this;
    }

    @Override
    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    public final SAXReaderSettings setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aErrorHandler = errorHandler;
        return this;
    }

    @Override
    @Nullable
    public LexicalHandler getLexicalHandler() {
        return (LexicalHandler)this.getPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER);
    }

    @Nonnull
    public final SAXReaderSettings setLexicalHandler(@Nullable LexicalHandler lexicalHandler) {
        return this.setPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER, lexicalHandler);
    }

    @Override
    @Nullable
    public DeclHandler getDeclarationHandler() {
        return (DeclHandler)this.getPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER);
    }

    @Nonnull
    public final SAXReaderSettings setDeclarationHandler(@Nullable DeclHandler declHandler) {
        return this.setPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER, declHandler);
    }

    @Override
    public boolean hasAnyProperties() {
        return !this.m_aProperties.isEmpty();
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return eXMLParserProperty == null ? null : this.m_aProperties.get(eXMLParserProperty);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<EXMLParserProperty, Object> getAllPropertyValues() {
        return new EnumMap<EXMLParserProperty, Object>(this.m_aProperties);
    }

    @Nonnull
    public final SAXReaderSettings setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull(eXMLParserProperty, "Property");
        if (object != null && eXMLParserProperty.getValueClass() != null && !eXMLParserProperty.getValueClass().isAssignableFrom(object.getClass())) {
            s_aLogger.warn("Setting the XML parser property '" + eXMLParserProperty + "' to a value of " + object.getClass() + " will most likely not be interpreted!");
        }
        if (object != null) {
            this.m_aProperties.put(eXMLParserProperty, object);
        } else {
            this.m_aProperties.remove(eXMLParserProperty);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            this.m_aProperties.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return EChange.valueOf(eXMLParserProperty != null && this.m_aProperties.remove(eXMLParserProperty) != null);
    }

    @Nonnull
    public final EChange removeAllPropertyValues() {
        if (this.m_aProperties.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aProperties.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return (Locale)this.getPropertyValue(EXMLParserProperty.GENERAL_LOCALE);
    }

    public SAXReaderSettings setLocale(@Nullable Locale locale) {
        return this.setPropertyValue(EXMLParserProperty.GENERAL_LOCALE, locale);
    }

    @Override
    public boolean hasAnyFeature() {
        return !this.m_aFeatures.isEmpty();
    }

    @Override
    @Nullable
    public Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        return eXMLParserFeature == null ? null : this.m_aFeatures.get(eXMLParserFeature);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return new EnumMap<EXMLParserFeature, Boolean>(this.m_aFeatures);
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        this.m_aFeatures.put(eXMLParserFeature, bl);
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        if (bl == null) {
            this.m_aFeatures.remove(eXMLParserFeature);
        } else {
            this.m_aFeatures.put(eXMLParserFeature, bl);
        }
        return this;
    }

    @Nonnull
    public final SAXReaderSettings setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            this.m_aFeatures.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        return EChange.valueOf(eXMLParserFeature != null && this.m_aFeatures.remove(eXMLParserFeature) != null);
    }

    @Nonnull
    public final EChange removeAllFeatures() {
        if (this.m_aFeatures.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aFeatures.clear();
        return EChange.CHANGED;
    }

    @Override
    public boolean requiresNewXMLParser() {
        if (this.m_bRequiresNewXMLParserExplicitly) {
            return true;
        }
        if (!this.m_aProperties.isEmpty() || !this.m_aFeatures.isEmpty()) {
            return true;
        }
        return this.m_aEntityResolver != null;
    }

    @Override
    @Nonnull
    public IExceptionHandler<Throwable> getExceptionHandler() {
        return this.m_aExceptionHandler;
    }

    @Nonnull
    public final SAXReaderSettings setExceptionHandler(@Nonnull IExceptionHandler<Throwable> iExceptionHandler) {
        ValueEnforcer.notNull(iExceptionHandler, "ExceptionHandler");
        this.m_aExceptionHandler = iExceptionHandler;
        return this;
    }

    @Override
    public boolean isRequiresNewXMLParserExplicitly() {
        return this.m_bRequiresNewXMLParserExplicitly;
    }

    @Nonnull
    public final SAXReaderSettings setRequiresNewXMLParserExplicitly(boolean bl) {
        this.m_bRequiresNewXMLParserExplicitly = bl;
        return this;
    }

    @Override
    @Nonnull
    public SAXReaderSettings getClone() {
        return new SAXReaderSettings(this);
    }

    @Override
    public void applyToSAXReader(@Nonnull XMLReader xMLReader) {
        ValueEnforcer.notNull(xMLReader, "Parser");
        xMLReader.setContentHandler(this.getContentHandler());
        xMLReader.setDTDHandler(this.getDTDHandler());
        xMLReader.setEntityResolver(this.getEntityResolver());
        xMLReader.setErrorHandler(this.getErrorHandler());
        if (this.hasAnyProperties()) {
            for (Map.Entry<Enum, Object> entry : this.getAllPropertyValues().entrySet()) {
                ((EXMLParserProperty)entry.getKey()).applyTo(xMLReader, entry.getValue());
            }
        }
        if (this.hasAnyFeature()) {
            for (Map.Entry<Enum, Object> entry : this.getAllFeatureValues().entrySet()) {
                ((EXMLParserFeature)entry.getKey()).applyTo(xMLReader, (boolean)((Boolean)entry.getValue()));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("entityResolver", this.m_aEntityResolver).append("dtdHandler", this.m_aDTDHandler).append("contentHandler", this.m_aContentHandler).append("errorHandler", this.m_aErrorHandler).append("properties", this.m_aProperties).append("features", this.m_aFeatures).append("exceptionHandler", this.m_aExceptionHandler).append("requiresNewXMLParserExplicitly", this.m_bRequiresNewXMLParserExplicitly).toString();
    }

    @Nonnull
    public static SAXReaderSettings createCloneOnDemand(@Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iSAXReaderSettings == null) {
            return new SAXReaderSettings();
        }
        return new SAXReaderSettings(iSAXReaderSettings);
    }
}

