/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ErrorHandler {
    private final ErrorHandler m_aWrappedErrorHandler;

    protected AbstractSAXErrorHandler() {
        this(null);
    }

    public AbstractSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aWrappedErrorHandler = errorHandler;
    }

    @Nullable
    public ErrorHandler getWrappedErrorHandler() {
        return this.m_aWrappedErrorHandler;
    }

    @Nonnull
    public static IResourceError getSaxParseError(@Nonnull EErrorLevel eErrorLevel, @Nonnull SAXParseException sAXParseException) {
        String string = StringHelper.getConcatenatedOnDemand(sAXParseException.getPublicId(), "/", sAXParseException.getSystemId());
        ResourceLocation resourceLocation = new ResourceLocation(string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        return new ResourceError((IResourceLocation)resourceLocation, eErrorLevel, "[SAX] " + sAXParseException.getMessage());
    }

    protected abstract void internalLog(@Nonnull EErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.WARN, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(sAXParseException);
        }
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.ERROR, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.error(sAXParseException);
        }
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.FATAL_ERROR, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(sAXParseException);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("wrappedErrorHandler", this.m_aWrappedErrorHandler).toString();
    }
}

