/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class CharsetTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Charset.class, String.class, (ITypeConverter)new TypeConverterCharsetString());
        iTypeConverterRegistry.registerTypeConverter(String.class, Charset.class, (ITypeConverter)new TypeConverterStringCharset());
    }

    private static final class TypeConverterCharsetString
    implements ITypeConverter {
        private TypeConverterCharsetString() {
        }

        @Override
        @Nonnull
        public String convert(@Nonnull Object object) {
            return ((Charset)object).name();
        }
    }

    private static final class TypeConverterStringCharset
    implements ITypeConverter {
        private TypeConverterStringCharset() {
        }

        @Override
        public Charset convert(@Nonnull Object object) {
            return CharsetManager.getCharsetFromName((String)object);
        }
    }
}

