/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.microdom.EMicroEvent;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroCDATA;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroNodeWithChildren;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.TypeConverter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractMicroNodeWithChildren
extends AbstractMicroNode
implements IMicroNodeWithChildren {
    private List<IMicroNode> m_aChildren;

    @Nullable
    @ReturnsMutableObject(reason="efficient access")
    final List<IMicroNode> directGetChildren() {
        return this.m_aChildren;
    }

    private void _afterInsertAsChildOfThis(@Nonnull AbstractMicroNode abstractMicroNode) {
        abstractMicroNode.setParentNode(this);
        this.onEvent(EMicroEvent.NODE_INSERTED, this, abstractMicroNode);
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to documents");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<IMicroNode>();
        }
        this.m_aChildren.add(abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertBefore(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf(iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        this.m_aChildren.add(n, abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAfter(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf(iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        this.m_aChildren.add(n + 1, abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAtIndex(@Nonnegative int n, @Nonnull AbstractMicroNode abstractMicroNode) {
        if (n < 0) {
            throw new MicroException("Cannot insert element at index " + n + "!");
        }
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<IMicroNode>();
        }
        this.m_aChildren.add(Math.min(n, this.m_aChildren.size()), abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    private void _afterRemoveChildOfThis(@Nonnull IMicroNode iMicroNode) {
        if (this.m_aChildren.contains(iMicroNode)) {
            throw new IllegalStateException("Child " + iMicroNode + " is contained more than once in it's parents list");
        }
        if (this.m_aChildren.isEmpty()) {
            this.m_aChildren = null;
        }
        ((AbstractMicroNode)iMicroNode).resetParentNode();
        this.onEvent(EMicroEvent.NODE_REMOVED, this, iMicroNode);
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChild(@Nonnull IMicroNode iMicroNode) {
        if (!iMicroNode.hasParent()) {
            throw new MicroException("The passed child node to be removed has no parent!");
        }
        if (this.m_aChildren == null || !this.m_aChildren.remove(iMicroNode)) {
            return EChange.UNCHANGED;
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChildAtIndex(@Nonnegative int n) {
        IMicroNode iMicroNode = this.getChildAtIndex(n);
        if (iMicroNode == null) {
            return EChange.UNCHANGED;
        }
        if (!iMicroNode.hasParent()) {
            throw new MicroException("Internal inconsistency: the passed child node to be removed has no parent!");
        }
        if (this.m_aChildren.remove(n) != iMicroNode) {
            throw new MicroException("Internal inconsistency: remove resulted in an illegal object!");
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveAllChildren() {
        if (this.m_aChildren == null || this.m_aChildren.isEmpty()) {
            return EChange.UNCHANGED;
        }
        while (this.hasChildren()) {
            this.removeChildAtIndex(0);
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && !this.m_aChildren.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<IMicroNode> getChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    public final IMicroNode getChildAtIndex(@Nonnegative int n) {
        return ContainerHelper.getSafe(this.m_aChildren, n);
    }

    @Override
    public final int getChildCount() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.size();
    }

    @Override
    @Nullable
    public final IMicroNode getFirstChild() {
        return this.hasChildren() ? this.m_aChildren.get(0) : null;
    }

    @Override
    @Nullable
    public final IMicroNode getLastChild() {
        int n = this.getChildCount();
        return n == 0 ? null : this.m_aChildren.get(n - 1);
    }

    private void _fillListPrefix(@Nonnull IMicroNode iMicroNode, @Nonnull List<IMicroNode> list) {
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                list.add(iMicroNode2);
                this._fillListPrefix(iMicroNode2, list);
            }
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<IMicroNode> getAllChildrenRecursive() {
        ArrayList<IMicroNode> arrayList = new ArrayList<IMicroNode>();
        this._fillListPrefix(this, arrayList);
        return arrayList;
    }

    @Override
    @Nullable
    public String getTextContent() {
        if (!this.hasChildren()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode : this.directGetChildren()) {
            Object object;
            EMicroNodeType eMicroNodeType = iMicroNode.getType();
            if (eMicroNodeType == EMicroNodeType.TEXT) {
                object = (IMicroText)iMicroNode;
                if (((IMicroText)iMicroNode).isElementContentWhitespace()) continue;
                stringBuilder.append(object.getData());
                continue;
            }
            if (eMicroNodeType == EMicroNodeType.CDATA) {
                object = (IMicroCDATA)iMicroNode;
                stringBuilder.append(object.getNodeValue());
                continue;
            }
            if (!(iMicroNode instanceof IMicroNodeWithChildren) || !StringHelper.hasText((String)(object = ((IMicroNodeWithChildren)iMicroNode).getTextContent()))) continue;
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public String getTextContentTrimmed() {
        return StringHelper.trim(this.getTextContent());
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getTextContentWithConversion(@Nonnull Class<DSTTYPE> clazz) {
        String string = this.getTextContent();
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DSTTYPE DSTTYPE = TypeConverter.convertIfNecessary(string, clazz);
        return DSTTYPE;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        int n;
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        AbstractMicroNodeWithChildren abstractMicroNodeWithChildren = (AbstractMicroNodeWithChildren)iMicroNode;
        if (this.m_aChildren == null && abstractMicroNodeWithChildren.m_aChildren == null) {
            return true;
        }
        if (this.m_aChildren == null || abstractMicroNodeWithChildren.m_aChildren == null) {
            return false;
        }
        int n2 = this.m_aChildren.size();
        if (n2 != (n = abstractMicroNodeWithChildren.m_aChildren.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            IMicroNode iMicroNode2;
            IMicroNode iMicroNode3 = this.m_aChildren.get(i);
            if (iMicroNode3.isEqualContent(iMicroNode2 = abstractMicroNodeWithChildren.m_aChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("childrenCount", this.m_aChildren == null ? 0 : this.m_aChildren.size()).toString();
    }
}

