/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.WrappedOutputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingOutputStream
extends WrappedOutputStream {
    private long m_nBytesWritten = 0L;

    public CountingOutputStream(@Nonnull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.m_nBytesWritten;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.m_nBytesWritten += (long)n2;
    }

    @Nonnegative
    public long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesWritten", this.m_nBytesWritten).toString();
    }
}

