/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringReaderProvider
implements IReaderProvider,
Serializable {
    private final String m_sData;

    public StringReaderProvider(@Nonnull char[] cArray) {
        this(new String(cArray));
    }

    public StringReaderProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this(new String(cArray, n, n2));
    }

    public StringReaderProvider(@Nonnull CharSequence charSequence) {
        this(charSequence.toString());
    }

    public StringReaderProvider(@Nonnull String string) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringReaderProvider stringReaderProvider = (StringReaderProvider)object;
        return this.m_sData.equals(stringReaderProvider.m_sData);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).toString();
    }
}

