/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IReadWriteResource;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class FileSystemResource
implements IReadWriteResource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileSystemResource.class);
    private final File m_aFile;
    private final String m_sPath;
    private Integer m_aHashCode;

    public FileSystemResource(@Nonnull URI uRI) {
        this(new File(uRI));
    }

    public FileSystemResource(@Nonnull String string, @Nonnull String string2) {
        this(new File(string, string2));
    }

    public FileSystemResource(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemResource(@Nonnull File file, String string) {
        this(new File(file, string));
    }

    public FileSystemResource(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        String string = FilenameHelper.getCleanPath(file.getAbsolutePath());
        this.m_aFile = new File(string);
        this.m_sPath = this.m_aFile.getAbsolutePath();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        return FileUtils.getInputStream(file);
    }

    @Nullable
    @Deprecated
    public static Reader getReader(@Nonnull File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notEmpty(string, "Charset");
        return StreamUtils.createReader(FileSystemResource.getInputStream(file), string);
    }

    @Nullable
    public static Reader getReader(@Nonnull File file, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamUtils.createReader(FileSystemResource.getInputStream(file), charset);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return FileSystemResource.getInputStream(this.m_aFile);
    }

    @Override
    @Nullable
    @Deprecated
    public Reader getReader(@Nonnull @Nonempty String string) {
        return FileSystemResource.getReader(this.m_aFile, string);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return FileSystemResource.getReader(this.m_aFile, charset);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        return FileUtils.getOutputStream(file, eAppend);
    }

    @Nullable
    @Deprecated
    public static Writer getWriter(@Nonnull File file, @Nonnull @Nonempty String string, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notEmpty(string, "Charset");
        ValueEnforcer.notNull(eAppend, "Append");
        return StreamUtils.createWriter(FileSystemResource.getOutputStream(file, eAppend), string);
    }

    @Nullable
    public static Writer getWriter(@Nonnull File file, @Nonnull Charset charset, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(charset, "Charset");
        ValueEnforcer.notNull(eAppend, "Append");
        return StreamUtils.createWriter(FileSystemResource.getOutputStream(file, eAppend), charset);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull EAppend eAppend) {
        return FileSystemResource.getOutputStream(this.m_aFile, eAppend);
    }

    @Override
    @Nullable
    @Deprecated
    public Writer getWriter(@Nonnull @Nonempty String string, @Nonnull EAppend eAppend) {
        return FileSystemResource.getWriter(this.m_aFile, string, eAppend);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull Charset charset, @Nonnull EAppend eAppend) {
        return FileSystemResource.getWriter(this.m_aFile, charset, eAppend);
    }

    @Override
    public boolean exists() {
        return this.m_aFile.exists();
    }

    @Nullable
    public static URL getAsURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            s_aLogger.warn("Failed to convert file to URL: " + file, (Throwable)malformedURLException);
            return null;
        }
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return FileSystemResource.getAsURL(this.m_aFile);
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return this.m_aFile;
    }

    @Override
    @Nonnull
    public FileSystemResource getReadableCloneForPath(@Nonnull String string) {
        return new FileSystemResource(string);
    }

    @Override
    @Nonnull
    public FileSystemResource getWritableCloneForPath(@Nonnull String string) {
        return new FileSystemResource(string);
    }

    public boolean canRead() {
        return FileUtils.canRead(this.m_aFile);
    }

    public boolean canWrite() {
        return FileUtils.canWrite(this.m_aFile);
    }

    public boolean canExecute() {
        return FileUtils.canExecute(this.m_aFile);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FileSystemResource)) {
            return false;
        }
        FileSystemResource fileSystemResource = (FileSystemResource)object;
        return this.m_aFile.equals(fileSystemResource.m_aFile);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_aFile).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(null).append("file", this.m_aFile).toString();
    }
}

