/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.factory;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FactoryNewInstance<DATATYPE>
implements IFactory<DATATYPE>,
Serializable {
    private final Class<? extends DATATYPE> m_aClass;

    public FactoryNewInstance(@Nullable Class<? extends DATATYPE> clazz, boolean bl) {
        if (bl && !ClassHelper.isInstancableClass(clazz)) {
            throw new IllegalArgumentException("The passed class '" + clazz + "' is not instancable or doesn't have a no-argument constructor!");
        }
        this.m_aClass = clazz;
    }

    @Override
    @Nullable
    public DATATYPE create() {
        return GenericReflection.newInstance(this.m_aClass);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FactoryNewInstance)) {
            return false;
        }
        FactoryNewInstance factoryNewInstance = (FactoryNewInstance)object;
        return EqualsUtils.equals(this.m_aClass, factoryNewInstance.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("class", this.m_aClass).toString();
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz) {
        return FactoryNewInstance.create(clazz, false);
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz, boolean bl) {
        return new FactoryNewInstance<DATATYPE>(clazz, bl);
    }
}

