/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AnnotationUsageCache
implements Serializable {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Class<? extends Annotation> m_aAnnotationClass;
    @GuardedBy(value="m_aRWLock")
    private final Map<String, Boolean> m_aMap = new HashMap<String, Boolean>();

    public AnnotationUsageCache(@Nonnull Class<? extends Annotation> clazz) {
        RetentionPolicy retentionPolicy;
        ValueEnforcer.notNull(clazz, "AnnotationClass");
        Retention retention = clazz.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy2 = retentionPolicy = retention == null ? RetentionPolicy.CLASS : retention.value();
        if (retentionPolicy != RetentionPolicy.RUNTIME) {
            throw new IllegalArgumentException("RetentionPolicy must be of type RUNTIME to be used within this cache. The current value ist " + (Object)((Object)retentionPolicy));
        }
        this.m_aAnnotationClass = clazz;
    }

    @Nonnull
    public final Class<? extends Annotation> getAnnotationClass() {
        return this.m_aAnnotationClass;
    }

    public boolean hasAnnotation(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        return this.hasAnnotation(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnnotation(@Nonnull Class<?> clazz) {
        Boolean bl;
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        this.m_aRWLock.readLock().lock();
        try {
            bl = this.m_aMap.get(string);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (bl == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                bl = this.m_aMap.get(string);
                if (bl == null) {
                    bl = clazz.getAnnotation(this.m_aAnnotationClass) != null;
                    this.m_aMap.put(string, bl);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnotation(@Nonnull Class<?> clazz, boolean bl) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.put(string, bl);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("annotationClass", this.m_aAnnotationClass).append("map", this.m_aMap).toString();
    }
}

