/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons;

import com.phloc.commons.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalDebug {
    public static final boolean DEFAULT_TRACE_MODE = false;
    public static final boolean DEFAULT_DEBUG_MODE = false;
    public static final boolean DEFAULT_PRODUCTION_MODE = false;
    private static final AtomicBoolean s_aTraceMode = new AtomicBoolean(false);
    private static final AtomicBoolean s_aDebugMode = new AtomicBoolean(false);
    private static final AtomicBoolean s_aProductionMode = new AtomicBoolean(false);

    public void setTraceMode(boolean bl) {
        GlobalDebug.setTraceModeDirect(bl);
    }

    public void setDebugMode(boolean bl) {
        GlobalDebug.setDebugModeDirect(bl);
    }

    public void setProductionMode(boolean bl) {
        GlobalDebug.setProductionModeDirect(bl);
    }

    public static void setTraceModeDirect(boolean bl) {
        s_aTraceMode.set(bl);
        if (bl) {
            GlobalDebug.setDebugModeDirect(true);
        }
    }

    public static void setJavaCommonComponentsDebugMode(boolean bl) {
        SystemProperties.setPropertyValue("jaxp.debug", Boolean.toString(bl));
        SystemProperties.setPropertyValue("javax.activation.debug", Boolean.toString(bl));
        SystemProperties.setPropertyValue("mail.debug", Boolean.toString(bl));
    }

    public static void setDebugModeDirect(boolean bl) {
        s_aDebugMode.set(bl);
        GlobalDebug.setJavaCommonComponentsDebugMode(bl);
        if (!bl) {
            GlobalDebug.setTraceModeDirect(false);
        }
    }

    public static void setProductionModeDirect(boolean bl) {
        s_aProductionMode.set(bl);
        if (bl) {
            GlobalDebug.setDebugModeDirect(false);
        }
    }

    public static boolean isTraceMode() {
        return s_aTraceMode.get();
    }

    public static boolean isDebugMode() {
        return s_aDebugMode.get();
    }

    public static boolean isProductionMode() {
        return s_aProductionMode.get();
    }
}

