/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IPatFilter;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.PatFilterImpl;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Script;
import ch.elexis.data.Sticker;
import ch.rgw.tools.IFilter;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class PatListFilterBox
extends ListDisplay<PersistentObject>
implements IFilter {
    PersistentObjectDropTarget dropTarget;
    private static final String ETIKETTE = Messages.PatListFilterBox_Sticker;
    private static final String FELD = Messages.PatListFilterBox_Field;
    private static final String LEEREN = Messages.PatListFilterBox_DoEmpty;
    private static final String NB_PREFIX = "PLF_FLD:";
    private ArrayList<IPatFilter> filters = new ArrayList();
    private IPatFilter defaultFilter = new PatFilterImpl();
    private boolean parseError = false;
    private IAction removeFilterAction;

    PatListFilterBox(Composite parent) {
        super(parent, 0, null);
        this.setDLDListener(new ListDisplay.LDListener(){

            public String getLabel(Object o) {
                if (o instanceof NamedBlob) {
                    return String.valueOf(Messages.PatListFilterBox_Field2) + ((NamedBlob)o).getString();
                }
                if (o instanceof PersistentObject) {
                    return String.valueOf(o.getClass().getSimpleName()) + ":" + ((PersistentObject)o).getLabel();
                }
                return o.toString();
            }

            public void hyperlinkActivated(String l) {
                if (l.equals(LEEREN)) {
                    PatListFilterBox.this.clear();
                } else if (l.equals(ETIKETTE)) {
                    new EtikettenAuswahl().open();
                } else if (l.equals(FELD)) {
                    new FeldauswahlDlg().open();
                }
            }
        });
        this.makeActions();
        this.setMenu(new IAction[]{this.removeFilterAction});
        this.addHyperlinks(new String[]{FELD, ETIKETTE, LEEREN});
        this.dropTarget = new PersistentObjectDropTarget("Statfilter", (Control)this, (PersistentObjectDropTarget.IReceiver)new DropReceiver());
    }

    public void reset() {
        this.parseError = false;
    }

    public boolean aboutToStart() {
        for (PersistentObject cond : this.getAll()) {
            if (!(cond instanceof Script) || this.defaultFilter.aboutToStart(cond)) continue;
            return false;
        }
        return true;
    }

    public boolean finished() {
        for (PersistentObject cond : this.getAll()) {
            if (!(cond instanceof Script) || this.defaultFilter.finished(cond)) continue;
            return false;
        }
        return true;
    }

    public boolean select(Object toTest) {
        if (this.parseError) {
            return false;
        }
        if (toTest instanceof Patient) {
            Patient p = (Patient)toTest;
            for (final PersistentObject cond : this.getAll()) {
                boolean handled = false;
                for (IPatFilter filter : this.filters) {
                    int result = filter.accept(p, cond);
                    if (result == -1) {
                        return false;
                    }
                    if (result == 1) {
                        handled = true;
                        continue;
                    }
                    if (result != -2) continue;
                    this.parseError = true;
                }
                if (handled) continue;
                int result = this.defaultFilter.accept(p, cond);
                if (result == -1) {
                    return false;
                }
                if (result != -2) continue;
                UiDesk.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PatListFilterBox.this.remove(cond);
                    }
                });
                this.parseError = true;
            }
            return true;
        }
        return false;
    }

    public void addPatFilter(IPatFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(IPatFilter filter) {
        this.filters.remove(filter);
    }

    private void makeActions() {
        this.removeFilterAction = new Action(Messages.PatListFilterBox_removeAction){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.PatListFilterBox_removeToolTip);
            }

            public void run() {
                PersistentObject sel = (PersistentObject)PatListFilterBox.this.getSelection();
                PatListFilterBox.this.remove(sel);
            }
        };
    }

    private class DropReceiver
    implements PersistentObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        public void dropped(PersistentObject o, DropTargetEvent ev) {
            PatListFilterBox.this.add(o);
        }

        public boolean accept(PersistentObject o) {
            return !(o instanceof Script) || CoreHub.acl.request(AccessControlDefaults.SCRIPT_EXECUTE);
        }
    }

    class EtikettenAuswahl
    extends Dialog {
        List lEtiketten;
        Sticker[] etiketten;
        Sticker[] result;

        public EtikettenAuswahl() {
            super(PatListFilterBox.this.getShell());
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.PatListFilterBox_ChooseSticker);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.lEtiketten = new List(ret, 2);
            Query qbe = new Query(Sticker.class);
            this.etiketten = qbe.execute().toArray(new Sticker[0]);
            String[] etexts = new String[this.etiketten.length];
            int i = 0;
            while (i < this.etiketten.length) {
                etexts[i] = this.etiketten[i].getLabel();
                ++i;
            }
            this.lEtiketten.setItems(etexts);
            return ret;
        }

        protected void okPressed() {
            int[] indices = this.lEtiketten.getSelectionIndices();
            this.result = new Sticker[indices.length];
            int i = 0;
            while (i < indices.length) {
                PatListFilterBox.this.add(this.etiketten[indices[i]]);
                ++i;
            }
            super.okPressed();
        }
    }

    class FeldauswahlDlg
    extends Dialog {
        Text tFeld;
        Text tValue;
        Combo cbOp;
        public NamedBlob value;

        public FeldauswahlDlg() {
            super(PatListFilterBox.this.getShell());
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.PatListFilterBox_SetFilter);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(3, false));
            new Label(ret, 0).setText(Messages.PatListFilterBox_Field3);
            new Label(ret, 0).setText(" ");
            new Label(ret, 0).setText(Messages.PatListFilterBox_VValue);
            this.tFeld = new Text(ret, 2048);
            this.tFeld.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.cbOp = new Combo(ret, 12);
            this.cbOp.setItems(new String[]{"=", "LIKE", "Regexp"});
            this.cbOp.select(0);
            this.tValue = new Text(ret, 2048);
            this.tValue.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            return ret;
        }

        protected void okPressed() {
            String fld = this.tFeld.getText();
            if (fld.length() > 0) {
                this.value = NamedBlob.load((String)(PatListFilterBox.NB_PREFIX + fld));
                this.value.putString(String.valueOf(fld) + "::" + this.cbOp.getText() + "::" + this.tValue.getText());
                PatListFilterBox.this.add(this.value);
            }
            super.okPressed();
        }
    }
}

