/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.internal;

import ch.elexis.core.common.DBConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisPoolingDataSource
extends PoolingDataSource
implements DataSource {
    private static Logger log = LoggerFactory.getLogger(ElexisPoolingDataSource.class);
    private DBConnection dbConnection;
    private ObjectPool<Connection> connectionPool;

    public ElexisPoolingDataSource(DBConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public void activate() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.connectionPool = this.createConnectionPool(this.dbConnection);
        if (this.connectionPool != null) {
            this.setPool(this.connectionPool);
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Connection conn = this.getConnection();){
                    log.info("db connection pool [" + this.dbConnection.connectionString + "] initialization success");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.error("db connection pool [" + this.dbConnection.connectionString + "] initialization error", (Throwable)e);
            }
        } else {
            log.error("db connection pool [" + this.dbConnection.connectionString + "] initialization failed - no connection pool");
        }
    }

    public void deactivate() {
        if (this.connectionPool != null) {
            try {
                log.info("Deactivating, closing db connection pool");
                this.connectionPool.close();
            }
            catch (Exception e) {
                log.warn("Error closing db connection pool", (Throwable)e);
            }
        }
    }

    private ObjectPool<Connection> createConnectionPool(DBConnection dbConnection) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String driverName = StringUtils.defaultString((String)dbConnection.rdbmsType.driverName);
        String username = StringUtils.defaultString((String)dbConnection.username);
        String password = StringUtils.defaultString((String)dbConnection.password);
        String jdbcString = StringUtils.defaultString((String)dbConnection.connectionString);
        Driver driver = (Driver)Class.forName(driverName).newInstance();
        Properties properties = new Properties();
        properties.put("user", username);
        properties.put("password", password);
        log.info("db connection pool [" + driver + ", " + jdbcString + ", " + username + "] initialization");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory(driver, jdbcString, properties);
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMaxActive(32);
        connectionPool.setMinIdle(8);
        connectionPool.setMaxWait(10000L);
        connectionPool.setTestOnBorrow(true);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1;", false, true);
        return connectionPool;
    }

    @Override
    public Connection getConnection(String uname, String passwd) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return super.getConnection();
    }
}

