/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.fhir.model.service.FindingsModelService;
import ch.elexis.core.findings.fhir.model.service.FindingsModelServiceHolder;
import ch.elexis.core.findings.scripting.FindingsScriptingUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.ObservationAccessor;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ObservationLink;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class Observation
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.Observation>
implements IObservation {
    private static final String FORMAT_KEY_VALUE_SPLITTER = ":-:";
    private static final String FORMAT_SPLITTER = ":split:";
    private ObservationAccessor accessor = new ObservationAccessor();

    public Observation(ch.elexis.core.jpa.entities.Observation entity) {
        super(entity);
    }

    public String getId() {
        return ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getId();
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPatientId((DomainResource)resource.get(), patientId);
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setPatientId(patientId);
    }

    public List<ICoding> getCoding() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCoding((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setCoding(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCoding((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setContent(content);
    }

    public Optional<IEncounter> getEncounter() {
        String encounterId = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getEncounterId();
        if (encounterId != null && !encounterId.isEmpty()) {
            return ModelUtil.loadFinding((String)encounterId, IEncounter.class);
        }
        return Optional.empty();
    }

    public void setEncounter(IEncounter encounter) {
        String patientId;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.dstu3.model.Observation fhirObservation = (org.hl7.fhir.dstu3.model.Observation)resource.get();
            fhirObservation.setContext(new Reference((IIdType)new IdDt("Encounter", encounter.getId())));
            this.saveResource(resource.get());
        }
        if ((patientId = encounter.getPatientId()) != null && !patientId.isEmpty() && this.getPatientId() == null) {
            this.setPatientId(patientId);
        }
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setEncounterId(encounter.getId());
    }

    public Optional<LocalDateTime> getEffectiveTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEffectiveTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEffectiveTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEffectiveTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public IObservation.ObservationCategory getCategory() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCategory((DomainResource)resource.get());
        }
        return IObservation.ObservationCategory.UNKNOWN;
    }

    public void setCategory(IObservation.ObservationCategory category) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCategory((DomainResource)resource.get(), category);
            this.saveResource(resource.get());
        }
    }

    public List<IObservation> getTargetObseravtions(IObservationLink.ObservationLinkType type) {
        List typeSourceLinks = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getSourceLinks();
        typeSourceLinks = typeSourceLinks.stream().filter(ol -> ol.getType().equals(type.name())).collect(Collectors.toList());
        return typeSourceLinks.stream().map(ol -> FindingsModelService.getAdapter((EntityWithId)ol.getTarget(), IObservation.class)).collect(Collectors.toList());
    }

    public List<IObservation> getSourceObservations(IObservationLink.ObservationLinkType type) {
        List typeTargetLinks = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getTargetLinks();
        typeTargetLinks = typeTargetLinks.stream().filter(ol -> ol.getType().equals(type.name())).collect(Collectors.toList());
        return typeTargetLinks.stream().map(ol -> FindingsModelService.getAdapter((EntityWithId)ol.getSource(), IObservation.class)).collect(Collectors.toList());
    }

    public void addTargetObservation(IObservation target, IObservationLink.ObservationLinkType type) {
        if (target != null && target.getId() != null && this.getId() != null) {
            IObservationLink observationLink = (IObservationLink)ModelUtil.createFinding(IObservationLink.class);
            ObservationLink observationLinkEntity = FindingsModelService.getDBObject(observationLink, ObservationLink.class);
            observationLink.setTarget(target);
            FindingsModelService.getDBObject(target, ch.elexis.core.jpa.entities.Observation.class).getTargetLinks().add(observationLinkEntity);
            observationLink.setSource((IObservation)this);
            ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getSourceLinks().add(observationLinkEntity);
            observationLink.setType(type);
            FindingsModelServiceHolder.get().save(Arrays.asList(new Identifiable[]{observationLink, target, this}));
        }
    }

    public void addSourceObservation(IObservation source, IObservationLink.ObservationLinkType type) {
        if (source != null && source.getId() != null && this.getId() != null) {
            IObservationLink observationLink = (IObservationLink)ModelUtil.createFinding(IObservationLink.class);
            ObservationLink observationLinkEntity = FindingsModelService.getDBObject(observationLink, ObservationLink.class);
            observationLink.setSource(source);
            FindingsModelService.getDBObject(source, ch.elexis.core.jpa.entities.Observation.class).getSourceLinks().add(observationLinkEntity);
            observationLink.setTarget((IObservation)this);
            ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getTargetLinks().add(observationLinkEntity);
            observationLink.setType(type);
            FindingsModelServiceHolder.get().save(Arrays.asList(new Identifiable[]{observationLink, source, this}));
        }
    }

    public void removeTargetObservation(IObservation target, IObservationLink.ObservationLinkType type) {
        if (target != null && target.getId() != null && this.getId() != null) {
            List typeSourceLinks = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getSourceLinks();
            typeSourceLinks = typeSourceLinks.stream().filter(ol -> ol.getType().equals(type.name())).collect(Collectors.toList());
            ch.elexis.core.jpa.entities.Observation targetEntity = FindingsModelService.getDBObject(target, ch.elexis.core.jpa.entities.Observation.class);
            for (ObservationLink sourceLink : typeSourceLinks) {
                if (!sourceLink.getTarget().equals((Object)targetEntity)) continue;
                IObservationLink observationLink = FindingsModelService.getAdapter((EntityWithId)sourceLink, IObservationLink.class);
                observationLink.setTarget(null);
                targetEntity.getTargetLinks().remove(sourceLink);
                observationLink.setSource(null);
                ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getSourceLinks().remove(sourceLink);
                FindingsModelServiceHolder.get().save(Arrays.asList(new Identifiable[]{observationLink, target, this}));
                FindingsModelServiceHolder.get().remove((Identifiable)observationLink);
                break;
            }
        }
    }

    public void removeSourceObservation(IObservation source, IObservationLink.ObservationLinkType type) {
        if (source != null && source.getId() != null && this.getId() != null) {
            List typeTargetLinks = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getTargetLinks();
            typeTargetLinks = typeTargetLinks.stream().filter(ol -> ol.getType().equals(type.name())).collect(Collectors.toList());
            ch.elexis.core.jpa.entities.Observation sourceEntity = FindingsModelService.getDBObject(source, ch.elexis.core.jpa.entities.Observation.class);
            for (ObservationLink targetLink : typeTargetLinks) {
                if (!targetLink.getSource().equals((Object)sourceEntity)) continue;
                IObservationLink observationLink = FindingsModelService.getAdapter((EntityWithId)targetLink, IObservationLink.class);
                observationLink.setTarget(null);
                sourceEntity.getSourceLinks().remove(targetLink);
                observationLink.setSource(null);
                ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getTargetLinks().remove(targetLink);
                FindingsModelServiceHolder.get().save(Arrays.asList(new Identifiable[]{observationLink, source, this}));
                FindingsModelServiceHolder.get().remove((Identifiable)observationLink);
                break;
            }
        }
    }

    public void addComponent(ObservationComponent component) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.addComponent((DomainResource)resource.get(), component);
            this.saveResource(resource.get());
        }
    }

    public void updateComponent(ObservationComponent component) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.updateComponent((DomainResource)resource.get(), component);
            this.saveResource(resource.get());
        }
    }

    public List<ObservationComponent> getComponents() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getComponents((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setNumericValue(BigDecimal bigDecimal, String unit) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setNumericValue((DomainResource)resource.get(), bigDecimal, unit);
            this.saveResource(resource.get());
        }
    }

    public Optional<BigDecimal> getNumericValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            if (FindingsScriptingUtil.hasScript((IObservation)this)) {
                FindingsScriptingUtil.evaluate((IObservation)this);
                resource = this.loadResource();
            }
            return this.accessor.getNumericValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setStringValue(String value) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStringValue((DomainResource)resource.get(), value);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getStringValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStringValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setBooleanValue(Boolean value) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setBooleanValue((DomainResource)resource.get(), value);
            this.saveResource(resource.get());
        }
    }

    public Optional<Boolean> getBooleanValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getBooleanValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setDateTimeValue(Date value) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setDateTimeValue((DomainResource)resource.get(), value);
            this.saveResource(resource.get());
        }
    }

    public Optional<Date> getDateTimeValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getDateTimeValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public Optional<String> getNumericValueUnit() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getNumericValueUnit((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setObservationType(IObservation.ObservationType observationType) {
        if (observationType != null) {
            ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setType(observationType.name());
        }
    }

    public IObservation.ObservationType getObservationType() {
        String type = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getType();
        return type != null ? IObservation.ObservationType.valueOf((String)type) : null;
    }

    public boolean isReferenced() {
        return ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).isReferenced();
    }

    public void setReferenced(boolean referenced) {
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setReferenced(referenced);
    }

    public void setComment(String comment) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setComment((DomainResource)resource.get(), comment);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getComment() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getComment((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void addFormat(String key, String value) {
        StringBuilder builder = new StringBuilder(StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getFormat()));
        String dbValue = this.getFormat(key);
        String dbKeyValue = String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + dbValue;
        int idx = builder.indexOf(dbKeyValue);
        if (idx == -1) {
            if (builder.length() > 0) {
                builder.append(FORMAT_SPLITTER);
            }
            builder.append(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + value);
        } else {
            builder.replace(idx, idx + dbKeyValue.length(), String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + value);
        }
        ((ch.elexis.core.jpa.entities.Observation)this.getEntityMarkDirty()).setFormat(builder.toString());
    }

    public String getFormat(String key) {
        String[] splits;
        String format = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getFormat();
        if (format != null && format.contains(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER) && (splits = format.split(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER)).length > 1) {
            return splits[1].split(FORMAT_SPLITTER)[0];
        }
        return "";
    }

    public Optional<String> getScript() {
        String value = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getScript();
        if (value != null && !value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void setScript(String script) {
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setScript(script);
    }

    public int getDecimalPlace() {
        String value = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getDecimalplace();
        if (value != null && !value.isEmpty()) {
            return Integer.valueOf(value);
        }
        return -1;
    }

    public void setDecimalPlace(int value) {
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setDecimalplace(Integer.toString(value));
    }

    public Optional<String> getOriginUri() {
        String value = ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).getOriginuri();
        if (value != null && !value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void setOriginUri(String uri) {
        ((ch.elexis.core.jpa.entities.Observation)this.getEntity()).setOriginuri(uri);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        this.getCoding().stream().forEach(c -> {
            StringJoiner stringJoiner2 = sj.add(String.valueOf(c.getCode()) + "|" + c.getSystem());
        });
        return String.valueOf(super.toString()) + " coding [" + sj.toString() + "]";
    }
}

