/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.handler;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.ui.dlg.FindingsSelectionDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.ui.UiDesk;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FindingCreateHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FindingsTemplate selection;
        FindingsSelectionDialog findingsSelectionDialog = new FindingsSelectionDialog(Display.getDefault().getActiveShell(), FindingsServiceHolder.findingsTemplateService.getFindingsTemplates("Standard Vorlagen"), Collections.emptyList(), false, null, false);
        if (findingsSelectionDialog.open() == 0 && (selection = findingsSelectionDialog.getSingleSelection()) != null) {
            try {
                IFinding iFinding = FindingsServiceHolder.findingsTemplateService.createFinding(ElexisEventDispatcher.getSelectedPatient(), selection);
                Boolean okPressed = (Boolean)FindingsUiUtil.executeCommand((String)"ch.elexis.core.findings.ui.commandEdit", (IFinding)iFinding);
                if (okPressed.booleanValue()) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)iFinding, IFinding.class, 1, 10000)});
                    return iFinding;
                }
                try {
                    FindingsUiUtil.deleteFinding((IFinding)iFinding);
                }
                catch (ElexisException e) {
                    MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Fehler", (String)e.getMessage());
                }
            }
            catch (ElexisException e) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Befunde Vorlagen", (String)e.getMessage());
            }
        }
        return null;
    }
}

