/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.coding.internal;

import ch.elexis.core.coding.internal.model.ConceptList;
import ch.elexis.core.coding.internal.model.ValueSet;
import ch.elexis.core.coding.internal.model.ValueSets;
import ch.elexis.core.findings.ICoding;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class JsonValueSet {
    private ValueSet valueSet;

    public static Optional<JsonValueSet> load(String name) {
        try {
            Gson gson;
            ValueSets valueSets;
            InputStream jsonInput = JsonValueSet.class.getResourceAsStream("/rsc/valuesets/" + name + ".json");
            if (jsonInput != null && (valueSets = (ValueSets)(gson = new GsonBuilder().create()).fromJson(IOUtils.toString((InputStream)jsonInput, (String)"UTF-8"), ValueSets.class)).hasValueSet()) {
                return Optional.of(new JsonValueSet(valueSets.valueSets.get((int)0).valueSet.get(0)));
            }
        }
        catch (JsonSyntaxException | IOException e) {
            LoggerFactory.getLogger(JsonValueSet.class).error("Error oasing valueset [" + name + "]");
        }
        return Optional.empty();
    }

    public JsonValueSet(ValueSet valueSet) {
        this.valueSet = valueSet;
    }

    public String getId() {
        return this.valueSet.id;
    }

    public List<ICoding> getCoding() {
        if (this.valueSet.conceptList != null) {
            for (ConceptList cList : this.valueSet.conceptList) {
                if (cList.concept == null) continue;
                return cList.concept.stream().map(e -> e).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "JsonValueSet [valueSet=" + this.valueSet + "]";
    }

    public static String getSystemLanguage() {
        block16: {
            String language = Locale.getDefault().getLanguage();
            if (language == null) break block16;
            switch (language) {
                case "de": {
                    return "de-CH";
                }
                case "fr": {
                    return "fr-CH";
                }
                case "it": {
                    return "it-CH";
                }
                case "en": {
                    return "en-US";
                }
            }
        }
        return "de-CH";
    }
}

