/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IStock;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.StockEntry;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Stock
extends PersistentObject
implements ch.elexis.core.data.interfaces.IStock {
    public static final String TABLENAME = "STOCK";
    public static final String FLD_CODE = "CODE";
    public static final String FLD_PRIORITY = "PRIORITY";
    public static final String FLD_OWNER = "OWNER";
    public static final String FLD_RESPONSIBLE = "RESPONSIBLE";
    public static final String FLD_LOCATION = "LOCATION";
    public static final String FLD_DESCRIPTION = "DESCRIPTION";
    public static final String FLD_DRIVER_UUID = "DRIVER_UUID";
    public static final String FLD_DRIVER_CONFIG = "DRIVER_CONFIG";
    public static final String FLD_JOINT_STOCK_ENTRIES = "STOCK_ENTRIES";
    public static final String DEFAULT_STOCK_ID = "STD";

    static {
        Stock.addMapping(TABLENAME, "id", FLD_CODE, "PRIORITY=S:N:PRIORITY", FLD_OWNER, FLD_RESPONSIBLE, FLD_LOCATION, FLD_DESCRIPTION, FLD_DRIVER_UUID, FLD_DRIVER_CONFIG, "STOCK_ENTRIES=LIST:STOCK:STOCK_ENTRY");
    }

    protected Stock() {
    }

    protected Stock(String id) {
        super(id);
    }

    public Stock(String code, int globalPriority) {
        this.create(null);
        this.set(new String[]{FLD_CODE, FLD_PRIORITY}, code, Integer.toString(globalPriority));
    }

    public static Stock load(String id) {
        return new Stock(id);
    }

    @Override
    public String getLabel() {
        String[] values = this.get(false, FLD_CODE, FLD_DESCRIPTION);
        if (!StringUtils.isBlank((String)values[1])) {
            return "[" + values[0] + "] " + values[1];
        }
        return values[0];
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public boolean delete() {
        List<String> list = this.getList(FLD_JOINT_STOCK_ENTRIES, false);
        for (String id : list) {
            StockEntry.load(id).delete();
        }
        return super.delete();
    }

    @Override
    public boolean removeFromDatabase() {
        List<String> list = this.getList(FLD_JOINT_STOCK_ENTRIES, false, true);
        for (String id : list) {
            StockEntry.load(id).removeFromDatabase();
        }
        return super.removeFromDatabase();
    }

    @Override
    public Integer getPriority() {
        String val = this.get(FLD_PRIORITY);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPriority(Integer value) {
        this.setInt(FLD_PRIORITY, value);
    }

    @Override
    public String getCode() {
        return this.get(FLD_CODE);
    }

    public void setCode(String code) {
        this.set(FLD_CODE, code);
    }

    public String getDescription() {
        return this.get(FLD_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(FLD_DESCRIPTION, description);
    }

    public String getLocation() {
        return this.get(FLD_LOCATION);
    }

    public void setLocation(String location) {
        this.set(FLD_LOCATION, location);
    }

    @Override
    public Mandant getOwner() {
        String mandatorId = this.get(FLD_OWNER);
        if (StringUtils.isNotBlank((String)mandatorId)) {
            return Mandant.load(mandatorId);
        }
        return null;
    }

    public void setOwner(Mandant owner) {
        if (owner != null) {
            this.set(FLD_OWNER, owner.getId());
            return;
        }
        this.set(FLD_OWNER, null);
    }

    public Kontakt getResponsible() {
        String responsibleId = this.get(FLD_RESPONSIBLE);
        if (StringUtils.isNotBlank((String)responsibleId)) {
            return Kontakt.load(responsibleId);
        }
        return null;
    }

    public void setResponsible(Kontakt contact) {
        if (contact != null) {
            this.set(FLD_RESPONSIBLE, contact.getId());
            return;
        }
        this.set(FLD_RESPONSIBLE, null);
    }

    @Override
    public String getDriverUuid() {
        return this.get(FLD_DRIVER_UUID);
    }

    public void setDriverUuid(String driverUuid) {
        this.set(FLD_DRIVER_UUID, driverUuid);
    }

    @Override
    public String getDriverConfig() {
        return this.get(FLD_DRIVER_CONFIG);
    }

    public void setDriverConfig(String driverConfig) {
        this.set(FLD_DRIVER_CONFIG, driverConfig);
    }

    public IStock toIStock() {
        return (IStock)CoreModelServiceHolder.get().load(this.getId(), IStock.class).orElseThrow(() -> new IllegalStateException("Could not convert stock [" + this.getId() + "]"));
    }
}

