/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.cache.IPersistentObjectCache;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.interfaces.ISticker;
import ch.elexis.core.data.interfaces.IXid;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.data.util.DBUpdate;
import ch.elexis.core.data.util.SqlRunner;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.DBConnection;
import ch.elexis.data.DBLog;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.PersistentObjectUtil;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.elexis.data.Trace;
import ch.elexis.data.XML2Database;
import ch.elexis.data.Xid;
import ch.rgw.compress.CompEx;
import ch.rgw.io.ISettingChangedListener;
import ch.rgw.io.Settings;
import ch.rgw.io.SqlSettings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkConcurrencyException;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.JdbcLinkResourceException;
import ch.rgw.tools.JdbcLinkSyntaxException;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import ch.rgw.tools.VersionedResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentObject
implements IPersistentObject {
    public static final String MAPPING_ERROR_MARKER = "**ERROR:";
    public static final String FLD_ID = "id";
    public static final String FLD_EXTINFO = "ExtInfo";
    public static final String FLD_DELETED = "deleted";
    public static final String FLD_LASTUPDATE = "lastupdate";
    public static final String FLD_DATE = "Datum";
    protected static final String DATE_COMPOUND = "Datum=S:D:Datum";
    private static int MAX_INT_LENGTH = 10;
    protected static Logger log = LoggerFactory.getLogger((String)PersistentObject.class.getName());
    private String id;
    private static DBConnection defaultConnection;
    private DBConnection connection;
    private static Hashtable<String, String> mapping;
    public static final int INEXISTENT = 0;
    public static final int INVALID_ID = 1;
    public static final int DELETED = 2;
    public static final int EXISTS = 3;
    private final String queryStickersString = "SELECT etikette FROM ETIKETTEN_OBJECT_LINK WHERE obj=?";
    public static final int MATCH_EXACT = 0;
    public static final int MATCH_START = 1;
    public static final int MATCH_REGEXP = 2;
    public static final int MATCH_CONTAINS = 3;
    public static final int MATCH_AUTO = 4;

    static {
        mapping = new Hashtable();
    }

    public static DBConnection getDefaultConnection() {
        return defaultConnection;
    }

    protected DBConnection getDBConnection() {
        if (this.connection == null) {
            this.connection = defaultConnection;
        }
        return this.connection;
    }

    public void setDBConnection(DBConnection connection) {
        this.connection = connection;
    }

    public static boolean connect(Settings cfg) {
        Hashtable<Object, Object> hConn;
        DBConnection dbConnection = new DBConnection();
        dbConnection.setDBUser(System.getProperty("ch.elexis.dbUser"));
        dbConnection.setDBPassword(System.getProperty("ch.elexis.dbPw"));
        dbConnection.setDBFlavor(System.getProperty("ch.elexis.dbFlavor"));
        dbConnection.setDBConnectString(System.getProperty("ch.elexis.dbSpec"));
        if ("RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            dbConnection.setRunningFromScratch(true);
        }
        log.debug("osgi.install.area: " + System.getProperty("osgi.install.area"));
        String demoDBLocation = System.getProperty("demo.database.location");
        if (demoDBLocation == null) {
            demoDBLocation = CoreHub.getWritableUserDir() + File.separator + "demoDB";
        }
        File demo = new File(demoDBLocation);
        log.info("Checking demo database availability in " + demo.getAbsolutePath());
        if (demo.exists() && demo.isDirectory()) {
            log.info("Using demoDB in " + demo.getAbsolutePath());
            dbConnection.createH2Link(String.valueOf(demo.getAbsolutePath()) + File.separator + "db");
            try {
                String password;
                String username = System.getProperty("ch.elexis.dbUser");
                if (username == null) {
                    dbConnection.setDBUser("sa");
                }
                if ((password = System.getProperty("ch.elexis.dbPw")) == null) {
                    dbConnection.setDBPassword("");
                }
                return dbConnection.connect() && PersistentObject.connect(dbConnection);
            }
            catch (JdbcLinkException je) {
                ElexisStatus status = PersistentObject.translateJdbcException(je);
                status.setMessage(String.valueOf(status.getMessage()) + " Fehler mit Demo-Datenbank: Es wurde zwar ein demoDB-Verzeichnis gefunden, aber dort ist keine verwendbare Datenbank");
                throw new PersistenceException((IStatus)status);
            }
        }
        if (dbConnection.isDirectConnectConfigured()) {
            return PersistentObject.connect(dbConnection, true) && PersistentObject.connect(dbConnection);
        }
        if (dbConnection.isRunningFromScratch()) {
            try {
                dbConnection.runFromScatch();
                if (dbConnection.connect()) {
                    return PersistentObject.connect(dbConnection);
                }
                log.error("can't create test database");
                System.exit(-6);
            }
            catch (Exception ex) {
                log.error("can't create test database");
                System.exit(-7);
            }
        }
        if ((hConn = PersistentObject.getConnectionHashtable()) != null) {
            dbConnection.setDBDriver(PersistentObject.checkNull((String)hConn.get("driver")));
            dbConnection.setDBUser(PersistentObject.checkNull((String)hConn.get("user")));
            dbConnection.setDBPassword(PersistentObject.checkNull((String)hConn.get("pwd")));
            dbConnection.setDBFlavor(PersistentObject.checkNull((String)hConn.get("typ")));
            dbConnection.setDBConnectString(PersistentObject.checkNull((String)hConn.get("connectionstring")));
        }
        log.info("Driver is " + dbConnection.getDBDriver());
        try {
            log.info("Current work directory is " + new File(".").getCanonicalPath());
        }
        catch (IOException e) {
            log.error("Error determining current work directory", (Throwable)e);
        }
        if ("".equals(dbConnection.getDBDriver())) {
            CoreOperationAdvisorHolder.get().requestDatabaseConnectionConfiguration();
            MessageEvent.fireInformation("Datenbankverbindung ge\u00e4ndert", "Bitte starten Sie Elexis erneut");
            System.exit(0);
        }
        try {
            dbConnection.connect();
        }
        catch (JdbcLinkException je) {
            ElexisStatus status = PersistentObject.translateJdbcException(je);
            status.setLogLevel(1);
            throw new PersistenceException((IStatus)status);
        }
        return PersistentObject.connect(dbConnection);
    }

    @NonNull
    public static Hashtable<Object, Object> getConnectionHashtable() {
        Hashtable<Object, Object> ret = new Hashtable<Object, Object>();
        String cnt = CoreHub.localCfg.get("verbindung/folded_string", null);
        if (cnt != null) {
            log.debug("Read connection string from localCfg");
            ret = PersistentObject.fold(StringTool.dePrintable((String)cnt));
        }
        return ret;
    }

    private static boolean connect(DBConnection dbConnection, boolean exitOnFail) {
        try {
            boolean connected = dbConnection.directConnect();
            if (!connected) {
                String msg2 = "can't connect to test database: " + dbConnection.getDBConnectString() + " using " + dbConnection.getDBFlavor();
                log.error(msg2);
                if (exitOnFail) {
                    System.exit(-6);
                }
            }
            return connected;
        }
        catch (Exception ex) {
            String msg3 = "Exception connecting to test database:" + dbConnection.getDBConnectString() + " using " + dbConnection.getDBFlavor() + ": " + ex.getMessage();
            log.error(msg3);
            if (exitOnFail) {
                System.exit(-7);
            }
            return false;
        }
    }

    public static boolean connect(JdbcLink jdbcLink) {
        DBConnection dbConnection = new DBConnection();
        dbConnection.setJdbcLink(jdbcLink);
        return PersistentObject.connect(dbConnection);
    }

    public static boolean connect(DBConnection connection) {
        defaultConnection = connection;
        if (connection.isRunningFromScratch()) {
            PersistentObject.deleteAllTables();
        }
        if (PersistentObject.tableExists("CONFIG")) {
            CoreHub.globalCfg = new SqlSettings(connection.getJdbcLink(), "CONFIG");
            String created = CoreHub.globalCfg.get("created", null);
            log.debug("Database version " + created);
        }
        return true;
    }

    public static boolean legacyPostInitDB() {
        if (CoreHub.globalCfg == null || CoreHub.globalCfg.get("created", null) == null) {
            log.info("PO data initialization");
            try {
                PersistentObjectUtil.initializeGlobalCfg(defaultConnection);
                Mandant.initializeAdministratorUser();
                CoreHub.pin.initializeGrants();
                CoreHub.pin.initializeGlobalPreferences();
                Mandant bypassMandator = PersistentObjectUtil.autoCreateFirstMandant(defaultConnection.isRunningFromScratch());
                if (bypassMandator == null) {
                    CoreOperationAdvisorHolder.get().requestInitialMandatorConfiguration();
                    MessageEvent.fireInformation("Neue Datenbank", "Es wurde eine neue Datenbank angelegt.");
                } else {
                    log.info("Bypassed mandator initialization dialog, auto-created Mandator [{}] {}", (Object)bypassMandator.getId(), (Object)bypassMandator.getPersonalia());
                }
                CoreHub.globalCfg.flush();
                CoreHub.localCfg.flush();
            }
            catch (Throwable ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
        }
        CoreHub.globalCfg.setSettingChangedListener(new ISettingChangedListener(){

            public void settingRemoved(String key) {
                Trace.addTraceEntry("W globalCfg key [" + key + "] => removed");
            }

            public void settingWritten(String key, String value) {
                Trace.addTraceEntry("W globalCfg key [" + key + "] => value [" + value + "]");
            }
        });
        CoreHub.userCfg.setSettingChangedListener(new ISettingChangedListener(){

            public void settingRemoved(String key) {
                String userId = CoreHub.getLoggedInContact() != null ? CoreHub.getLoggedInContact().getWrappedId() : "null";
                Trace.addTraceEntry("W userCfg [" + userId + "] key [" + key + "] => removed");
            }

            public void settingWritten(String key, String value) {
                String userId = CoreHub.getLoggedInContact() != null ? CoreHub.getLoggedInContact().getWrappedId() : "null";
                Trace.addTraceEntry("W userCfg [" + userId + "] key [" + key + "] => value [" + value + "]");
            }
        });
        VersionInfo vi = new VersionInfo(CoreHub.globalCfg.get("dbversion", "0.0.0"));
        log.info("Verlangte Datenbankversion: {}", (Object)"3.7.0");
        log.info("Gefundene Datenbankversion: {}", (Object)vi.version());
        if (vi.isOlder("3.7.0")) {
            log.warn("\u00c4ltere Version der Datenbank gefunden ");
            if (!DBUpdate.doUpdate()) {
                String msg2 = String.format("Datenbank '%1s':\nUpdate auf '%2s' von '%3s' schlug fehlt.\nWollen Sie trotzdem fortsetzen?", defaultConnection.getDBConnectString(), vi.version().toString(), "3.7.0");
                log.error(msg2);
                if (!CoreOperationAdvisorHolder.get().openQuestion("Datenbank update failed ", msg2)) {
                    System.exit(8);
                } else {
                    log.error("User continues with failed Elexis database update");
                }
            }
        }
        vi = new VersionInfo(CoreHub.globalCfg.get("ElexisVersion", "0.0.0"));
        log.info("Verlangte Elexis-Version: " + vi.version());
        log.info("Vorhandene Elexis-Version: " + CoreHub.Version);
        VersionInfo v2 = new VersionInfo(CoreHub.Version);
        if (vi.isNewerMinor(v2)) {
            String msg3 = String.format("Die Datenbank %1s ist f\u00fcr eine neuere Elexisversion '%2s' als die aufgestartete '%3s'. Wollen Sie trotzdem fortsetzen?", defaultConnection.getDBConnectString(), vi.version().toString(), v2.version().toString());
            log.error(msg3);
            if (!CoreOperationAdvisorHolder.get().openQuestion("Diskrepanz in der Datenbank-Version ", msg3)) {
                System.exit(2);
            } else {
                log.error("User continues with Elexis / database version mismatch");
            }
        }
        Locale locale = Locale.getDefault();
        String dbStoredLocale = CoreHub.globalCfg.get("locale", null);
        if (dbStoredLocale == null) {
            CoreHub.globalCfg.set("locale", locale.toString());
            CoreHub.globalCfg.flush();
        } else if (!locale.toString().equals(dbStoredLocale)) {
            String msg4 = String.format("Your locale [%1s] does not match the required database locale [%2s] as specified in config table. Ignore?", locale.toString(), dbStoredLocale);
            log.error(msg4);
            if (!CoreOperationAdvisorHolder.get().openQuestion("Difference in locale setting ", msg4)) {
                System.exit(2);
            } else {
                log.error("User continues with difference locale set");
            }
        }
        return true;
    }

    public static JdbcLink getConnection() {
        return defaultConnection.getJdbcLink();
    }

    protected static void addMapping(String prefix, String ... map) {
        String[] stringArray = map;
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] def = s.trim().split("[ \t]*=[ \t]*");
            if (def.length != 2) {
                mapping.put(String.valueOf(prefix) + def[0], def[0]);
            } else {
                mapping.put(String.valueOf(prefix) + def[0], def[1]);
            }
            ++n2;
        }
        mapping.put(String.valueOf(prefix) + FLD_DELETED, FLD_DELETED);
        mapping.put(String.valueOf(prefix) + FLD_LASTUPDATE, FLD_LASTUPDATE);
    }

    public static synchronized String lock(String name, boolean wait) {
        JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
        String lockname = "lock" + name;
        String lockid = StringTool.unique((String)"lock");
        try {
            while (true) {
                long timestamp = System.currentTimeMillis();
                String oldlock = stm.queryString("SELECT wert FROM CONFIG WHERE param=" + PersistentObject.getConnection().wrapFlavored(lockname));
                if (!StringTool.isNothing((Object)oldlock)) {
                    String[] def = oldlock.split("#");
                    long locktime = Long.parseLong(def[1]);
                    long age = timestamp - locktime;
                    if (age > 2000L) {
                        stm.exec("DELETE FROM CONFIG WHERE param=" + PersistentObject.getConnection().wrapFlavored(lockname));
                    } else {
                        if (wait) continue;
                        return null;
                    }
                }
                String lockstring = String.valueOf(lockid) + "#" + Long.toString(System.currentTimeMillis());
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO CONFIG (param,wert) VALUES (").append(JdbcLink.wrap((String)lockname)).append(",").append("'").append(lockstring).append("')");
                stm.exec(sb.toString());
                String check = stm.queryString("SELECT wert FROM CONFIG WHERE param=" + PersistentObject.getConnection().wrapFlavored(lockname));
                if (check.equals(lockstring)) break;
            }
            String string = lockid;
            return string;
        }
        finally {
            PersistentObject.getConnection().releaseStatement(stm);
        }
    }

    public static synchronized boolean unlock(String name, String id) {
        String lockname = "lock" + name;
        String lock = PersistentObject.getConnection().queryString("SELECT wert from CONFIG WHERE param=" + PersistentObject.getConnection().wrapFlavored(lockname));
        if (StringTool.isNothing((Object)lock)) {
            return false;
        }
        String[] res = lock.split("#");
        if (res[0].equals(id)) {
            PersistentObject.getConnection().exec("DELETE FROM CONFIG WHERE param=" + PersistentObject.getConnection().wrapFlavored(lockname));
            return true;
        }
        return false;
    }

    protected String getConstraint() {
        return "";
    }

    protected void setConstraint() {
    }

    @Override
    public abstract String getLabel();

    protected abstract String getTableName();

    @Override
    public boolean isValid() {
        return this.state() >= 3;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getWrappedId() {
        return this.getDBConnection().getJdbcLink().wrapFlavored(this.id);
    }

    protected PersistentObject() {
        this.id = StringTool.unique((String)"prso");
    }

    protected PersistentObject(String id) {
        this.id = id;
    }

    @Override
    public String storeToString() {
        return String.valueOf(this.getClass().getName()) + "::" + this.getId();
    }

    @Override
    public int state() {
        block4: {
            String deleted;
            block5: {
                if (StringTool.isNothing((Object)this.getId()) || this.getId().contains("'")) {
                    return 1;
                }
                StringBuilder sb = new StringBuilder("SELECT ID FROM ");
                sb.append(this.getTableName()).append(" WHERE ID=").append(this.getWrappedId());
                try {
                    String obj = this.getDBConnection().queryString(sb.toString());
                    if (!this.id.equalsIgnoreCase(obj)) break block4;
                    deleted = this.get(FLD_DELETED);
                    if (deleted != null) break block5;
                    return 3;
                }
                catch (JdbcLinkSyntaxException ex) {
                    return 0;
                }
            }
            return deleted.equals("1") ? 2 : 3;
        }
        return 0;
    }

    @Override
    public boolean exists() {
        return this.state() == 3;
    }

    @Override
    public boolean isAvailable() {
        return this.state() >= 2;
    }

    @Override
    public String getXid(String domain) {
        if (domain.equals("www.elexis.ch/xid")) {
            return this.getId();
        }
        Query qbe = new Query(Xid.class);
        qbe.add("object", "=", this.getId());
        qbe.add("domain", "=", domain);
        List res = qbe.execute();
        if (res.size() > 0) {
            return ((Xid)res.get(0)).get("domain_id");
        }
        return "";
    }

    @Override
    public IXid getXid() {
        List<IXid> res = this.getXids();
        if (res.size() == 0) {
            try {
                return new Xid(this, "www.elexis.ch/xid", this.getId());
            }
            catch (Xid.XIDException xex) {
                ExHandler.handle((Throwable)xex);
                return null;
            }
        }
        int quality = 0;
        IXid ret = null;
        for (IXid xid : res) {
            if (xid.getQuality() <= quality) continue;
            quality = xid.getQuality();
            ret = xid;
        }
        if (ret == null) {
            return res.get(0);
        }
        return ret;
    }

    @Override
    public List<IXid> getXids() {
        Query qbe = new Query(Xid.class);
        qbe.add("object", "=", this.getId());
        return qbe.execute();
    }

    @Override
    public boolean addXid(String domain, String domain_id, boolean updateIfExists) {
        Xid oldXID = Xid.findXID(this, domain);
        if (oldXID != null) {
            if (updateIfExists) {
                oldXID.set("domain_id", domain_id);
                return true;
            }
            return false;
        }
        try {
            new Xid(this, domain, domain_id);
            return true;
        }
        catch (Xid.XIDException e) {
            Xid xid;
            ExHandler.handle((Throwable)e);
            if (updateIfExists && (xid = Xid.findXID(domain, domain_id)) != null) {
                xid.set("object", this.getId());
                return true;
            }
            return false;
        }
    }

    public ISticker getSticker() {
        List<ISticker> list = this.getStickers();
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<ISticker> getStickers() {
        DBConnection dbConnection = this.getDBConnection();
        String ID = "ETK" + this.getId();
        ArrayList<ISticker> ret = (ArrayList<ISticker>)dbConnection.getCache().get(ID, this.getCacheTime());
        if (ret != null) {
            return ret;
        }
        ret = new ArrayList<ISticker>();
        PreparedStatement queryStickers = dbConnection.getPreparedStatement("SELECT etikette FROM ETIKETTEN_OBJECT_LINK WHERE obj=?");
        try {
            try {
                queryStickers.setString(1, this.id);
                Throwable throwable = null;
                Object var6_8 = null;
                try (ResultSet res = queryStickers.executeQuery();){
                    while (res.next()) {
                        Sticker et = Sticker.load(res.getString(1));
                        et.setDBConnection(dbConnection);
                        if (et == null || !et.exists()) continue;
                        ret.add(et);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                ArrayList<ISticker> arrayList = ret;
                try {
                    queryStickers.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dbConnection.releasePreparedStatement(queryStickers);
                return arrayList;
            }
        }
        finally {
            try {
                queryStickers.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(queryStickers);
        }
        Collections.sort(ret);
        dbConnection.getCache().put(ID, ret, this.getCacheTime());
        return ret;
    }

    public void removeSticker(ISticker et) {
        String remove;
        DBConnection dbConnection;
        int exec;
        List<ISticker> ret = this.getStickers();
        if (ret.contains(et) && (exec = (dbConnection = this.getDBConnection()).exec(remove = "DELETE FROM ETIKETTEN_OBJECT_LINK WHERE obj=" + this.getWrappedId() + " AND etikette=" + this.getDBConnection().getJdbcLink().wrapFlavored(et.getId()))) > 0) {
            ret.remove(et);
            Collections.sort(ret);
            this.refreshLastUpdateAndSendUpdateEvent("ETIKETTEN_OBJECT_LINK");
        }
    }

    public void addSticker(ISticker st) {
        String update;
        DBConnection dbConnection;
        int exec;
        List<ISticker> ret = this.getStickers();
        if (!ret.contains(st) && (exec = (dbConnection = this.getDBConnection()).exec(update = "INSERT INTO ETIKETTEN_OBJECT_LINK (obj,etikette,lastupdate) VALUES (" + this.getWrappedId() + "," + this.getDBConnection().getJdbcLink().wrapFlavored(st.getId()) + "," + Long.toString(System.currentTimeMillis()) + ")")) == 1) {
            ret.add(st);
            Collections.sort(ret);
            this.refreshLastUpdateAndSendUpdateEvent("ETIKETTEN_OBJECT_LINK");
        }
    }

    @Override
    public boolean isDeleted() {
        return this.get(FLD_DELETED).trim().equals("1");
    }

    public boolean isDragOK() {
        return false;
    }

    public String map(String f) {
        String prefix = this.getTableName();
        return PersistentObject.map(prefix, f);
    }

    public static String map(String tableName, String field) {
        return PersistentObject.map(tableName, field, true);
    }

    public static String map(String tableName, String field, boolean markAsError) {
        if (FLD_ID.equalsIgnoreCase(field)) {
            return field;
        }
        String res = mapping.get(String.valueOf(tableName) + field);
        if (res == null && markAsError) {
            log.info("field is not mapped " + field);
            return MAPPING_ERROR_MARKER + field + "**";
        }
        return res;
    }

    public FieldType getFieldType(String f) {
        String mapped = this.map(f);
        if (mapped.startsWith("LIST:")) {
            return FieldType.LIST;
        }
        if (mapped.startsWith("JOINT:")) {
            return FieldType.JOINT;
        }
        return FieldType.TEXT;
    }

    @Override
    @Nullable
    public String get(String field) {
        if (this.getId() == null || this.getId().isEmpty()) {
            log.error("Get with no ID on object of type [{}] and field [{}]", new Object[]{this.getClass().getName(), field, new Throwable()});
        }
        DBConnection dbConnection = this.getDBConnection();
        String key = this.getKey(field);
        Object ret = dbConnection.getCache().get(key, this.getCacheTime());
        if (ret instanceof String) {
            return (String)ret;
        }
        boolean decrypt = false;
        StringBuffer sql = new StringBuffer();
        String mapped = this.map(field);
        String table = this.getTableName();
        if (mapped.startsWith("EXT:")) {
            int ix = mapped.indexOf(58, 5);
            if (ix == -1) {
                log.error("Fehlerhaftes Mapping bei " + field);
                return "**ERROR: " + field + "**";
            }
            table = mapped.substring(4, ix);
            mapped = mapped.substring(ix + 1);
        } else if (mapped.startsWith("S:")) {
            mapped = mapped.substring(4);
            decrypt = true;
        } else if (mapped.startsWith("JOINT:")) {
            String[] dwf = mapped.split(":");
            if (dwf.length > 4) {
                String objdef = String.valueOf(dwf[4]) + "::";
                StringBuilder sb = new StringBuilder();
                List<String[]> list = this.getList(field, new String[0]);
                PersistentObjectFactory fac = new PersistentObjectFactory();
                for (String[] s : list) {
                    PersistentObject po = fac.createFromString(String.valueOf(objdef) + s[0], this.getDBConnection());
                    sb.append(po.getLabel()).append("\n");
                }
                return sb.toString();
            }
        } else if (mapped.startsWith("LIST:")) {
            String[] dwf = mapped.split(":");
            if (dwf.length > 4) {
                String objdef = String.valueOf(dwf[4]) + "::";
                StringBuilder sb = new StringBuilder();
                List<String> list = this.getList(field, false);
                PersistentObjectFactory fac = new PersistentObjectFactory();
                for (String s : list) {
                    PersistentObject po = fac.createFromString(String.valueOf(objdef) + s, this.getDBConnection());
                    sb.append(po.getLabel()).append("\n");
                }
                return sb.toString();
            }
        } else if (mapped.startsWith(MAPPING_ERROR_MARKER)) {
            Object ro;
            block41: {
                Map ht;
                Object res;
                String exi = this.map(FLD_EXTINFO);
                if (!exi.startsWith(MAPPING_ERROR_MARKER) && (res = (ht = this.getMap(FLD_EXTINFO)).get(field)) instanceof String) {
                    return (String)res;
                }
                String xid = this.getXid(field);
                if (xid.length() > 0) {
                    return xid;
                }
                String method = "get" + field;
                Method mx = this.getClass().getMethod(method, new Class[0]);
                ro = mx.invoke((Object)this, new Object[0]);
                if (ro != null) break block41;
                return "";
            }
            try {
                if (ro instanceof String) {
                    return (String)ro;
                }
                if (ro instanceof Integer) {
                    return Integer.toString((Integer)ro);
                }
                if (ro instanceof PersistentObject) {
                    return ((PersistentObject)ro).getLabel();
                }
                return "?invalid field? " + mapped;
            }
            catch (NoSuchMethodException nmex) {
                log.warn("Fehler bei Felddefinition " + field);
                ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.data", 1, "Fehler bei Felddefinition", nmex);
                ElexisEventDispatcher.fireElexisStatusEvent(status);
                return mapped;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                return mapped;
            }
        }
        sql.append("SELECT ").append(mapped).append(" FROM ").append(table).append(" WHERE ID='").append(this.id).append("'");
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        String res = null;
        try {
            try {
                Throwable method = null;
                Object var12_29 = null;
                try (ResultSet rs = this.executeSqlQuery(sql.toString(), stm);){
                    if (rs != null && rs.next()) {
                        res = decrypt ? this.decode(field, rs) : rs.getString(mapped);
                        this.getDBConnection().getCache().put(key, res, this.getCacheTime());
                        if (res == null) {
                            res = "";
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (method == null) {
                        method = throwable;
                    } else if (method != throwable) {
                        method.addSuppressed(throwable);
                    }
                    throw method;
                }
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
                this.getDBConnection().releaseStatement(stm);
            }
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
        return res;
    }

    protected String getRaw(String field) {
        StringBuffer sql = new StringBuffer();
        String mapped = this.map(field);
        String table = this.getTableName();
        sql.append("SELECT ").append(mapped).append(" FROM ").append(table).append(" WHERE ID='").append(this.id).append("'");
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        String res = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (ResultSet rs = this.executeSqlQuery(sql.toString(), stm);){
                    if (rs != null && rs.next()) {
                        res = rs.getString(mapped);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
                this.getDBConnection().releaseStatement(stm);
            }
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
        return res;
    }

    public byte[] getBinary(String field) {
        String key = this.getKey(field);
        Object o = this.getDBConnection().getCache().get(key, this.getCacheTime());
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        byte[] ret = this.getBinaryRaw(field);
        this.getDBConnection().getCache().put(key, ret, this.getCacheTime());
        return ret;
    }

    /*
     * Loose catch block
     */
    private byte[] getBinaryRaw(String field) {
        block18: {
            StringBuilder sql = new StringBuilder();
            String mapped = field;
            String table = this.getTableName();
            sql.append("SELECT ").append(mapped).append(" FROM ").append(table).append(" WHERE ID='").append(this.id).append("'");
            JdbcLink.Stm stm = this.getDBConnection().getStatement();
            try {
                ResultSet rs;
                Throwable throwable;
                block16: {
                    byte[] byArray;
                    block17: {
                        throwable = null;
                        Object var7_9 = null;
                        rs = this.executeSqlQuery(sql.toString(), stm);
                        if (rs == null || !rs.next()) break block16;
                        byArray = rs.getBytes(mapped);
                        if (rs == null) break block17;
                        rs.close();
                    }
                    return byArray;
                }
                try {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block18;
                        {
                            catch (Throwable throwable2) {
                                if (rs != null) {
                                    rs.close();
                                }
                                throw throwable2;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
            finally {
                this.getDBConnection().releaseStatement(stm);
            }
        }
        return null;
    }

    protected VersionedResource getVersionedResource(String field, boolean flushCache) {
        Object o;
        String key = this.getKey(field);
        if (!flushCache && (o = this.getDBConnection().getCache().get(key, this.getCacheTime())) instanceof VersionedResource) {
            return (VersionedResource)o;
        }
        byte[] blob = this.getBinaryRaw(field);
        VersionedResource ret = VersionedResource.load((byte[])blob);
        this.getDBConnection().getCache().put(key, ret, this.getCacheTime());
        return ret;
    }

    @NonNull
    public Map getMap(String field) {
        String key = this.getKey(field);
        Object o = this.getDBConnection().getCache().get(key, this.getCacheTime());
        if (o instanceof Hashtable) {
            return (Hashtable)o;
        }
        byte[] blob = this.getBinaryRaw(field);
        if (blob == null) {
            return new Hashtable();
        }
        Hashtable<Object, Object> ret = PersistentObject.fold(blob);
        if (ret == null) {
            return new Hashtable();
        }
        this.getDBConnection().getCache().put(key, ret, this.getCacheTime());
        return ret;
    }

    @Nullable
    public Object getExtInfoStoredObjectByKey(Object key) {
        byte[] binaryRaw = this.getBinaryRaw(FLD_EXTINFO);
        if (binaryRaw == null) {
            return null;
        }
        Map ext = this.getMap(FLD_EXTINFO);
        return ext.get(key);
    }

    public void setExtInfoStoredObjectByKey(Object key, Object value) {
        Map extinfo = this.getMap(FLD_EXTINFO);
        if (value == null) {
            extinfo.remove(key);
        } else {
            extinfo.put(key, value);
        }
        this.setMap(FLD_EXTINFO, extinfo);
    }

    public int getInt(String field) {
        return PersistentObject.checkZero(this.get(field));
    }

    public boolean getBoolean(String field) {
        String val = this.get(field);
        return "1".equals(val);
    }

    public TristateBoolean getTriStateBoolean(String field) {
        String value = this.get(field);
        if (value == null) {
            return TristateBoolean.UNDEF;
        }
        if (value.equalsIgnoreCase("1")) {
            return TristateBoolean.TRUE;
        }
        if (value.equalsIgnoreCase("0")) {
            return TristateBoolean.FALSE;
        }
        return TristateBoolean.UNDEF;
    }

    public void setTriStateBoolean(String field, TristateBoolean newVal) throws IllegalArgumentException, PersistenceException {
        boolean result;
        if (newVal == null) {
            throw new IllegalArgumentException("PersistentObject.setTriStateBoolean(): param newVal == null");
        }
        String saveVal = "";
        if (newVal == TristateBoolean.TRUE) {
            saveVal = "1";
        }
        if (newVal == TristateBoolean.FALSE) {
            saveVal = "0";
        }
        if (newVal == TristateBoolean.UNDEF) {
            saveVal = "";
        }
        if (!(result = this.set(field, saveVal))) {
            throw new PersistenceException((IStatus)new ElexisStatus(4, "ch.elexis.core.data", 0, "PersistentObject.setTriStateBoolean(): Error on saving value " + (Object)((Object)newVal) + " to field " + field, null));
        }
    }

    public List<String> getList(String field, boolean reverse) {
        return this.getList(field, reverse, false);
    }

    public List<String> getList(String field, boolean reverse, boolean includeDeleted) {
        StringBuffer sql = new StringBuffer();
        String mapped = this.map(field);
        if (mapped.startsWith("LIST:")) {
            String[] m = mapped.split(":");
            if (m.length > 2) {
                sql.append("SELECT ID FROM ").append(m[2]).append(" WHERE ");
                if (!includeDeleted) {
                    sql.append("deleted=").append(this.getDBConnection().getJdbcLink().wrapFlavored("0")).append(" AND ");
                }
                sql.append(m[1]).append("=").append(this.getWrappedId());
                if (m.length > 3) {
                    sql.append(" ORDER by ").append(m[3]);
                    if (reverse) {
                        sql.append(" DESC");
                    }
                }
                JdbcLink.Stm stm = this.getDBConnection().getStatement();
                Vector ret = stm.queryList(sql.toString(), new String[]{"ID"});
                this.getDBConnection().releaseStatement(stm);
                return ret;
            }
        } else {
            log.error("Fehlerhaftes Mapping " + mapped);
        }
        return null;
    }

    public List<String[]> getList(String field, String[] extra) {
        String mapped;
        if (extra == null) {
            extra = new String[]{};
        }
        if ((mapped = this.map(field)).startsWith("JOINT:")) {
            StringBuffer sql = new StringBuffer();
            String[] abfr = mapped.split(":");
            sql.append("SELECT ").append(abfr[1]);
            String[] stringArray = extra;
            int n = extra.length;
            int n2 = 0;
            while (n2 < n) {
                String ex = stringArray[n2];
                sql.append(",").append(ex);
                ++n2;
            }
            sql.append(" FROM ").append(abfr[3]).append(" WHERE ").append(abfr[2]).append("=").append(this.getWrappedId());
            JdbcLink.Stm stm = this.getDBConnection().getStatement();
            LinkedList<String[]> list = new LinkedList<String[]>();
            try {
                LinkedList<String[]> linkedList;
                block20: {
                    Throwable throwable = null;
                    stringArray = null;
                    ResultSet rs = this.executeSqlQuery(sql.toString(), stm);
                    try {
                        while (rs != null && rs.next()) {
                            String[] line = new String[extra.length + 1];
                            line[0] = rs.getString(abfr[1]);
                            int i = 1;
                            while (i < extra.length + 1) {
                                line[i] = rs.getString(extra[i - 1]);
                                ++i;
                            }
                            list.add(line);
                        }
                        linkedList = list;
                        if (rs == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler beim Lesen der Liste ", ex, 2);
                            return null;
                        }
                    }
                    rs.close();
                }
                return linkedList;
            }
            finally {
                this.getDBConnection().releaseStatement(stm);
            }
        }
        log.error("Fehlerhaftes Mapping " + mapped);
        return null;
    }

    @Override
    public boolean set(String field, String value) {
        String mapped = this.map(field);
        String table = this.getTableName();
        String key = this.getKey(field);
        StringBuilder sql = new StringBuilder();
        long ts = System.currentTimeMillis();
        if (value == null) {
            this.getDBConnection().getCache().remove(key);
            sql.append("UPDATE ").append(table).append(" SET ");
            int i = -1;
            while ((i = mapped.indexOf(":")) > 0) {
                mapped = mapped.substring(i + 1);
            }
            sql.append(mapped);
            sql.append("=NULL, lastupdate=" + Long.toString(ts) + " WHERE ID=").append(this.getWrappedId());
            this.getDBConnection().exec(sql.toString());
            return true;
        }
        Object oldval = this.getDBConnection().getCache().get(key, this.getCacheTime());
        if (mapped.startsWith("S:")) {
            this.getDBConnection().getCache().remove(key);
        } else {
            this.getDBConnection().getCache().put(key, value, this.getCacheTime());
        }
        if (value.equals(oldval)) {
            return true;
        }
        if (mapped.startsWith("EXT:")) {
            int ix = mapped.indexOf(58, 5);
            if (ix == -1) {
                log.error("Fehlerhaftes Mapping bei " + field);
                return false;
            }
            table = mapped.substring(4, ix);
            mapped = mapped.substring(ix + 1);
            sql.append("UPDATE ").append(table).append(" SET ").append(mapped);
        } else {
            sql.append("UPDATE ").append(table).append(" SET ");
            if (mapped.startsWith("S:")) {
                sql.append(mapped.substring(4));
            } else {
                sql.append(mapped);
            }
        }
        sql.append("=?, lastupdate=? WHERE ID=").append(this.getWrappedId());
        String cmd = sql.toString();
        DBConnection dbConnection = this.getDBConnection();
        PreparedStatement pst = null;
        try {
            pst = dbConnection.getPreparedStatement(cmd);
            this.encode(1, pst, field, value);
            if (dbConnection.isTrace()) {
                StringBuffer params = new StringBuffer();
                params.append("[");
                params.append(value);
                params.append("]");
                dbConnection.doTrace(String.valueOf(cmd) + " " + params);
            }
            pst.setLong(2, ts);
            pst.executeUpdate();
            return true;
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler bei: " + cmd + "(" + field + "=" + value + ")", ex, 2);
            throw new PersistenceException((IStatus)status);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException sQLException) {}
                dbConnection.releasePreparedStatement(pst);
            }
        }
    }

    public void setMap(String field, Map<Object, Object> map) {
        if (map == null) {
            throw new PersistenceException((IStatus)new ElexisStatus(4, "ch.elexis.core.data", 0, "Attempt to store Null map", null));
        }
        byte[] bin = PersistentObject.flatten((Hashtable)map);
        this.getDBConnection().getCache().put(this.getKey(field), map, this.getCacheTime());
        this.setBinaryRaw(field, bin);
    }

    protected void setVersionedResource(String field, String entry) {
        String lockid = PersistentObject.lock("VersionedResource", true);
        VersionedResource old = this.getVersionedResource(field, true);
        if (old.update(entry, CoreHub.getLoggedInContact().getLabel())) {
            this.getDBConnection().getCache().put(this.getKey(field), old, this.getCacheTime());
            this.setBinary(field, old.serialize());
        }
        PersistentObject.unlock("VersionedResource", lockid);
    }

    public void setBinary(String field, byte[] value) {
        String key = this.getKey(field);
        this.getDBConnection().getCache().put(key, value, this.getCacheTime());
        this.setBinaryRaw(field, value);
    }

    private void setBinaryRaw(String field, byte[] value) {
        StringBuilder sql = new StringBuilder(1000);
        sql.append("UPDATE ").append(this.getTableName()).append(" SET ").append(field).append("=?, lastupdate=?").append(" WHERE ID=").append(this.getWrappedId());
        String cmd = sql.toString();
        DBConnection dbConnection = this.getDBConnection();
        if (dbConnection.isTrace()) {
            dbConnection.doTrace(cmd);
        }
        PreparedStatement stm = dbConnection.getPreparedStatement(cmd);
        try {
            try {
                stm.setBytes(1, value);
                stm.setLong(2, System.currentTimeMillis());
                stm.executeUpdate();
            }
            catch (Exception ex) {
                log.error("Fehler beim Ausf\u00fchren der Abfrage " + cmd, (Throwable)ex);
                throw new PersistenceException((IStatus)new ElexisStatus(4, "ch.elexis.core.data", 0, "setBytes: Es trat ein Fehler beim Schreiben auf. " + ex.getMessage(), ex, 2));
            }
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {
                ExHandler.handle((Throwable)e);
                throw new PersistenceException("Could not close statement " + e.getMessage());
            }
            dbConnection.releasePreparedStatement(stm);
        }
    }

    public boolean setInt(String field, int value) {
        String stringValue = new Integer(value).toString();
        if (stringValue.length() <= MAX_INT_LENGTH) {
            return this.set(field, stringValue);
        }
        return false;
    }

    public int addToList(String field, String oID, String ... extra) {
        return this.addAllToList(field, Collections.singletonList(oID), extra);
    }

    public int addAllToList(String field, List<String> objectIds, String ... extra) {
        String mapped = this.map(field);
        DBConnection dbConnection = this.getDBConnection();
        int numberOfAffectedRows = 0;
        for (String objectId : objectIds) {
            String[] m;
            if (mapped.startsWith("JOINT:")) {
                m = mapped.split(":");
                if (m.length <= 3) continue;
                StringBuffer head = new StringBuffer(100);
                StringBuffer tail = new StringBuffer(100);
                head.append("INSERT INTO ").append(m[3]).append("(ID,").append(m[2]).append(",").append(m[1]);
                tail.append(") VALUES (").append(this.getDBConnection().getJdbcLink().wrapFlavored(StringTool.unique((String)"aij"))).append(",").append(this.getWrappedId()).append(",").append(this.getDBConnection().getJdbcLink().wrapFlavored(objectId));
                if (extra != null) {
                    String[] stringArray = extra;
                    int n = extra.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        String[] def = s.split("=");
                        if (def.length != 2) {
                            log.error("Fehlerhafter Aufruf addToList " + s);
                            return 0;
                        }
                        head.append(",").append(def[0]);
                        tail.append(",").append(this.getDBConnection().getJdbcLink().wrapFlavored(def[1]));
                        ++n2;
                    }
                }
                head.append(tail).append(")");
                if (dbConnection.isTrace()) {
                    String sql = head.toString();
                    dbConnection.doTrace(sql);
                    return dbConnection.exec(sql);
                }
                numberOfAffectedRows += dbConnection.exec(head.toString());
                continue;
            }
            if (mapped.startsWith("LIST:")) {
                m = mapped.split(":");
                if (m.length <= 2) continue;
                PreparedStatement ps = null;
                try {
                    try {
                        String psString = "INSERT INTO " + m[2] + " (ID, deleted, " + m[1] + ") VALUES (?, 0, ?);";
                        ps = dbConnection.getPreparedStatement(psString);
                        ps.setString(1, objectId);
                        ps.setString(2, this.getId());
                        numberOfAffectedRows += ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        log.error("Error executing prepared statement.", (Throwable)e);
                        dbConnection.releasePreparedStatement(ps);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    dbConnection.releasePreparedStatement(ps);
                    throw throwable;
                }
                dbConnection.releasePreparedStatement(ps);
                continue;
            }
            log.error("Fehlerhaftes Mapping: " + mapped);
            return 0;
        }
        if (numberOfAffectedRows > 0) {
            this.refreshLastUpdateAndSendUpdateEvent(field);
        }
        return numberOfAffectedRows;
    }

    public void removeFromList(String field) {
        String[] m;
        String mapped = this.map(field);
        DBConnection dbConnection = this.getDBConnection();
        if (mapped.startsWith("JOINT:") && (m = mapped.split(":")).length > 3) {
            int numberOfAffectedRows;
            StringBuilder sql = new StringBuilder(200);
            sql.append("DELETE FROM ").append(m[3]).append(" WHERE ").append(m[2]).append("=").append(this.getWrappedId());
            if (dbConnection.isTrace()) {
                String sq = sql.toString();
                dbConnection.doTrace(sq);
            }
            if ((numberOfAffectedRows = dbConnection.exec(sql.toString())) > 0) {
                this.refreshLastUpdateAndSendUpdateEvent(field);
            }
            return;
        }
        log.error("Fehlerhaftes Mapping: " + mapped);
    }

    public void removeFromList(String field, String oID) {
        int numberOfAffectedRows;
        block13: {
            String mapped = this.map(field);
            String[] m = mapped.split(":");
            numberOfAffectedRows = 0;
            DBConnection dbConnection = this.getDBConnection();
            if (mapped.startsWith("JOINT:")) {
                if (m.length > 3) {
                    StringBuilder sql = new StringBuilder(200);
                    sql.append("DELETE FROM ").append(m[3]).append(" WHERE ").append(m[2]).append("=").append(this.getWrappedId()).append(" AND ").append(m[1]).append("=").append(this.getDBConnection().getJdbcLink().wrapFlavored(oID));
                    if (dbConnection.isTrace()) {
                        String sq = sql.toString();
                        dbConnection.doTrace(sq);
                    }
                    numberOfAffectedRows = dbConnection.exec(sql.toString());
                }
            } else if (mapped.startsWith("LIST:")) {
                if (m.length > 2) {
                    PreparedStatement ps = null;
                    try {
                        try {
                            String psString = "DELETE FROM " + m[2] + " WHERE " + m[1] + "= ? AND ID = ?;";
                            ps = dbConnection.getPreparedStatement(psString);
                            ps.setString(1, this.getId());
                            ps.setString(2, oID);
                            numberOfAffectedRows = ps.executeUpdate();
                        }
                        catch (SQLException e) {
                            log.error("Error executing prepared statement.", (Throwable)e);
                            dbConnection.releasePreparedStatement(ps);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        dbConnection.releasePreparedStatement(ps);
                        throw throwable;
                    }
                    dbConnection.releasePreparedStatement(ps);
                }
            } else {
                log.error("Fehlerhaftes Mapping: " + mapped);
            }
        }
        if (numberOfAffectedRows > 0) {
            this.refreshLastUpdateAndSendUpdateEvent(field);
        }
    }

    protected boolean create(String customID) {
        return this.create(customID, null, null, true);
    }

    protected boolean create(String customID, String[] fields, String[] values) {
        return this.create(customID, fields, values, true);
    }

    protected boolean create(String customID, String[] fields, String[] values, boolean sendEvent) {
        if (customID != null) {
            this.id = customID;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + this.getTableName() + " (");
        ArrayList<String> fieldS = new ArrayList<String>();
        fieldS.add(FLD_ID);
        fieldS.add(FLD_LASTUPDATE);
        ArrayList<String> valuesS = new ArrayList<String>();
        valuesS.add(this.id);
        valuesS.add(Long.toString(System.currentTimeMillis()));
        if (fields != null && values != null && fields.length == values.length && fields.length > 0) {
            fieldS.addAll(Arrays.asList(fields));
            valuesS.addAll(Arrays.asList(values));
        }
        Function<String, String> fixDate = s -> {
            if (s.startsWith("S:D:")) {
                return s.substring(4);
            }
            return s;
        };
        sql.append(fieldS.stream().map((? super T s) -> this.map((String)s)).map(fixDate).reduce((u, t) -> String.valueOf(u) + "," + t).get());
        sql.append(") VALUES (");
        sql.append(valuesS.stream().map((? super T s) -> this.getDBConnection().getJdbcLink().wrapFlavored(PersistentObject.ts(s))).reduce((u, t) -> String.valueOf(u) + "," + t).get());
        sql.append(")");
        if (this.getDBConnection().exec(sql.toString()) != 0) {
            this.setConstraint();
            if (sendEvent) {
                this.sendElexisEvent(1);
            }
            return true;
        }
        return false;
    }

    protected void sendElexisEvent(int eventType) {
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(this, this.getClass(), eventType));
    }

    public boolean delete() {
        if (this.set(FLD_DELETED, "1")) {
            List xids = new Query(Xid.class, "object", this.getId()).execute();
            for (Xid xid : xids) {
                xid.delete();
            }
            new DBLog(this, DBLog.TYP.DELETE);
            IPersistentObject sel = ElexisEventDispatcher.getSelected(this.getClass());
            if (sel != null && sel.equals(this)) {
                ElexisEventDispatcher.clearSelection(this.getClass());
            }
            this.sendElexisEvent(2);
            this.getDBConnection().getCache().remove(this.getKey(FLD_DELETED));
            return true;
        }
        return false;
    }

    public boolean removeFromDatabase() {
        log.debug("removeFromDatabase() [" + this.getClass().getName() + "@" + this.getId() + "]");
        int result = this.getDBConnection().exec("DELETE FROM " + this.getTableName() + " WHERE ID=" + this.getWrappedId());
        return result == 1;
    }

    public boolean deleteList(String field) {
        String mapped = this.map(field);
        if (!mapped.startsWith("JOINT:")) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Feld " + field + " ist keine n:m Verkn\u00fcpfung", null, 2);
            ElexisEventDispatcher.fireElexisStatusEvent(status);
            return false;
        }
        String[] m = mapped.split(":");
        this.getDBConnection().exec("DELETE FROM " + m[3] + " WHERE " + m[2] + "=" + this.getWrappedId());
        return true;
    }

    public boolean undelete() {
        if (this.set(FLD_DELETED, "0")) {
            Query qbe = new Query(Xid.class);
            qbe.clear(true);
            qbe.add("object", "=", this.getId());
            List xids = qbe.execute();
            for (Xid xid : xids) {
                xid.undelete();
            }
            new DBLog(this, DBLog.TYP.UNDELETE);
            this.sendElexisEvent(1);
            return true;
        }
        return false;
    }

    public boolean set(String[] fields, String ... values) {
        if (fields == null || values == null || fields.length != values.length) {
            log.error("Falsche Felddefinition f\u00fcr set");
            return false;
        }
        DBConnection dbConnection = this.getDBConnection();
        StringBuffer sql = new StringBuffer(200);
        sql.append("UPDATE ").append(this.getTableName()).append(" SET ");
        int i = 0;
        while (i < fields.length) {
            String mapped = this.map(fields[i]);
            if (mapped.startsWith("S:")) {
                sql.append(mapped.substring(4));
                dbConnection.getCache().remove(this.getKey(fields[i]));
            } else {
                sql.append(mapped);
                dbConnection.getCache().put(this.getKey(fields[i]), values[i], this.getCacheTime());
            }
            sql.append("=?,");
            ++i;
        }
        sql.append("lastupdate=?");
        sql.append(" WHERE ID=").append(this.getWrappedId());
        String cmd = sql.toString();
        PreparedStatement pst = dbConnection.getPreparedStatement(cmd);
        int i2 = 0;
        while (i2 < fields.length) {
            this.encode(i2 + 1, pst, fields[i2], values[i2]);
            ++i2;
        }
        if (dbConnection.isTrace()) {
            StringBuffer params = new StringBuffer();
            params.append("[");
            params.append(StringTool.join((String[])values, (String)", "));
            params.append("]");
            dbConnection.doTrace(String.valueOf(cmd) + " " + params);
        }
        try {
            pst.setLong(fields.length + 1, System.currentTimeMillis());
            pst.executeUpdate();
            this.sendElexisEvent(4);
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            StringBuilder sb = new StringBuilder();
            sb.append("Fehler bei ").append(cmd).append("\nFelder:\n");
            int i3 = 0;
            while (i3 < fields.length) {
                sb.append(fields[i3]).append("=").append(values[i3]).append("\n");
                ++i3;
            }
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, sb.toString(), ex, 2);
        }
        return false;
        finally {
            try {
                pst.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(pst);
        }
    }

    public String[] get(boolean checkNulls, String ... fields) {
        String[] ret = new String[fields.length];
        this.get(fields, ret);
        if (checkNulls) {
            int i = 0;
            while (i < ret.length) {
                ret[i] = PersistentObject.checkNull(ret[i]);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public boolean get(String[] fields, String[] values) {
        Object key22;
        if (this.getId() == null || this.getId().isEmpty()) {
            log.error("Get with no ID on object of type [" + this.getClass().getName() + "]");
        }
        if (fields == null || values == null || fields.length != values.length) {
            log.error("Falscher Aufruf von get(String[],String[]");
            return false;
        }
        DBConnection dbConnection = this.getDBConnection();
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT ");
        boolean[] decode = new boolean[fields.length];
        int i = 0;
        while (i < fields.length) {
            key22 = this.getKey(fields[i]);
            Object ret = dbConnection.getCache().get((String)key22, this.getCacheTime());
            if (ret instanceof String) {
                values[i] = (String)ret;
            } else {
                String f1 = this.map(fields[i]);
                if (f1.startsWith("S:")) {
                    sql.append(f1.substring(4));
                    decode[i] = true;
                } else {
                    sql.append(f1);
                }
                sql.append(",");
            }
            ++i;
        }
        if (sql.length() < 8) {
            return true;
        }
        sql.delete(sql.length() - 1, 1000);
        sql.append(" FROM ").append(this.getTableName()).append(" WHERE ID=").append(this.getWrappedId());
        JdbcLink.Stm stm = dbConnection.getStatement();
        try {
            block28: {
                key22 = null;
                Object var8_11 = null;
                ResultSet rs = this.executeSqlQuery(sql.toString(), stm);
                try {
                    if (rs != null && rs.next()) {
                        int i2 = 0;
                        while (i2 < values.length) {
                            if (values[i2] == null) {
                                if (decode[i2]) {
                                    values[i2] = this.decode(fields[i2], rs);
                                } else {
                                    String dbValue = rs.getString(this.map(fields[i2]));
                                    values[i2] = PersistentObject.checkNull(dbValue);
                                    dbConnection.getCache().put(this.getKey(fields[i2]), dbValue, this.getCacheTime());
                                }
                            }
                            ++i2;
                        }
                    }
                    if (rs == null) break block28;
                }
                catch (Throwable key22) {
                    try {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            throw key22;
                        }
                        catch (Throwable throwable) {
                            if (key22 == null) {
                                key22 = throwable;
                            } else if (key22 != throwable) {
                                ((Throwable)key22).addSuppressed(throwable);
                            }
                            throw key22;
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        return false;
                    }
                }
                rs.close();
            }
            return true;
        }
        finally {
            dbConnection.releaseStatement(stm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String decode(String field, ResultSet rs) {
        try {
            String mapped = this.map(field);
            if (!mapped.startsWith("S:")) return null;
            char mode = mapped.charAt(2);
            switch (mode) {
                case 'D': {
                    String dat = rs.getString(mapped.substring(4));
                    if (dat == null) {
                        return "";
                    }
                    TimeTool t = new TimeTool();
                    if (!t.set(dat)) return "";
                    return t.toString(4);
                }
                case 'N': {
                    int val = rs.getInt(mapped.substring(4));
                    return Integer.toString(val);
                }
                case 'C': {
                    InputStream is = rs.getBinaryStream(mapped.substring(4));
                    if (is == null) {
                        return "";
                    }
                    byte[] exp = CompEx.expand((InputStream)is);
                    if (exp == null) return null;
                    String string = StringTool.createString((byte[])exp);
                    return string;
                }
                case 'V': {
                    byte[] in = rs.getBytes(mapped.substring(4));
                    VersionedResource vr = VersionedResource.load((byte[])in);
                    return vr.getHead();
                }
            }
            return null;
        }
        catch (Exception ex) {
            log.error("Fehler bei decode in field [{}]", (Object)field, (Object)ex);
        }
        return null;
    }

    private String encode(int num, PreparedStatement pst, String field, String value) {
        String mapped = this.map(field);
        String ret = value;
        try {
            if (mapped.startsWith("S:")) {
                String typ = mapped.substring(2, 3);
                mapped = mapped.substring(4);
                if (typ.startsWith("D")) {
                    TimeTool t = new TimeTool();
                    if (!StringTool.isNothing((Object)value) && t.set(value)) {
                        ret = t.toString(9);
                        pst.setString(num, ret);
                    } else {
                        ret = "";
                        pst.setString(num, "");
                    }
                } else if (typ.startsWith("C")) {
                    byte[] enc = CompEx.Compress((String)value, (int)-1610612736);
                    pst.setBytes(num, enc);
                } else if (typ.startsWith("N")) {
                    pst.setInt(num, Integer.parseInt(value));
                } else {
                    log.error("Unbekannter encode code " + typ);
                }
            } else {
                pst.setString(num, value);
            }
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler beim String encoder", ex, 2);
            log.error("Fehler beim String encoder: " + ex.getMessage());
        }
        return ret;
    }

    public boolean isMatching(IPersistentObject other, int mode, String ... fields) {
        if (this.getClass().equals(other.getClass())) {
            String[] others = new String[fields.length];
            other.get(fields, others);
            return this.isMatching(fields, mode, others);
        }
        return false;
    }

    public boolean isMatching(String[] fields, int mode, String ... others) {
        String[] mine = new String[fields.length];
        this.get(fields, mine);
        int i = 0;
        while (i < fields.length) {
            if (mine[i] == null) {
                return others[i] == null;
            }
            if (others[i] == null) {
                return false;
            }
            switch (mode) {
                case 0: {
                    if (mine[i].toLowerCase().equals(others[i].toLowerCase())) break;
                    return false;
                }
                case 1: {
                    if (mine[i].toLowerCase().startsWith(others[i].toLowerCase())) break;
                    return false;
                }
                case 2: {
                    if (!mine[i].matches(others[i])) {
                        return false;
                    }
                }
                case 3: {
                    if (mine[i].toLowerCase().contains(others[i].toLowerCase())) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isMatching(Map<String, String> fields, int mode, boolean bSkipInexisting) {
        block7: for (Map.Entry<String, String> entry : fields.entrySet()) {
            String mine = this.get(entry.getKey());
            String others = entry.getValue();
            if (bSkipInexisting && (mine.startsWith(MAPPING_ERROR_MARKER) || others.startsWith(MAPPING_ERROR_MARKER))) continue;
            switch (mode) {
                case 0: {
                    if (mine.toLowerCase().equals(others.toLowerCase())) break;
                    return false;
                }
                case 1: {
                    if (mine.toLowerCase().startsWith(others.toLowerCase())) break;
                    return false;
                }
                case 2: {
                    if (!mine.matches(others)) {
                        return false;
                    }
                }
                case 3: {
                    if (!mine.toLowerCase().contains(others.toLowerCase())) {
                        return false;
                    }
                }
                case 4: {
                    String my = mine.toLowerCase();
                    if (!(others.startsWith("%") || others.startsWith("*") ? !my.contains(others.substring(1).toLowerCase()) : !my.startsWith(others.toLowerCase()))) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    public String getKey(String field) {
        return String.valueOf(this.getTableName()) + "." + this.getId() + "#" + field;
    }

    public static void disconnect() {
        if (defaultConnection != null) {
            defaultConnection.disconnect();
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof PersistentObject) {
            return this.getId().equals(((PersistentObject)arg0).getId());
        }
        return false;
    }

    public static String checkNull(Object in) {
        if (in == null) {
            return "";
        }
        if (!(in instanceof String)) {
            return "";
        }
        return (String)in;
    }

    public static int checkZero(Object in) {
        if (StringTool.isNothing((Object)in)) {
            return 0;
        }
        try {
            return Integer.parseInt(((String)in).trim());
        }
        catch (NumberFormatException ex) {
            ExHandler.handle((Throwable)ex);
            return 0;
        }
    }

    public static double checkZeroDouble(String in) {
        if (StringTool.isNothing((Object)in)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(in.trim());
        }
        catch (NumberFormatException ex) {
            ExHandler.handle((Throwable)ex);
            return 0.0;
        }
    }

    @Override
    public long getLastUpdate() {
        String result = this.getDBConnection().queryString("SELECT LASTUPDATE FROM " + this.getTableName() + " WHERE ID=" + this.getWrappedId());
        if (result != null) {
            try {
                return Long.parseLong(result);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void refreshLastUpdateAndSendUpdateEvent(@Nullable String updatedAttribute) {
        this.getDBConnection().exec("UPDATE " + this.getTableName() + " SET " + FLD_LASTUPDATE + "=" + Long.toString(System.currentTimeMillis()) + " WHERE ID=" + this.getWrappedId());
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(this, this.getClass(), 4, updatedAttribute));
    }

    public static long getHighestLastUpdate(String tableName) {
        DBConnection dbConnection = PersistentObject.getDefaultConnection();
        PreparedStatement ps = dbConnection.getPreparedStatement("SELECT MAX(LASTUPDATE) FROM " + tableName);
        try {
            ResultSet res = ps.executeQuery();
            if (res.next()) {
                long l = res.getLong(1);
                return l;
            }
            return 0L;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return 0L;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(ps);
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        IPersistentObjectCache<String> iPersistentObjectCache = defaultConnection.getCache();
        synchronized (iPersistentObjectCache) {
            defaultConnection.getCache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        IPersistentObjectCache<String> iPersistentObjectCache = defaultConnection.getCache();
        synchronized (iPersistentObjectCache) {
            defaultConnection.getCache().reset();
        }
    }

    public int getCacheTime() {
        return this.getDBConnection().getDefaultLifeTime();
    }

    protected static void createOrModifyTable(String sqlScript) {
        String[] sql = new String[]{sqlScript};
        SqlRunner runner = new SqlRunner(sql, "ch.elexis.core.data");
        runner.runSql();
    }

    public static void executeSQLScript(String filepath, String plugin) throws IOException {
        FileInputStream is = new FileInputStream(filepath);
        InputStreamReader isr = new InputStreamReader(is);
        char[] buf = new char[4096];
        int l = 0;
        StringBuilder sb = new StringBuilder();
        while ((l = isr.read(buf)) > 0) {
            sb.append(buf, 0, l);
        }
        new SqlRunner(new String[]{sb.toString()}, plugin).runSql();
    }

    protected static boolean executeScript(String pathname) {
        JdbcLink.Stm stm = defaultConnection.getStatement();
        try {
            FileInputStream is = new FileInputStream(pathname);
            boolean bl = stm.execScript((InputStream)is, true, true);
            return bl;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
        finally {
            defaultConnection.releaseStatement(stm);
        }
    }

    protected static void removeTable(String name, Class oclas) {
        Query qbe = new Query(oclas);
        for (Object o : qbe.execute()) {
            ((PersistentObject)o).delete();
        }
        defaultConnection.exec("DROP TABLE " + name);
    }

    public static byte[] flatten(Hashtable hash) {
        return PersistentObject.flattenObject(hash);
    }

    public static byte[] flattenObject(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            zos.putNextEntry(new ZipEntry("hash"));
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(object);
            zos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }

    public static Hashtable<Object, Object> fold(byte[] flat) {
        return (Hashtable)PersistentObject.foldObject(flat);
    }

    public static Hashtable<Object, Object> fold(byte[] flat, IClassResolver resolver) {
        return (Hashtable)PersistentObject.foldObject(flat, resolver);
    }

    public static Object foldObject(byte[] flat) {
        return PersistentObject.foldObject(flat, null);
    }

    /*
     * Exception decompiling
     */
    public static Object foldObject(byte[] flat, IClassResolver resolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getExportFields() {
        DBConnection dbConnection = this.getDBConnection();
        JdbcLink.Stm stm = null;
        try {
            stm = dbConnection.getStatement();
            ResultSet res = stm.query("Select count(id) from " + this.getTableName());
            ResultSetMetaData rmd = res.getMetaData();
            String[] ret = new String[rmd.getColumnCount()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = rmd.getColumnName(i + 1);
                ++i;
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
        finally {
            dbConnection.releaseStatement(stm);
        }
    }

    protected String getExportUIDValue() {
        throw new IllegalArgumentException("No export uid value for " + this.getClass().getSimpleName() + " available");
    }

    protected String getExportUIDVersion() {
        return "1";
    }

    public String exportData() {
        return XML2Database.exportData(this);
    }

    private ResultSet executeSqlQuery(String sql, JdbcLink.Stm stm) {
        ResultSet res = null;
        try {
            res = stm.query(sql);
        }
        catch (JdbcLinkException je) {
            ElexisStatus status = PersistentObject.translateJdbcException(je);
            if (je instanceof JdbcLinkResourceException) {
                status.setCode(3);
                status.setMessage(String.valueOf(status.getMessage()) + "\nACHTUNG: Elexis wird neu gestarted!\n");
                status.setLogLevel(1);
                ElexisEventDispatcher.fireElexisStatusEvent(status);
            }
            status.setLogLevel(1);
            throw new PersistenceException((IStatus)status);
        }
        return res;
    }

    private static ElexisStatus translateJdbcException(JdbcLinkException jdbc) {
        if (jdbc instanceof JdbcLinkSyntaxException) {
            return new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler in der Datenbanksyntax.", (Exception)((Object)jdbc), 2);
        }
        if (jdbc instanceof JdbcLinkConcurrencyException) {
            return new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler bei einer Datenbanktransaktion.", (Exception)((Object)jdbc), 2);
        }
        if (jdbc instanceof JdbcLinkResourceException) {
            return new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler bei der Datenbankkommunikation.", (Exception)((Object)jdbc), 2);
        }
        return new ElexisStatus(4, "ch.elexis.core.data", 0, "Fehler in der Datenbankschnittstelle.", (Exception)((Object)jdbc), 2);
    }

    public static boolean deleteAllTables() {
        int nrTables = 0;
        String tableName = "none";
        Connection conn = null;
        try {
            try {
                ResultSet rsTables;
                conn = defaultConnection.getConnection();
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rsViews = dmd.getTables(null, null, "%", new String[]{"VIEW"});
                if (rsViews != null) {
                    while (rsViews.next()) {
                        tableName = rsViews.getString(3);
                        defaultConnection.exec("DROP VIEW " + tableName);
                        ++nrTables;
                    }
                }
                if ((rsTables = dmd.getTables(null, null, "%", new String[]{"TABLE"})) != null) {
                    ArrayList<String> failedFirstRunTables = new ArrayList<String>();
                    while (rsTables.next()) {
                        try {
                            tableName = rsTables.getString(3);
                            defaultConnection.exec("DROP TABLE " + tableName + " CASCADE");
                            ++nrTables;
                        }
                        catch (JdbcLinkException e) {
                            log.warn("Failed table [{}] in first run with " + e.getMessage());
                            failedFirstRunTables.add(tableName);
                        }
                    }
                    for (String table : failedFirstRunTables) {
                        defaultConnection.exec("DROP TABLE " + table + " CASCADE");
                    }
                }
            }
            catch (JdbcLinkException | SQLException e1) {
                log.error("Error deleting table " + tableName);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    log.error("Error closing connection" + e);
                }
                return false;
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error("Error closing connection" + e);
            }
        }
        log.info("Deleted " + nrTables + " tables");
        return true;
    }

    public static boolean tableExistsSelect(String tableName) {
        try {
            defaultConnection.exec("SELECT 1 FROM " + tableName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean tableExists(String tableName) {
        return PersistentObject.tableExists(tableName, false);
    }

    public static boolean tableExists(String tableName, boolean considerViews) {
        int nrFounds = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = defaultConnection.getConnection();){
                String myCatalog = conn.getCatalog();
                if (myCatalog == null) {
                    log.error("No catalog information available");
                }
                DatabaseMetaData dmd = conn.getMetaData();
                String[] searchBase = considerViews ? new String[]{"TABLE", "VIEW"} : new String[]{"TABLE"};
                ResultSet rs = dmd.getTables(myCatalog, null, "%", searchBase);
                while (rs.next()) {
                    String foundTableName = rs.getString(3);
                    if (!tableName.equalsIgnoreCase(foundTableName)) continue;
                    ++nrFounds;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException je) {
            log.error("Fehler beim abrufen der Datenbank Tabellen Information.", (Throwable)je);
        }
        if (nrFounds > 1) {
            log.error("Tabelle " + tableName + " " + nrFounds + "-mal gefunden!!");
        }
        return nrFounds == 1;
    }

    public static String ts(Object in) {
        if (in == null) {
            return "";
        }
        if (in instanceof String) {
            return (String)in;
        }
        if (in instanceof Boolean) {
            return (Boolean)in != false ? "1" : "0";
        }
        if (in instanceof Long) {
            return Long.toString((Long)in);
        }
        if (in instanceof Integer) {
            return Integer.toString((Integer)in);
        }
        if (in instanceof Double) {
            return Double.toString((Double)in);
        }
        if (in instanceof Date) {
            return new SimpleDateFormat("dd.MM.yyyy").format((Date)in);
        }
        if (in instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar dt = (XMLGregorianCalendar)in;
            return new SimpleDateFormat("dd.MM.yyyy").format(dt.toGregorianCalendar().getTime());
        }
        if (in instanceof List) {
            List inList = (List)in;
            return inList.stream().map((? super T o) -> o.toString()).reduce((u, t) -> String.valueOf(u) + "," + t).get();
        }
        return "";
    }

    public void putInCache(String field, Object value) {
        String key = this.getKey(field);
        if (value == null) {
            value = "";
        }
        this.getDBConnection().getCache().put(key, value, this.getCacheTime());
    }

    public static void executeDBInitScriptForClass(Class<?> clazz, @Nullable VersionInfo vi) {
        String resourceName = "/rsc/dbScripts/" + clazz.getName();
        if (vi != null) {
            resourceName = String.valueOf(resourceName) + "_" + vi.version();
        }
        String dbFlavor = PersistentObject.getConnection().DBFlavor;
        URL resource = PersistentObject.class.getResource(String.valueOf(resourceName) + "_" + dbFlavor + ".sql");
        resourceName = resource != null ? String.valueOf(resourceName) + "_" + dbFlavor + ".sql" : String.valueOf(resourceName) + ".sql";
        JdbcLink.Stm stm = defaultConnection.getStatement();
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream is = PersistentObject.class.getResourceAsStream(resourceName);){
                    boolean result = stm.execScript(is, true, true);
                    if (!result) {
                        log.warn("Error in executing script from " + resourceName);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Error executing script from " + resourceName, (Throwable)e);
                defaultConnection.releaseStatement(stm);
            }
        }
        finally {
            defaultConnection.releaseStatement(stm);
        }
    }

    public void clearCachedAttributes() {
        throw new UnsupportedOperationException("Not implemented for class " + this.getClass().getName());
    }

    public static enum FieldType {
        TEXT,
        LIST,
        JOINT;

    }

    public static interface IClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }

    public static enum TristateBoolean {
        TRUE,
        FALSE,
        UNDEF;

    }
}

