/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.lab;

import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.data.lab.LabResultEvaluationResult;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.data.LabResult;
import org.apache.commons.lang.StringUtils;

public class LabResultEvaluator {
    private LabResultEvaluationResult evaluateTextualResult(LabResult labResult, boolean isAbsoluteItem) {
        String SELECTED_BASE;
        PathologicDescription.Description description;
        String lcResult = labResult.getResult().trim();
        Object[] ref = this.getReferenceValueForLabResult(labResult);
        String refValue = (String)ref[0];
        PathologicDescription.Description description2 = description = isAbsoluteItem ? PathologicDescription.Description.PATHO_ABSOLUT : (PathologicDescription.Description)ref[1];
        if (lcResult.equals(refValue)) {
            return new LabResultEvaluationResult(true, false, new PathologicDescription(description, lcResult));
        }
        if (isAbsoluteItem && (lcResult.toLowerCase().startsWith("pos") || lcResult.toLowerCase().startsWith("+"))) {
            return new LabResultEvaluationResult(true, true, new PathologicDescription(description, lcResult));
        }
        String string = SELECTED_BASE = isAbsoluteItem ? "lab/eval/tAbsolut/" : "lab/eval/tText/";
        if (ConfigServiceHolder.getGlobal((String)(String.valueOf(SELECTED_BASE) + "refValNonEqualResValMeansPath"), (boolean)false) && !lcResult.equalsIgnoreCase(refValue)) {
            return new LabResultEvaluationResult(true, true, new PathologicDescription(description, lcResult));
        }
        return new LabResultEvaluationResult(true, false, new PathologicDescription(PathologicDescription.Description.UNKNOWN, lcResult));
    }

    private Object[] getReferenceValueForLabResult(LabResult labResult) {
        Gender gender = labResult.getPatient().getGender();
        PathologicDescription.Description description = PathologicDescription.Description.PATHO_REF;
        String refValue = "";
        if (Gender.MALE == gender) {
            refValue = labResult.getRefMale();
            if (StringUtils.isEmpty((String)refValue)) {
                description = PathologicDescription.Description.PATHO_REF_ITEM;
                refValue = labResult.getItem().getReferenceMale();
            }
        } else {
            refValue = labResult.getRefFemale();
            if (StringUtils.isEmpty((String)refValue)) {
                description = PathologicDescription.Description.PATHO_REF_ITEM;
                refValue = labResult.getItem().getReferenceFemale();
            }
        }
        return new Object[]{refValue, description};
    }

    public LabResultEvaluationResult evaluate(LabResult labResult) {
        ILabItem item = labResult.getItem();
        if (item.isNoReferenceValueItem()) {
            return new LabResultEvaluationResult(true, false, new PathologicDescription(PathologicDescription.Description.PATHO_REF_ITEM, Messages.LabResultEvaluator_LabItemNoRefValue));
        }
        if (LabItemTyp.ABSOLUTE == item.getTyp()) {
            return this.evaluateTextualResult(labResult, true);
        }
        if (LabItemTyp.TEXT == item.getTyp()) {
            return this.evaluateTextualResult(labResult, false);
        }
        if (LabItemTyp.DOCUMENT == item.getTyp()) {
            return new LabResultEvaluationResult(true, false, null);
        }
        return new LabResultEvaluationResult(false);
    }
}

