/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.tasks.internal.service.Task;
import ch.elexis.core.tasks.internal.service.TaskServiceUtil;
import ch.elexis.core.tasks.internal.service.fs.WatchServiceHolder;
import ch.elexis.core.tasks.internal.service.quartz.QuartzExecutor;
import ch.elexis.core.tasks.internal.service.sysevents.SysEventWatcher;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.tasks.model.OwnerTaskNotification;
import ch.elexis.core.tasks.model.TaskState;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class TaskServiceImpl
implements ITaskService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IModelService taskModelService;
    private TaskServiceUtil util;
    private ExecutorService parallelExecutorService;
    private Map<String, ExecutorService> perRunnableSingletonExecutorService;
    private QuartzExecutor quartzExecutor;
    private WatchServiceHolder watchServiceHolder;
    private SysEventWatcher sysEventWatcher;
    private List<ITask> triggeredTasks;
    @Reference
    private IContextService contextService;
    @Reference
    private IMessageService messageService;
    private List<IIdentifiedRunnable> identifiedRunnables = Collections.synchronizedList(new ArrayList());
    private Map<String, IIdentifiedRunnableFactory> runnableIdToFactoryMap = Collections.synchronizedMap(new HashMap());
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="bindRunnableWithContextFactory", unbind="unbindRunnableWithContextFactory")
    private volatile List<IIdentifiedRunnableFactory> runnableWithContextFactories;

    @Reference(target="(service.model.name=ch.elexis.core.tasks.model)")
    private void setModelService(IModelService modelService) {
        this.taskModelService = modelService;
    }

    protected void bindRunnableWithContextFactory(IIdentifiedRunnableFactory runnableWithContextFactory) {
        if (this.runnableWithContextFactories == null) {
            this.runnableWithContextFactories = new ArrayList<IIdentifiedRunnableFactory>();
        }
        this.logger.info("Binding " + runnableWithContextFactory.getClass().getName());
        this.runnableWithContextFactories.add(runnableWithContextFactory);
        try {
            runnableWithContextFactory.initialize((Object)this);
            List providedRunnables = runnableWithContextFactory.getProvidedRunnables();
            for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
                this.runnableIdToFactoryMap.put(iIdentifiedRunnable.getId(), runnableWithContextFactory);
                this.identifiedRunnables.add(iIdentifiedRunnable);
                this.loadIncurredForRunnable(iIdentifiedRunnable);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error binding [{}], skipping.", (Object)runnableWithContextFactory.getClass().getName(), (Object)e);
            return;
        }
    }

    protected void unbindRunnableWithContextFactory(IIdentifiedRunnableFactory runnableWithContextFactory) {
        this.runnableWithContextFactories.remove(runnableWithContextFactory);
        List providedRunnables = runnableWithContextFactory.getProvidedRunnables();
        for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
            this.runnableIdToFactoryMap.remove(iIdentifiedRunnable.getId());
            this.identifiedRunnables.remove(iIdentifiedRunnable);
            this.unloadIncurredForRunnable(iIdentifiedRunnable);
        }
    }

    public TaskServiceImpl() {
        this.triggeredTasks = Collections.synchronizedList(new ArrayList());
        this.parallelExecutorService = Executors.newCachedThreadPool();
        this.perRunnableSingletonExecutorService = new HashMap<String, ExecutorService>();
        this.quartzExecutor = new QuartzExecutor();
        this.sysEventWatcher = new SysEventWatcher();
        this.util = new TaskServiceUtil();
    }

    @Activate
    private void activateComponent() {
        try {
            this.quartzExecutor.start();
        }
        catch (SchedulerException e) {
            this.logger.warn("Error starting quartz scheduler", (Throwable)e);
        }
        this.watchServiceHolder = new WatchServiceHolder(this);
        if (this.watchServiceHolder.triggerIsAvailable()) {
            this.watchServiceHolder.startPolling();
        }
    }

    @Deactivate
    private void deactivateComponent() {
        List<ITask> runningTasks = this.getRunningTasks();
        long start = System.currentTimeMillis();
        while (!runningTasks.isEmpty() && System.currentTimeMillis() - start < 30000L) {
            for (ITask task2 : runningTasks) {
                IProgressMonitor progressMonitor = task2.getProgressMonitor();
                if (progressMonitor.isCanceled()) continue;
                this.logger.info("Canceling " + task2.getLabel());
                task2.getProgressMonitor().setCanceled(true);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException task2) {
                // empty catch block
            }
            runningTasks = this.getRunningTasks();
            this.logger.info("Waiting max 30 seconds for tasks to gracefully stop");
        }
        this.getRunningTasks().forEach(task -> this.logger.warn("Could not gracefully stop task " + task.getLabel()));
        try {
            this.quartzExecutor.shutdown();
            this.parallelExecutorService.shutdown();
            this.perRunnableSingletonExecutorService.forEach((c, e) -> e.shutdown());
        }
        catch (SchedulerException e2) {
            this.logger.warn("Error stopping scheduler", (Throwable)e2);
        }
        this.watchServiceHolder.stopPolling();
    }

    private void loadIncurredForRunnable(IIdentifiedRunnable identifiedRunnable) {
        List<ITaskDescriptor> taskDescriptors = this.util.loadForIdentifiedRunnable(identifiedRunnable, this.taskModelService, this.contextService);
        for (ITaskDescriptor iTaskDescriptor : taskDescriptors) {
            try {
                this.logger.info("incurring task descriptor [{}] reference id [{}]", (Object)iTaskDescriptor.getId(), (Object)iTaskDescriptor.getReferenceId());
                this.incur(iTaskDescriptor);
            }
            catch (TaskException e) {
                this.logger.warn("Can not incur taskdescriptor [{}]", (Object)iTaskDescriptor.getId(), (Object)e);
            }
        }
    }

    private void unloadIncurredForRunnable(IIdentifiedRunnable identifiedRunnable) {
        List<ITaskDescriptor> taskDescriptors = this.util.loadForIdentifiedRunnable(identifiedRunnable, this.taskModelService, this.contextService);
        for (ITaskDescriptor iTaskDescriptor : taskDescriptors) {
            try {
                this.logger.info("releasing task descriptor [{}] reference id [{}]", (Object)iTaskDescriptor.getId(), (Object)iTaskDescriptor.getReferenceId());
                this.release(iTaskDescriptor);
            }
            catch (TaskException e) {
                this.logger.warn("Can not release taskdescriptor [{}]", (Object)iTaskDescriptor.getId(), (Object)e);
            }
        }
    }

    private void incur(ITaskDescriptor taskDescriptor) throws TaskException {
        if (TaskTriggerType.FILESYSTEM_CHANGE == taskDescriptor.getTriggerType()) {
            this.watchServiceHolder.incur(taskDescriptor);
        } else if (TaskTriggerType.CRON == taskDescriptor.getTriggerType()) {
            this.quartzExecutor.incur(this, taskDescriptor);
        } else if (TaskTriggerType.MANUAL != taskDescriptor.getTriggerType() && TaskTriggerType.OTHER_TASK != taskDescriptor.getTriggerType()) {
            if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
                this.sysEventWatcher.incur(taskDescriptor);
            } else {
                throw new TaskException(8, "Trigger type not yet implemented [" + (Object)((Object)taskDescriptor.getTriggerType()) + "]");
            }
        }
    }

    private void release(ITaskDescriptor taskDescriptor) throws TaskException {
        if (TaskTriggerType.FILESYSTEM_CHANGE == taskDescriptor.getTriggerType()) {
            this.watchServiceHolder.release(taskDescriptor);
        } else if (TaskTriggerType.CRON == taskDescriptor.getTriggerType()) {
            this.quartzExecutor.release(taskDescriptor);
        } else if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
            this.sysEventWatcher.release(taskDescriptor);
        }
    }

    @Override
    public ITaskDescriptor createTaskDescriptor(IIdentifiedRunnable identifiedRunnable) throws TaskException {
        if (identifiedRunnable == null) {
            throw new TaskException(5);
        }
        ITaskDescriptor taskDescriptor = (ITaskDescriptor)this.taskModelService.create(ITaskDescriptor.class);
        taskDescriptor.setIdentifiedRunnableId(identifiedRunnable.getId());
        taskDescriptor.setRunContext(identifiedRunnable.getDefaultRunContext());
        String stationIdentifier = this.contextService.getRootContext().getStationIdentifier();
        taskDescriptor.setRunner(StringUtils.abbreviate((String)stationIdentifier, (int)64));
        taskDescriptor.setReferenceId(String.valueOf(System.currentTimeMillis()));
        this.contextService.getActiveUser().ifPresent(u -> taskDescriptor.setOwner((IUser)u));
        this.saveTaskDescriptor(taskDescriptor);
        return taskDescriptor;
    }

    @Override
    public boolean removeTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        if (taskDescriptor == null) {
            throw new TaskException(5);
        }
        this.setActive(taskDescriptor, false);
        IQuery taskQuery = this.taskModelService.getQuery(ITask.class, true);
        taskQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK__TASK_DESCRIPTOR, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptor);
        List execute = taskQuery.execute();
        execute.stream().forEach(task -> {
            boolean bl = this.taskModelService.remove((Identifiable)task);
        });
        return this.taskModelService.remove((Identifiable)taskDescriptor);
    }

    void notify(ITask task) {
        if (task.isFinished()) {
            this.triggeredTasks.remove(task);
            ITaskDescriptor taskDescriptor = task.getTaskDescriptor();
            OwnerTaskNotification ownerNotification = taskDescriptor.getOwnerNotification();
            IUser owner = taskDescriptor.getOwner();
            TaskState state = task.getState();
            if (OwnerTaskNotification.WHEN_FINISHED == ownerNotification || OwnerTaskNotification.WHEN_FINISHED_FAILED == ownerNotification && (TaskState.FAILED == state || TaskState.COMPLETED_WARN == state)) {
                if (owner != null) {
                    this.sendMessageToOwner(task, owner, state);
                } else {
                    this.logger.warn("[{}] requested owner notification, but owner is null", (Object)task.getTaskDescriptor().getId());
                }
            }
        }
    }

    private void sendMessageToOwner(ITask task, IUser owner, TaskState state) {
        String resultText;
        TransientMessage message = this.messageService.prepare("Task-Service@" + this.contextService.getRootContext().getStationIdentifier(), "internal:" + owner.getId());
        message.addMessageCode("senderSubId", "tasks.taskservice");
        message.setSenderAcceptsAnswer(false);
        if (TaskState.FAILED == state) {
            resultText = (String)task.getResult().get("exceptionMessage");
            message.addMessageCode("severity", "error");
        } else {
            String severity = TaskState.COMPLETED_WARN == state ? "warn" : "info";
            resultText = (String)task.getResult().get("resultData");
            message.addMessageCode("severity", severity);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(task.getLabel());
        if (StringUtils.isNotBlank((CharSequence)resultText)) {
            sb.append("\n" + resultText);
        }
        message.setMessageText(sb.toString());
        ObjectStatus status = this.messageService.send(message);
        if (!status.isOK()) {
            this.logger.warn("Could not send message to owner [{}]", (Object)status.getMessage());
        }
    }

    @Override
    public ITask triggerSync(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        return this.trigger(taskDescriptor, progressMonitor, triggerType, runContext, true);
    }

    @Override
    public ITask trigger(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        return this.trigger(taskDescriptor, progressMonitor, triggerType, runContext, false);
    }

    public ITask trigger(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext, boolean sync) throws TaskException {
        if (sync && triggerType != TaskTriggerType.MANUAL) {
            throw new IllegalArgumentException("OnlyTriggerType MANUAL can be executed sync");
        }
        if (triggerType == TaskTriggerType.OTHER_TASK && TaskTriggerType.OTHER_TASK != taskDescriptor.getTriggerType()) {
            throw new TaskException(1, "Task Descriptor [" + taskDescriptor.getId() + "] is not TriggerType OTHER_TASK");
        }
        if (!taskDescriptor.isActive() && TaskTriggerType.MANUAL != triggerType) {
            throw new TaskException(1, "Task Descriptor [" + taskDescriptor.getId() + "] is not active");
        }
        this.logger.info("[{}] trigger taskDesc [{}/{}] runContext [{}]", new Object[]{triggerType, taskDescriptor.getId(), taskDescriptor.getReferenceId(), runContext});
        Task task = new Task(taskDescriptor, triggerType, progressMonitor, runContext);
        task.setSystem(taskDescriptor.isSystem());
        task.setState(TaskState.QUEUED);
        String identifiedRunnableId = taskDescriptor.getIdentifiedRunnableId();
        boolean singletonRunnable = this.instantiateRunnableById(identifiedRunnableId).isSingleton();
        try {
            if (sync) {
                task.run();
            } else {
                if (singletonRunnable || taskDescriptor.isSingleton()) {
                    ExecutorService executorService;
                    if (!this.perRunnableSingletonExecutorService.containsKey(identifiedRunnableId)) {
                        executorService = Executors.newSingleThreadExecutor();
                        this.perRunnableSingletonExecutorService.put(identifiedRunnableId, executorService);
                    }
                    executorService = this.perRunnableSingletonExecutorService.get(identifiedRunnableId);
                    executorService.execute(task);
                } else {
                    this.parallelExecutorService.execute(task);
                }
                this.triggeredTasks.add(task);
            }
        }
        catch (RejectedExecutionException re) {
            task.setState(TaskState.CANCELLED);
            throw new TaskException(1, (Throwable)re);
        }
        return task;
    }

    @Override
    public ITask trigger(String taskDescriptorReferenceId, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        IQuery query = this.taskModelService.getQuery(ITaskDescriptor.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__REFERENCE_ID, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptorReferenceId);
        Optional taskDescriptor = query.executeSingleResult();
        if (taskDescriptor.isPresent()) {
            return this.trigger((ITaskDescriptor)taskDescriptor.get(), progressMonitor, triggerType, runContext);
        }
        throw new TaskException(1, "Could not find task descriptor reference id [" + taskDescriptorReferenceId + "]");
    }

    @Override
    public IIdentifiedRunnable instantiateRunnableById(String runnableId) throws TaskException {
        if (runnableId == null || runnableId.length() == 0) {
            throw new TaskException(2);
        }
        IIdentifiedRunnableFactory iIdentifiedRunnableFactory = this.runnableIdToFactoryMap.get(runnableId);
        if (iIdentifiedRunnableFactory != null) {
            List providedRunnables = iIdentifiedRunnableFactory.getProvidedRunnables();
            for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
                if (!runnableId.equalsIgnoreCase(iIdentifiedRunnable.getId())) continue;
                return iIdentifiedRunnable;
            }
        }
        String reason = iIdentifiedRunnableFactory == null ? "no registered factory found" : "runnable id not found in factory [" + iIdentifiedRunnableFactory.getClass().getName() + "]";
        throw new TaskException(3, "Could not instantiate runnable id [" + runnableId + "]: " + reason);
    }

    @Override
    public void saveTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        boolean save = this.taskModelService.save((Identifiable)taskDescriptor);
        if (!save) {
            throw new TaskException(4);
        }
    }

    @Override
    public void setActive(ITaskDescriptor taskDescriptor, boolean active) throws TaskException {
        if (taskDescriptor.isActive() == active) {
            return;
        }
        if (active) {
            this.validateTaskDescriptor(taskDescriptor);
        }
        taskDescriptor.setActive(active);
        this.saveTaskDescriptor(taskDescriptor);
        if (active) {
            this.incur(taskDescriptor);
        } else {
            this.release(taskDescriptor);
        }
    }

    private void validateTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        IIdentifiedRunnable runnable = this.instantiateRunnableById(taskDescriptor.getIdentifiedRunnableId());
        if (TaskTriggerType.OTHER_TASK == taskDescriptor.getTriggerType()) {
            return;
        }
        if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
            return;
        }
        Set entrySet = runnable.getDefaultRunContext().entrySet();
        for (Map.Entry entry : entrySet) {
            Serializable value;
            if (!"missingRequired".equals(entry.getValue()) || (value = taskDescriptor.getRunContext().get(entry.getKey())) != null && !"missingRequired".equals(value)) continue;
            throw new TaskException(5, "Missing required parameter [" + (String)entry.getKey() + "]");
        }
        if (taskDescriptor.getOwner() == null) {
            throw new TaskException(5, "Missing owner");
        }
    }

    @Override
    public List<IIdentifiedRunnable> getIdentifiedRunnables() {
        return this.identifiedRunnables;
    }

    @Override
    public Optional<ITaskDescriptor> findTaskDescriptorByIdOrReferenceId(String idOrReferenceId) {
        IQuery query = this.taskModelService.getQuery(ITaskDescriptor.class, true, false);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__ID, IQuery.COMPARATOR.EQUALS, (Object)idOrReferenceId);
        query.or((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__REFERENCE_ID, IQuery.COMPARATOR.EQUALS, (Object)idOrReferenceId);
        return query.executeSingleResult();
    }

    @Override
    public Optional<ITask> findLatestExecution(ITaskDescriptor taskDescriptor) {
        IQuery query = this.taskModelService.getQuery(ITask.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK__TASK_DESCRIPTOR, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptor);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
        query.limit(1);
        List result = query.execute();
        return result.isEmpty() ? Optional.empty() : Optional.of((ITask)result.get(0));
    }

    @Override
    public List<ITask> getRunningTasks() {
        return new ArrayList<ITask>(this.triggeredTasks);
    }

    @Override
    public List<ITaskDescriptor> getIncurredTasks() {
        ArrayList<ITaskDescriptor> projectedTaskDescriptors = new ArrayList<ITaskDescriptor>();
        Set<String[]> incurred = this.quartzExecutor.getIncurred();
        incurred.stream().forEach(i -> {
            ITaskDescriptor taskDescriptor = this.taskModelService.load(i[0], ITaskDescriptor.class).orElse(null);
            if (taskDescriptor != null) {
                taskDescriptor.getTransientData().put("cron-next-exectime", i[1]);
                projectedTaskDescriptors.add(taskDescriptor);
            }
        });
        return projectedTaskDescriptors;
    }
}

