/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Leistungsblock;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CodeElementBlock
extends AbstractIdDeleteModelAdapter<Leistungsblock>
implements IdentifiableWithXid,
ICodeElementBlock {
    private static final String SEPARATOR = ":=:";

    public CodeElementBlock(Leistungsblock entity) {
        super((EntityWithId)entity);
    }

    public String getCodeSystemName() {
        return "Block";
    }

    public String getCode() {
        return ((Leistungsblock)this.getEntity()).getName();
    }

    public void setCode(String value) {
        ((Leistungsblock)this.getEntityMarkDirty()).setName(value);
    }

    public String getText() {
        return ((Leistungsblock)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((Leistungsblock)this.getEntityMarkDirty()).setName(value);
    }

    public List<ICodeElement> getElements(IEncounter encounter) {
        String codeelements;
        ICodeElementService service = CodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && StringUtils.isNotBlank((CharSequence)(codeelements = ((Leistungsblock)this.getEntity()).getServices()))) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Optional created = service.loadFromString(part, CodeElementServiceHolder.createContext((IEncounter)encounter));
                created.ifPresent(c -> {
                    boolean bl = ret.add((ICodeElement)c);
                });
                ++n2;
            }
        }
        return ret;
    }

    public List<ICodeElement> getElements() {
        String codeelements;
        ICodeElementService service = CodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && StringUtils.isNotBlank((CharSequence)(codeelements = ((Leistungsblock)this.getEntity()).getServices()))) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Optional created = service.loadFromString(part, CodeElementServiceHolder.createContext());
                created.ifPresent(c -> {
                    boolean bl = ret.add((ICodeElement)c);
                });
                ++n2;
            }
        }
        return ret;
    }

    public List<ICodeElement> getElementReferences() {
        String codeelements;
        ICodeElementService service = CodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && StringUtils.isNotBlank((CharSequence)(codeelements = ((Leistungsblock)this.getEntity()).getServices()))) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] elementParts = service.getStoreToStringParts(part);
                if (elementParts != null && elementParts.length > 1) {
                    CodeElementReference reference = new CodeElementReference(elementParts[0], elementParts[1]);
                    if (elementParts.length > 2) {
                        reference.setText(elementParts[2]);
                    }
                    ret.add(reference);
                }
                ++n2;
            }
        }
        return ret;
    }

    public IMandator getMandator() {
        if (((Leistungsblock)this.getEntity()).getMandator() != null) {
            return ModelUtil.getAdapter((EntityWithId)((Leistungsblock)this.getEntity()).getMandator(), IMandator.class);
        }
        return null;
    }

    public void setMandator(IMandator value) {
        if (value instanceof AbstractIdModelAdapter) {
            ((Leistungsblock)this.getEntityMarkDirty()).setMandator((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else if (value == null) {
            ((Leistungsblock)this.getEntityMarkDirty()).setMandator(null);
        }
    }

    public String getMacro() {
        return ((Leistungsblock)this.getEntity()).getMacro();
    }

    public void setMacro(String value) {
        ((Leistungsblock)this.getEntityMarkDirty()).setMacro(value);
    }

    public List<ICodeElement> getDiffToReferences(List<ICodeElement> elements) {
        List<ICodeElement> references = this.getElementReferences();
        if (references.size() > elements.size()) {
            ICodeElement[] iCodeElementArray = references.toArray(new ICodeElement[references.size()]);
            int n = iCodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICodeElement reference = iCodeElementArray[n2];
                for (ICodeElement element : elements) {
                    if (!this.isMatchingCodeElement(element, reference)) continue;
                    references.remove(reference);
                }
                ++n2;
            }
        } else {
            references.clear();
        }
        return references;
    }

    public void addElement(ICodeElement element) {
        if (element != null) {
            List<ICodeElement> elements = this.getElementReferences();
            int index = this.getIndexOf(elements, element);
            if (index != -1) {
                elements.add(index, element);
            } else {
                elements.add(element);
            }
            this.storeElements(elements);
        }
    }

    public void removeElement(ICodeElement element) {
        if (element != null) {
            List<ICodeElement> elements = this.getElementReferences();
            int index = this.getIndexOf(elements, element);
            if (index != -1) {
                elements.remove(index);
            }
            this.storeElements(elements);
        }
    }

    public void moveElement(ICodeElement element, boolean up) {
        if (element != null) {
            this.groupElements();
            List<ICodeElement> elements = this.getElementReferences();
            long count = this.getNumberOf(element);
            int index = this.getIndexOf(elements, element);
            if (up) {
                int offset = -1;
                if (index + offset >= 0) {
                    ICodeElement pervElement = elements.get(index + offset);
                    long nextElementCount = this.getNumberOf(pervElement);
                    if (nextElementCount > 1L) {
                        offset = (int)nextElementCount * -1;
                    }
                    Collections.rotate(elements.subList(index + offset, (int)((long)index + count)), offset);
                    this.storeElements(elements);
                }
            } else {
                int offset = 1;
                if ((long)index + count + (long)offset <= (long)elements.size()) {
                    ICodeElement nextElement;
                    long nextElementCount;
                    if (offset == 1 && (nextElementCount = this.getNumberOf(nextElement = elements.get((int)((long)index + (count - 1L) + (long)offset)))) > 1L) {
                        offset = (int)nextElementCount;
                    }
                    Collections.rotate(elements.subList(index, (int)((long)index + count + (long)offset)), offset);
                    this.storeElements(elements);
                }
            }
        }
    }

    private long getNumberOf(ICodeElement element) {
        List<ICodeElement> elements = this.getElementReferences();
        return elements.stream().filter(e -> this.isMatchingCodeElement((ICodeElement)e, element)).count();
    }

    private void groupElements() {
        ArrayList<ArrayList<ICodeElement>> order = new ArrayList<ArrayList<ICodeElement>>();
        HashMap<String, ArrayList<ICodeElement>> group = new HashMap<String, ArrayList<ICodeElement>>();
        List<ICodeElement> elements = this.getElementReferences();
        for (ICodeElement iCodeElement : elements) {
            String key = String.valueOf(iCodeElement.getCodeSystemName()) + iCodeElement.getCode();
            ArrayList<ICodeElement> list = (ArrayList<ICodeElement>)group.get(key);
            if (list == null) {
                list = new ArrayList<ICodeElement>();
                list.add(iCodeElement);
                group.put(key, list);
                order.add(list);
                continue;
            }
            list.add(iCodeElement);
        }
        ArrayList<ICodeElement> sortedGrouped = new ArrayList<ICodeElement>();
        for (List list : order) {
            sortedGrouped.addAll(list);
        }
        this.storeElements(sortedGrouped);
    }

    private int getIndexOf(List<ICodeElement> elements, ICodeElement element) {
        if (element != null && elements != null) {
            int i = 0;
            while (i < elements.size()) {
                if (this.isMatchingCodeElement(element, elements.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void storeElements(List<ICodeElement> elements) {
        ICodeElementService service = CodeElementServiceHolder.get();
        if (service != null) {
            StringBuilder sb = new StringBuilder();
            for (ICodeElement element : elements) {
                if (sb.length() > 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(service.storeToString(element));
            }
            ((Leistungsblock)this.getEntityMarkDirty()).setServices(sb.toString());
        }
    }

    private boolean isMatchingCodeElement(ICodeElement left, ICodeElement right) {
        String lCodeSystemName = left.getCodeSystemName();
        String rCodeSystemName = right.getCodeSystemName();
        String lCode = left.getCode();
        String rCode = right.getCode();
        return lCodeSystemName != null && rCodeSystemName != null && lCode != null && rCode != null && lCodeSystemName.equals(rCodeSystemName) && lCode.equals(rCode);
    }

    public String getLabel() {
        String name = ((Leistungsblock)this.getEntity()).getName();
        String macro = ((Leistungsblock)this.getEntity()).getMacro();
        if (macro == null || macro.length() == 0 || macro.equals(name)) {
            return name;
        }
        return String.valueOf(name) + " [" + macro + "]";
    }

    private class CodeElementReference
    implements ICodeElement {
        private String codeSystemName;
        private String code;
        private String text;

        public CodeElementReference(String system, String code) {
            this.codeSystemName = system;
            this.code = code;
        }

        public String getCodeSystemName() {
            return this.codeSystemName;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String value) {
            this.code = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            this.text = value;
        }

        public String toString() {
            return String.valueOf(this.code) + " " + StringUtils.abbreviate((String)this.text, (int)50) + " (" + this.codeSystemName + ")";
        }
    }
}

