/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util.idgenerator;

import ca.uhn.hl7v2.util.idgenerator.HiLoGenerator;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.io.IOException;

public class DelegatingHiLoGenerator
extends HiLoGenerator {
    private IDGenerator.Ordered delegate;

    public DelegatingHiLoGenerator() {
    }

    public DelegatingHiLoGenerator(IDGenerator.Ordered delegate) {
        this.delegate = delegate;
    }

    @Override
    protected long getNextHiId() throws IOException {
        if (this.delegate == null) {
            throw new NullPointerException("Must initialize delegate IDGenerator");
        }
        return Long.parseLong(this.delegate.getID());
    }

    public void setDelegate(IDGenerator.Ordered delegate) {
        this.delegate = delegate;
    }

    @Override
    protected void resetHiId() {
        this.delegate.reset();
    }

    @Override
    public long getMaxLo() {
        return this.delegate.getIncrement();
    }
}

