/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.HapiContextSupport;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractSuperMessage;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.StringUtil;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.ValidationExceptionHandlerFactory;
import ca.uhn.hl7v2.validation.Validator;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Parser
extends HapiContextSupport {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);

    public Parser() {
        this(new DefaultHapiContext());
    }

    public Parser(HapiContext context) {
        super(context);
    }

    public Parser(ModelClassFactory modelClassFactory) {
        this(new DefaultHapiContext(modelClassFactory));
    }

    public ModelClassFactory getFactory() {
        return this.getHapiContext().getModelClassFactory();
    }

    public ValidationContext getValidationContext() {
        return this.isValidating() ? this.getHapiContext().getValidationContext() : null;
    }

    public void setValidationContext(ValidationContext context) {
        DefaultHapiContext newContext = new DefaultHapiContext(this.getHapiContext());
        newContext.setValidationContext(context);
        this.setHapiContext(newContext);
    }

    public ParserConfiguration getParserConfiguration() {
        return this.getHapiContext().getParserConfiguration();
    }

    public void setParserConfiguration(ParserConfiguration configuration) {
        DefaultHapiContext newContext = new DefaultHapiContext(this.getHapiContext());
        newContext.setParserConfiguration(configuration);
        this.setHapiContext(newContext);
    }

    public abstract String getEncoding(String var1);

    public boolean supportsEncoding(String encoding) {
        return this.getDefaultEncoding().equalsIgnoreCase(encoding);
    }

    public abstract String getDefaultEncoding();

    public Message parse(String message) throws HL7Exception {
        String encoding = this.getEncoding(message);
        if (!this.supportsEncoding(encoding)) {
            int indexOfCR;
            String startOfMessage = null;
            if (message.startsWith("MSH") && (indexOfCR = message.indexOf(13)) > 0) {
                startOfMessage = message.substring(0, indexOfCR);
            }
            if (startOfMessage == null) {
                startOfMessage = message.substring(0, Math.min(message.length(), 50));
            }
            throw new EncodingNotSupportedException("Determine encoding for message. The following is the first 50 chars of the message for reference, although this may not be where the issue is: " + startOfMessage);
        }
        String version = this.getVersion(message);
        if (!this.getParserConfiguration().isAllowUnknownVersions()) {
            Parser.assertVersionExists(version);
        }
        this.assertMessageValidates(message, encoding, version);
        Message result = this.doParse(message, version);
        this.assertMessageValidates(result);
        result.setParser(this);
        this.applySuperStructureName(result);
        return result;
    }

    protected abstract Message doParse(String var1, String var2) throws HL7Exception;

    public String encode(Message source, String encoding) throws HL7Exception {
        this.assertMessageValidates(source);
        String result = this.doEncode(source, encoding);
        this.assertMessageValidates(result, encoding, source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1, String var2) throws HL7Exception;

    public String encode(Message source) throws HL7Exception {
        this.assertMessageValidates(source);
        String result = this.doEncode(source);
        this.assertMessageValidates(result, this.getDefaultEncoding(), source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1) throws HL7Exception;

    public abstract Segment getCriticalResponseData(String var1) throws HL7Exception;

    public abstract String getAckID(String var1);

    public abstract String getVersion(String var1) throws HL7Exception;

    public abstract String doEncode(Segment var1, EncodingCharacters var2) throws HL7Exception;

    public abstract String doEncode(Type var1, EncodingCharacters var2) throws HL7Exception;

    public abstract void parse(Type var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public Message parseForSpecificPackage(String message, String packageName) throws HL7Exception {
        String encoding = this.getEncoding(message);
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("Can't parse message beginning " + message.substring(0, Math.min(message.length(), 50)));
        }
        String version = this.getVersion(message);
        Parser.assertVersionExists(version);
        this.assertMessageValidates(message, encoding, version);
        Message result = this.doParseForSpecificPackage(message, version, packageName);
        this.assertMessageValidates(result);
        result.setParser(this);
        return result;
    }

    protected abstract Message doParseForSpecificPackage(String var1, String var2, String var3) throws HL7Exception;

    protected Message instantiateMessageInASpecificPackage(String theName, String theVersion, boolean isExplicit, String packageName) throws HL7Exception {
        Class<? extends Message> messageClass = this.getFactory().getMessageClassInASpecificPackage(theName, theVersion, isExplicit, packageName);
        if (messageClass == null) {
            throw new HL7Exception("Can't find message class in current package list: " + theName);
        }
        return ReflectionUtil.instantiateMessage(messageClass, this.getFactory());
    }

    public abstract void parse(Segment var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public abstract void parse(Message var1, String var2) throws HL7Exception;

    public static Segment makeControlMSH(String version, ModelClassFactory factory) throws HL7Exception {
        Segment msh;
        try {
            Class<? extends Message> genericMessageClass = GenericMessage.getGenericMessageClass(version);
            Constructor<? extends Message> constr = genericMessageClass.getConstructor(ModelClassFactory.class);
            Message dummy = constr.newInstance(factory);
            Class<? extends Segment> c = null;
            if (Version.supportsVersion(version)) {
                c = factory.getSegmentClass("MSH", version);
            }
            if (c != null) {
                if (GenericSegment.class.isAssignableFrom(c)) {
                    Class[] constructorParamTypes = new Class[]{Group.class, String.class};
                    Object[] constructorParamArgs = new Object[]{dummy, "MSH"};
                    Constructor<? extends Segment> constructor = c.getConstructor(constructorParamTypes);
                    msh = constructor.newInstance(constructorParamArgs);
                } else {
                    Class[] constructorParamTypes = new Class[]{Group.class, ModelClassFactory.class};
                    Object[] constructorParamArgs = new Object[]{dummy, factory};
                    Constructor<? extends Segment> constructor = c.getConstructor(constructorParamTypes);
                    msh = constructor.newInstance(constructorParamArgs);
                }
            } else {
                msh = new GenericSegment((Group)dummy, "MSH");
            }
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create MSH for version " + version + " (does your classpath include this version?) ... ", e);
        }
        return msh;
    }

    @Deprecated
    public static boolean validVersion(String version) {
        return Version.supportsVersion(version);
    }

    public static void assertVersionExists(String version) throws HL7Exception {
        if (!Version.supportsVersion(version)) {
            throw new HL7Exception("The HL7 version " + version + " is not recognized", ErrorCode.UNSUPPORTED_VERSION_ID);
        }
    }

    public String getMessageStructureForEvent(String name, String version) throws HL7Exception {
        Parser.assertVersionExists(version);
        return this.getHapiContext().getModelClassFactory().getMessageStructureForEvent(name, Version.versionOf(version));
    }

    protected Message instantiateMessage(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
        Class<? extends Message> messageClass = this.getFactory().getMessageClass(theName, theVersion, isExplicit);
        if (messageClass == null) {
            throw new HL7Exception("Can't find message class in current package list: " + theName);
        }
        return ReflectionUtil.instantiateMessage(messageClass, this.getFactory());
    }

    protected void applySuperStructureName(Message theMessage) throws HL7Exception {
        if (theMessage instanceof AbstractSuperMessage && theMessage.getName() == null) {
            Terser t = new Terser(theMessage);
            String name = null;
            try {
                name = t.get("/MSH-9-3");
            }
            catch (HL7Exception hL7Exception) {
                // empty catch block
            }
            if (StringUtil.isBlank(name)) {
                name = t.get("/MSH-9-1") + "_" + t.get("/MSH-9-2");
            }
            ((AbstractSuperMessage)theMessage).setName(name);
        }
    }

    private <R> void assertMessageValidates(String message, String encoding, String version) throws HL7Exception {
        if (this.isValidating()) {
            Validator validator = this.getHapiContext().getMessageValidator();
            ValidationExceptionHandlerFactory factory = this.getHapiContext().getValidationExceptionHandlerFactory();
            ValidationExceptionHandler handler = factory.getNewInstance(this.getHapiContext());
            Object result = validator.validate(message, encoding.equals("XML"), version, handler);
            this.handleException(handler, result);
        }
    }

    private <R> void assertMessageValidates(Message message) throws HL7Exception {
        if (this.isValidating()) {
            Validator validator = this.getHapiContext().getMessageValidator();
            ValidationExceptionHandlerFactory factory = this.getHapiContext().getValidationExceptionHandlerFactory();
            if (factory == null) {
                throw new NullPointerException("Validation is enabled for this parser, but ValidationExceptionHandlerFactory is null");
            }
            ValidationExceptionHandler handler = factory.getNewInstance(this.getHapiContext());
            Object result = validator.validate(message, handler);
            this.handleException(handler, result);
        }
    }

    private <R> void handleException(ValidationExceptionHandler<R> handler, R result) throws HL7Exception {
        if (handler.hasFailed()) {
            HL7Exception e = new HL7Exception("Validation has failed");
            e.setDetail(result);
            if (result instanceof Message) {
                e.setResponseMessage((Message)result);
            }
            throw e;
        }
    }

    private boolean isValidating() {
        return this.getHapiContext().getParserConfiguration().isValidating();
    }
}

