/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.NULLDT;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PR1
extends AbstractSegment {
    public PR1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - PR1");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Coding Method");
            this.add(CNE.class, true, 1, 705, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Description");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Procedure Date/Time");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(230)}, "Procedure Functional Type");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Procedure Minutes");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Anesthesiologist");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(19)}, "Anesthesia Code");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Anesthesia Minutes");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Surgeon");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Practitioner");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Code");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(418)}, "Procedure Priority");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Associated Diagnosis Code");
            this.add(CNE.class, false, 0, 705, new Object[]{this.getMessage()}, "Procedure Code Modifier");
            this.add(IS.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(416)}, "Procedure DRG Type");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Tissue Type Code");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage()}, "Procedure Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(206)}, "Procedure Action Code");
            this.add(IS.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(761)}, "DRG Procedure Determination Status");
            this.add(IS.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(763)}, "DRG Procedure Relevance");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPR1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPr11_SetIDPR1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getProcedureCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getPr12_ProcedureCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public CNE getPr13_ProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getProcedureDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getPr14_ProcedureDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getProcedureDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getPr15_ProcedureDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getProcedureFunctionalType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getPr16_ProcedureFunctionalType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPr17_ProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NULLDT getAnesthesiologist() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public NULLDT getPr18_Anesthesiologist() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getAnesthesiaCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getPr19_AnesthesiaCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPr110_AnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NULLDT getSurgeon() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public NULLDT getPr111_Surgeon() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public NULLDT getProcedurePractitioner() {
        NULLDT retVal = (NULLDT)this.getTypedField(12, 0);
        return retVal;
    }

    public NULLDT getPr112_ProcedurePractitioner() {
        NULLDT retVal = (NULLDT)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getConsentCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPr113_ConsentCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getProcedurePriority() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getPr114_ProcedurePriority() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getAssociatedDiagnosisCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getPr115_AssociatedDiagnosisCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(16, new CNE[0]);
        return retVal;
    }

    public CNE[] getPr116_ProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(16, new CNE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(16);
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(16, rep);
        return retVal;
    }

    public CNE getPr116_ProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(16, rep);
        return retVal;
    }

    public int getPr116_ProcedureCodeModifierReps() {
        return this.getReps(16);
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(16, rep);
    }

    public CNE insertPr116_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(16, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(16, rep);
    }

    public CNE removePr116_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(16, rep);
    }

    public IS getProcedureDRGType() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getPr117_ProcedureDRGType() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getTissueTypeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public CWE[] getPr118_TissueTypeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public int getTissueTypeCodeReps() {
        return this.getReps(18);
    }

    public CWE getTissueTypeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getPr118_TissueTypeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getPr118_TissueTypeCodeReps() {
        return this.getReps(18);
    }

    public CWE insertTissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertPr118_TissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeTissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removePr118_TissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public EI getProcedureIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public EI getPr119_ProcedureIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getProcedureActionCode() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getPr120_ProcedureActionCode() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getDRGProcedureDeterminationStatus() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getPr121_DRGProcedureDeterminationStatus() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getDRGProcedureRelevance() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getPr122_DRGProcedureRelevance() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NULLDT(this.getMessage());
            }
            case 2: {
                return new CNE(this.getMessage());
            }
            case 3: {
                return new NULLDT(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(230));
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NULLDT(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(19));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NULLDT(this.getMessage());
            }
            case 11: {
                return new NULLDT(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(418));
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CNE(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(416));
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new EI(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(761));
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(763));
            }
        }
        return null;
    }
}

