/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.FT;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EQP
extends AbstractSegment {
    public EQP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Event type");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "File Name");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "End Date/Time");
            this.add(FT.class, true, 1, 65536, new Object[]{this.getMessage()}, "Transaction Data");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EQP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getEventType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getEqp1_EventType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getFileName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getEqp2_FileName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getEqp3_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getEqp4_EndDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public FT getTransactionData() {
        FT retVal = (FT)this.getTypedField(5, 0);
        return retVal;
    }

    public FT getEqp5_TransactionData() {
        FT retVal = (FT)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new FT(this.getMessage());
            }
        }
        return null;
    }
}

