/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E15_ADJUSTMENT_PAYEE;
import ca.uhn.hl7v2.model.v26.group.EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PMT;
import ca.uhn.hl7v2.model.v26.segment.PYE;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E15
extends AbstractMessage {
    public EHC_E15() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E15(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(PMT.class, true, false);
            this.add(PYE.class, true, false);
            this.add(EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO.class, false, true);
            this.add(EHC_E15_ADJUSTMENT_PAYEE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E15 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public PMT getPMT() {
        return this.getTyped("PMT", PMT.class);
    }

    public PYE getPYE() {
        return this.getTyped("PYE", PYE.class);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO getPAYMENT_REMITTANCE_DETAIL_INFO() {
        return this.getTyped("PAYMENT_REMITTANCE_DETAIL_INFO", EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO.class);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO getPAYMENT_REMITTANCE_DETAIL_INFO(int rep) {
        return this.getTyped("PAYMENT_REMITTANCE_DETAIL_INFO", rep, EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO.class);
    }

    public int getPAYMENT_REMITTANCE_DETAIL_INFOReps() {
        return this.getReps("PAYMENT_REMITTANCE_DETAIL_INFO");
    }

    public List<EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO> getPAYMENT_REMITTANCE_DETAIL_INFOAll() throws HL7Exception {
        return this.getAllAsList("PAYMENT_REMITTANCE_DETAIL_INFO", EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO.class);
    }

    public void insertPAYMENT_REMITTANCE_DETAIL_INFO(EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", structure, rep);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO insertPAYMENT_REMITTANCE_DETAIL_INFO(int rep) throws HL7Exception {
        return (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)super.insertRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", rep);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO removePAYMENT_REMITTANCE_DETAIL_INFO(int rep) throws HL7Exception {
        return (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)super.removeRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE getADJUSTMENT_PAYEE() {
        return this.getTyped("ADJUSTMENT_PAYEE", EHC_E15_ADJUSTMENT_PAYEE.class);
    }

    public EHC_E15_ADJUSTMENT_PAYEE getADJUSTMENT_PAYEE(int rep) {
        return this.getTyped("ADJUSTMENT_PAYEE", rep, EHC_E15_ADJUSTMENT_PAYEE.class);
    }

    public int getADJUSTMENT_PAYEEReps() {
        return this.getReps("ADJUSTMENT_PAYEE");
    }

    public List<EHC_E15_ADJUSTMENT_PAYEE> getADJUSTMENT_PAYEEAll() throws HL7Exception {
        return this.getAllAsList("ADJUSTMENT_PAYEE", EHC_E15_ADJUSTMENT_PAYEE.class);
    }

    public void insertADJUSTMENT_PAYEE(EHC_E15_ADJUSTMENT_PAYEE structure, int rep) throws HL7Exception {
        super.insertRepetition("ADJUSTMENT_PAYEE", structure, rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE insertADJUSTMENT_PAYEE(int rep) throws HL7Exception {
        return (EHC_E15_ADJUSTMENT_PAYEE)super.insertRepetition("ADJUSTMENT_PAYEE", rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE removeADJUSTMENT_PAYEE(int rep) throws HL7Exception {
        return (EHC_E15_ADJUSTMENT_PAYEE)super.removeRepetition("ADJUSTMENT_PAYEE", rep);
    }
}

