/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.BAR_P01_VISIT;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BAR_P01
extends AbstractMessage {
    public BAR_P01() {
        this(new DefaultModelClassFactory());
    }

    public BAR_P01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ROL.class, false, true);
            this.add(BAR_P01_VISIT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BAR_P01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public BAR_P01_VISIT getVISIT() {
        return this.getTyped("VISIT", BAR_P01_VISIT.class);
    }

    public BAR_P01_VISIT getVISIT(int rep) {
        return this.getTyped("VISIT", rep, BAR_P01_VISIT.class);
    }

    public int getVISITReps() {
        return this.getReps("VISIT");
    }

    public List<BAR_P01_VISIT> getVISITAll() throws HL7Exception {
        return this.getAllAsList("VISIT", BAR_P01_VISIT.class);
    }

    public void insertVISIT(BAR_P01_VISIT structure, int rep) throws HL7Exception {
        super.insertRepetition("VISIT", structure, rep);
    }

    public BAR_P01_VISIT insertVISIT(int rep) throws HL7Exception {
        return (BAR_P01_VISIT)super.insertRepetition("VISIT", rep);
    }

    public BAR_P01_VISIT removeVISIT(int rep) throws HL7Exception {
        return (BAR_P01_VISIT)super.removeRepetition("VISIT", rep);
    }
}

