/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_CONTAINER;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_ORDER;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v26.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPU_R25_SPECIMEN
extends AbstractGroup {
    public OPU_R25_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OPU_R25_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OPU_R25_CONTAINER.class, false, true, false);
            this.add(OPU_R25_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPU_R25_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OPU_R25_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OPU_R25_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", OPU_R25_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OPU_R25_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OPU_R25_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", rep, OPU_R25_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OPU_R25_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OPU_R25_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OPU_R25_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", structure, rep);
    }

    public OPU_R25_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPU_R25_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPU_R25_CONTAINER getCONTAINER() {
        OPU_R25_CONTAINER retVal = this.getTyped("CONTAINER", OPU_R25_CONTAINER.class);
        return retVal;
    }

    public OPU_R25_CONTAINER getCONTAINER(int rep) {
        OPU_R25_CONTAINER retVal = this.getTyped("CONTAINER", rep, OPU_R25_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OPU_R25_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OPU_R25_CONTAINER.class);
    }

    public void insertCONTAINER(OPU_R25_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", structure, rep);
    }

    public OPU_R25_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OPU_R25_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OPU_R25_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OPU_R25_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OPU_R25_ORDER getORDER() {
        OPU_R25_ORDER retVal = this.getTyped("ORDER", OPU_R25_ORDER.class);
        return retVal;
    }

    public OPU_R25_ORDER getORDER(int rep) {
        OPU_R25_ORDER retVal = this.getTyped("ORDER", rep, OPU_R25_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OPU_R25_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OPU_R25_ORDER.class);
    }

    public void insertORDER(OPU_R25_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OPU_R25_ORDER insertORDER(int rep) throws HL7Exception {
        return (OPU_R25_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OPU_R25_ORDER removeORDER(int rep) throws HL7Exception {
        return (OPU_R25_ORDER)super.removeRepetition("ORDER", rep);
    }
}

