/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.EHC_E13_RESPONSE;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E13_REQUEST
extends AbstractGroup {
    public EHC_E13_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CTD.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, false, false);
            this.add(EHC_E13_RESPONSE.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E13_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public CTD getCTD() {
        CTD retVal = this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public EHC_E13_RESPONSE getRESPONSE() {
        EHC_E13_RESPONSE retVal = this.getTyped("RESPONSE", EHC_E13_RESPONSE.class);
        return retVal;
    }

    public EHC_E13_RESPONSE getRESPONSE(int rep) {
        EHC_E13_RESPONSE retVal = this.getTyped("RESPONSE", rep, EHC_E13_RESPONSE.class);
        return retVal;
    }

    public int getRESPONSEReps() {
        return this.getReps("RESPONSE");
    }

    public List<EHC_E13_RESPONSE> getRESPONSEAll() throws HL7Exception {
        return this.getAllAsList("RESPONSE", EHC_E13_RESPONSE.class);
    }

    public void insertRESPONSE(EHC_E13_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("RESPONSE", structure, rep);
    }

    public EHC_E13_RESPONSE insertRESPONSE(int rep) throws HL7Exception {
        return (EHC_E13_RESPONSE)super.insertRepetition("RESPONSE", rep);
    }

    public EHC_E13_RESPONSE removeRESPONSE(int rep) throws HL7Exception {
        return (EHC_E13_RESPONSE)super.removeRepetition("RESPONSE", rep);
    }
}

