/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.ADR_A19_INSURANCE;
import ca.uhn.hl7v2.model.v26.group.ADR_A19_PROCEDURE;
import ca.uhn.hl7v2.model.v26.segment.ACC;
import ca.uhn.hl7v2.model.v26.segment.AL1;
import ca.uhn.hl7v2.model.v26.segment.ARV;
import ca.uhn.hl7v2.model.v26.segment.DB1;
import ca.uhn.hl7v2.model.v26.segment.DG1;
import ca.uhn.hl7v2.model.v26.segment.DRG;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.GT1;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.model.v26.segment.PV2;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.UB1;
import ca.uhn.hl7v2.model.v26.segment.UB2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADR_A19_QUERY_RESPONSE
extends AbstractGroup {
    public ADR_A19_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EVN.class, false, false, false);
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(ARV.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(NK1.class, false, true, false);
            this.add(PV1.class, true, false, false);
            this.add(PV2.class, false, false, false);
            this.add(ARV.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(DB1.class, false, true, false);
            this.add(OBX.class, false, true, false);
            this.add(AL1.class, false, true, false);
            this.add(DG1.class, false, true, false);
            this.add(DRG.class, false, false, false);
            this.add(ADR_A19_PROCEDURE.class, false, true, false);
            this.add(GT1.class, false, true, false);
            this.add(ADR_A19_INSURANCE.class, false, true, false);
            this.add(ACC.class, false, false, false);
            this.add(UB1.class, false, false, false);
            this.add(UB2.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADR_A19_QUERY_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public EVN getEVN() {
        EVN retVal = this.getTyped("EVN", EVN.class);
        return retVal;
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PV2 getPV2() {
        PV2 retVal = this.getTyped("PV2", PV2.class);
        return retVal;
    }

    public ARV getARV2() {
        ARV retVal = this.getTyped("ARV2", ARV.class);
        return retVal;
    }

    public ARV getARV2(int rep) {
        ARV retVal = this.getTyped("ARV2", rep, ARV.class);
        return retVal;
    }

    public int getARV2Reps() {
        return this.getReps("ARV2");
    }

    public List<ARV> getARV2All() throws HL7Exception {
        return this.getAllAsList("ARV2", ARV.class);
    }

    public void insertARV2(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV2", structure, rep);
    }

    public ARV insertARV2(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV2", rep);
    }

    public ARV removeARV2(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV2", rep);
    }

    public ROL getROL2() {
        ROL retVal = this.getTyped("ROL2", ROL.class);
        return retVal;
    }

    public ROL getROL2(int rep) {
        ROL retVal = this.getTyped("ROL2", rep, ROL.class);
        return retVal;
    }

    public int getROL2Reps() {
        return this.getReps("ROL2");
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        DB1 retVal = this.getTyped("DB1", DB1.class);
        return retVal;
    }

    public DB1 getDB1(int rep) {
        DB1 retVal = this.getTyped("DB1", rep, DB1.class);
        return retVal;
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        DG1 retVal = this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG retVal = this.getTyped("DRG", DRG.class);
        return retVal;
    }

    public ADR_A19_PROCEDURE getPROCEDURE() {
        ADR_A19_PROCEDURE retVal = this.getTyped("PROCEDURE", ADR_A19_PROCEDURE.class);
        return retVal;
    }

    public ADR_A19_PROCEDURE getPROCEDURE(int rep) {
        ADR_A19_PROCEDURE retVal = this.getTyped("PROCEDURE", rep, ADR_A19_PROCEDURE.class);
        return retVal;
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<ADR_A19_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADR_A19_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADR_A19_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public ADR_A19_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADR_A19_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public ADR_A19_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADR_A19_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public GT1 getGT1(int rep) {
        GT1 retVal = this.getTyped("GT1", rep, GT1.class);
        return retVal;
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADR_A19_INSURANCE getINSURANCE() {
        ADR_A19_INSURANCE retVal = this.getTyped("INSURANCE", ADR_A19_INSURANCE.class);
        return retVal;
    }

    public ADR_A19_INSURANCE getINSURANCE(int rep) {
        ADR_A19_INSURANCE retVal = this.getTyped("INSURANCE", rep, ADR_A19_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<ADR_A19_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADR_A19_INSURANCE.class);
    }

    public void insertINSURANCE(ADR_A19_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public ADR_A19_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADR_A19_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ADR_A19_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADR_A19_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        ACC retVal = this.getTyped("ACC", ACC.class);
        return retVal;
    }

    public UB1 getUB1() {
        UB1 retVal = this.getTyped("UB1", UB1.class);
        return retVal;
    }

    public UB2 getUB2() {
        UB2 retVal = this.getTyped("UB2", UB2.class);
        return retVal;
    }
}

