/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNN;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.HD;
import ca.uhn.hl7v2.model.v26.datatype.IS;

public class NDL
extends AbstractComposite {
    private Type[] data;

    public NDL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[11];
        this.data[0] = new CNN(this.getMessage());
        this.data[1] = new DTM(this.getMessage());
        this.data[2] = new DTM(this.getMessage());
        this.data[3] = new IS(this.getMessage(), 302);
        this.data[4] = new IS(this.getMessage(), 303);
        this.data[5] = new IS(this.getMessage(), 304);
        this.data[6] = new HD(this.getMessage());
        this.data[7] = new IS(this.getMessage(), 306);
        this.data[8] = new IS(this.getMessage(), 305);
        this.data[9] = new IS(this.getMessage(), 307);
        this.data[10] = new IS(this.getMessage(), 308);
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CNN getNDLName() {
        return this.getTyped(0, CNN.class);
    }

    public CNN getNdl1_Name() {
        return this.getTyped(0, CNN.class);
    }

    public DTM getStartDateTime() {
        return this.getTyped(1, DTM.class);
    }

    public DTM getNdl2_StartDateTime() {
        return this.getTyped(1, DTM.class);
    }

    public DTM getEndDateTime() {
        return this.getTyped(2, DTM.class);
    }

    public DTM getNdl3_EndDateTime() {
        return this.getTyped(2, DTM.class);
    }

    public IS getPointOfCare() {
        return this.getTyped(3, IS.class);
    }

    public IS getNdl4_PointOfCare() {
        return this.getTyped(3, IS.class);
    }

    public IS getRoom() {
        return this.getTyped(4, IS.class);
    }

    public IS getNdl5_Room() {
        return this.getTyped(4, IS.class);
    }

    public IS getBed() {
        return this.getTyped(5, IS.class);
    }

    public IS getNdl6_Bed() {
        return this.getTyped(5, IS.class);
    }

    public HD getFacility() {
        return this.getTyped(6, HD.class);
    }

    public HD getNdl7_Facility() {
        return this.getTyped(6, HD.class);
    }

    public IS getLocationStatus() {
        return this.getTyped(7, IS.class);
    }

    public IS getNdl8_LocationStatus() {
        return this.getTyped(7, IS.class);
    }

    public IS getPatientLocationType() {
        return this.getTyped(8, IS.class);
    }

    public IS getNdl9_PatientLocationType() {
        return this.getTyped(8, IS.class);
    }

    public IS getBuilding() {
        return this.getTyped(9, IS.class);
    }

    public IS getNdl10_Building() {
        return this.getTyped(9, IS.class);
    }

    public IS getFloor() {
        return this.getTyped(10, IS.class);
    }

    public IS getNdl11_Floor() {
        return this.getTyped(10, IS.class);
    }
}

