/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.PPN;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class TXA
extends AbstractSegment {
    public TXA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID- TXA");
            this.add(IS.class, true, 1, 30, new Object[]{this.getMessage(), new Integer(270)}, "Document Type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(191)}, "Document Content Presentation");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Activity Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Primary Activity Provider Code/Name");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Origination Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Transcription Date/Time");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Edit Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Originator Code/Name");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Assigned Document Authenticator");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Transcriptionist Code/Name");
            this.add(EI.class, true, 1, 30, new Object[]{this.getMessage()}, "Unique Document Number");
            this.add(EI.class, false, 1, 30, new Object[]{this.getMessage()}, "Parent Document Number");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Unique Document File Name");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(271)}, "Document Completion Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(272)}, "Document Confidentiality Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(273)}, "Document Availability Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(275)}, "Document Storage Status");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Document Change Reason");
            this.add(PPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Authentication Person, Time Stamp");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Distributed Copies (Code and Name of Recipients)");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TXA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDTXA() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getTxa1_SetIDTXA() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getDocumentType() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getTxa2_DocumentType() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDocumentContentPresentation() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getTxa3_DocumentContentPresentation() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getActivityDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getTxa4_ActivityDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getPrimaryActivityProviderCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public XCN[] getTxa5_PrimaryActivityProviderCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public int getPrimaryActivityProviderCodeNameReps() {
        return this.getReps(5);
    }

    public XCN getPrimaryActivityProviderCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getTxa5_PrimaryActivityProviderCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getTxa5_PrimaryActivityProviderCodeNameReps() {
        return this.getReps(5);
    }

    public XCN insertPrimaryActivityProviderCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertTxa5_PrimaryActivityProviderCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removePrimaryActivityProviderCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeTxa5_PrimaryActivityProviderCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public TS getOriginationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getTxa6_OriginationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getTranscriptionDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getTxa7_TranscriptionDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS[] getEditDateTime() {
        TS[] retVal = (TS[])this.getTypedField(8, new TS[0]);
        return retVal;
    }

    public TS[] getTxa8_EditDateTime() {
        TS[] retVal = (TS[])this.getTypedField(8, new TS[0]);
        return retVal;
    }

    public int getEditDateTimeReps() {
        return this.getReps(8);
    }

    public TS getEditDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(8, rep);
        return retVal;
    }

    public TS getTxa8_EditDateTime(int rep) {
        TS retVal = (TS)this.getTypedField(8, rep);
        return retVal;
    }

    public int getTxa8_EditDateTimeReps() {
        return this.getReps(8);
    }

    public TS insertEditDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(8, rep);
    }

    public TS insertTxa8_EditDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(8, rep);
    }

    public TS removeEditDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(8, rep);
    }

    public TS removeTxa8_EditDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(8, rep);
    }

    public XCN[] getOriginatorCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public XCN[] getTxa9_OriginatorCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(9, new XCN[0]);
        return retVal;
    }

    public int getOriginatorCodeNameReps() {
        return this.getReps(9);
    }

    public XCN getOriginatorCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public XCN getTxa9_OriginatorCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getTxa9_OriginatorCodeNameReps() {
        return this.getReps(9);
    }

    public XCN insertOriginatorCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertTxa9_OriginatorCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeOriginatorCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removeTxa9_OriginatorCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN[] getAssignedDocumentAuthenticator() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getTxa10_AssignedDocumentAuthenticator() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getAssignedDocumentAuthenticatorReps() {
        return this.getReps(10);
    }

    public XCN getAssignedDocumentAuthenticator(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getTxa10_AssignedDocumentAuthenticator(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getTxa10_AssignedDocumentAuthenticatorReps() {
        return this.getReps(10);
    }

    public XCN insertAssignedDocumentAuthenticator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertTxa10_AssignedDocumentAuthenticator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeAssignedDocumentAuthenticator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeTxa10_AssignedDocumentAuthenticator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN[] getTranscriptionistCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public XCN[] getTxa11_TranscriptionistCodeName() {
        XCN[] retVal = (XCN[])this.getTypedField(11, new XCN[0]);
        return retVal;
    }

    public int getTranscriptionistCodeNameReps() {
        return this.getReps(11);
    }

    public XCN getTranscriptionistCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public XCN getTxa11_TranscriptionistCodeName(int rep) {
        XCN retVal = (XCN)this.getTypedField(11, rep);
        return retVal;
    }

    public int getTxa11_TranscriptionistCodeNameReps() {
        return this.getReps(11);
    }

    public XCN insertTranscriptionistCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN insertTxa11_TranscriptionistCodeName(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(11, rep);
    }

    public XCN removeTranscriptionistCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public XCN removeTxa11_TranscriptionistCodeName(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(11, rep);
    }

    public EI getUniqueDocumentNumber() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getTxa12_UniqueDocumentNumber() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getParentDocumentNumber() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public EI getTxa13_ParentDocumentNumber() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public EI[] getPlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(14, new EI[0]);
        return retVal;
    }

    public EI[] getTxa14_PlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(14, new EI[0]);
        return retVal;
    }

    public int getPlacerOrderNumberReps() {
        return this.getReps(14);
    }

    public EI getPlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(14, rep);
        return retVal;
    }

    public EI getTxa14_PlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(14, rep);
        return retVal;
    }

    public int getTxa14_PlacerOrderNumberReps() {
        return this.getReps(14);
    }

    public EI insertPlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(14, rep);
    }

    public EI insertTxa14_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(14, rep);
    }

    public EI removePlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(14, rep);
    }

    public EI removeTxa14_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(14, rep);
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(15, 0);
        return retVal;
    }

    public EI getTxa15_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getUniqueDocumentFileName() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getTxa16_UniqueDocumentFileName() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getDocumentCompletionStatus() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getTxa17_DocumentCompletionStatus() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getDocumentConfidentialityStatus() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getTxa18_DocumentConfidentialityStatus() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDocumentAvailabilityStatus() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getTxa19_DocumentAvailabilityStatus() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getDocumentStorageStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getTxa20_DocumentStorageStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getDocumentChangeReason() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getTxa21_DocumentChangeReason() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public PPN[] getAuthenticationPersonTimeStamp() {
        PPN[] retVal = (PPN[])this.getTypedField(22, new PPN[0]);
        return retVal;
    }

    public PPN[] getTxa22_AuthenticationPersonTimeStamp() {
        PPN[] retVal = (PPN[])this.getTypedField(22, new PPN[0]);
        return retVal;
    }

    public int getAuthenticationPersonTimeStampReps() {
        return this.getReps(22);
    }

    public PPN getAuthenticationPersonTimeStamp(int rep) {
        PPN retVal = (PPN)this.getTypedField(22, rep);
        return retVal;
    }

    public PPN getTxa22_AuthenticationPersonTimeStamp(int rep) {
        PPN retVal = (PPN)this.getTypedField(22, rep);
        return retVal;
    }

    public int getTxa22_AuthenticationPersonTimeStampReps() {
        return this.getReps(22);
    }

    public PPN insertAuthenticationPersonTimeStamp(int rep) throws HL7Exception {
        return (PPN)super.insertRepetition(22, rep);
    }

    public PPN insertTxa22_AuthenticationPersonTimeStamp(int rep) throws HL7Exception {
        return (PPN)super.insertRepetition(22, rep);
    }

    public PPN removeAuthenticationPersonTimeStamp(int rep) throws HL7Exception {
        return (PPN)super.removeRepetition(22, rep);
    }

    public PPN removeTxa22_AuthenticationPersonTimeStamp(int rep) throws HL7Exception {
        return (PPN)super.removeRepetition(22, rep);
    }

    public XCN[] getDistributedCopiesCodeandNameofRecipients() {
        XCN[] retVal = (XCN[])this.getTypedField(23, new XCN[0]);
        return retVal;
    }

    public XCN[] getTxa23_DistributedCopiesCodeandNameofRecipients() {
        XCN[] retVal = (XCN[])this.getTypedField(23, new XCN[0]);
        return retVal;
    }

    public int getDistributedCopiesCodeandNameofRecipientsReps() {
        return this.getReps(23);
    }

    public XCN getDistributedCopiesCodeandNameofRecipients(int rep) {
        XCN retVal = (XCN)this.getTypedField(23, rep);
        return retVal;
    }

    public XCN getTxa23_DistributedCopiesCodeandNameofRecipients(int rep) {
        XCN retVal = (XCN)this.getTypedField(23, rep);
        return retVal;
    }

    public int getTxa23_DistributedCopiesCodeandNameofRecipientsReps() {
        return this.getReps(23);
    }

    public XCN insertDistributedCopiesCodeandNameofRecipients(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(23, rep);
    }

    public XCN insertTxa23_DistributedCopiesCodeandNameofRecipients(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(23, rep);
    }

    public XCN removeDistributedCopiesCodeandNameofRecipients(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(23, rep);
    }

    public XCN removeTxa23_DistributedCopiesCodeandNameofRecipients(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(23, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(270));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(191));
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new XCN(this.getMessage());
            }
            case 11: {
                return new EI(this.getMessage());
            }
            case 12: {
                return new EI(this.getMessage());
            }
            case 13: {
                return new EI(this.getMessage());
            }
            case 14: {
                return new EI(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(271));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(272));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(273));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(275));
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new PPN(this.getMessage());
            }
            case 22: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

