/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.QIP;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ERQ
extends AbstractSegment {
    public ERQ(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Event Identifier");
            this.add(QIP.class, false, 0, 256, new Object[]{this.getMessage()}, "Input Parameter List");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ERQ - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getErq1_QueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getEventIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getErq2_EventIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public QIP[] getInputParameterList() {
        QIP[] retVal = (QIP[])this.getTypedField(3, new QIP[0]);
        return retVal;
    }

    public QIP[] getErq3_InputParameterList() {
        QIP[] retVal = (QIP[])this.getTypedField(3, new QIP[0]);
        return retVal;
    }

    public int getInputParameterListReps() {
        return this.getReps(3);
    }

    public QIP getInputParameterList(int rep) {
        QIP retVal = (QIP)this.getTypedField(3, rep);
        return retVal;
    }

    public QIP getErq3_InputParameterList(int rep) {
        QIP retVal = (QIP)this.getTypedField(3, rep);
        return retVal;
    }

    public int getErq3_InputParameterListReps() {
        return this.getReps(3);
    }

    public QIP insertInputParameterList(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(3, rep);
    }

    public QIP insertErq3_InputParameterList(int rep) throws HL7Exception {
        return (QIP)super.insertRepetition(3, rep);
    }

    public QIP removeInputParameterList(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(3, rep);
    }

    public QIP removeErq3_InputParameterList(int rep) throws HL7Exception {
        return (QIP)super.removeRepetition(3, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new QIP(this.getMessage());
            }
        }
        return null;
    }
}

