/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CK;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CDM
extends AbstractSegment {
    public CDM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Primary Key Value - CDM");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Charge Code Alias");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Charge Description Short");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Charge Description Long");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(268)}, "Description Override Indicator");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Exploding Charges");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Inventory Number");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Resource Load");
            this.add(CK.class, false, 0, 250, new Object[]{this.getMessage()}, "Contract Number");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Contract Organization");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Room Fee Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CDM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getPrimaryKeyValueCDM() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getCdm1_PrimaryKeyValueCDM() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getChargeCodeAlias() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getCdm2_ChargeCodeAlias() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getChargeCodeAliasReps() {
        return this.getReps(2);
    }

    public CE getChargeCodeAlias(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getCdm2_ChargeCodeAlias(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getCdm2_ChargeCodeAliasReps() {
        return this.getReps(2);
    }

    public CE insertChargeCodeAlias(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertCdm2_ChargeCodeAlias(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeChargeCodeAlias(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeCdm2_ChargeCodeAlias(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public ST getChargeDescriptionShort() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCdm3_ChargeDescriptionShort() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getChargeDescriptionLong() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getCdm4_ChargeDescriptionLong() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getDescriptionOverrideIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getCdm5_DescriptionOverrideIndicator() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public CE[] getExplodingCharges() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public CE[] getCdm6_ExplodingCharges() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public int getExplodingChargesReps() {
        return this.getReps(6);
    }

    public CE getExplodingCharges(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public CE getCdm6_ExplodingCharges(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getCdm6_ExplodingChargesReps() {
        return this.getReps(6);
    }

    public CE insertExplodingCharges(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE insertCdm6_ExplodingCharges(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE removeExplodingCharges(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE removeCdm6_ExplodingCharges(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE[] getProcedureCode() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public CE[] getCdm7_ProcedureCode() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public int getProcedureCodeReps() {
        return this.getReps(7);
    }

    public CE getProcedureCode(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public CE getCdm7_ProcedureCode(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getCdm7_ProcedureCodeReps() {
        return this.getReps(7);
    }

    public CE insertProcedureCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertCdm7_ProcedureCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeProcedureCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeCdm7_ProcedureCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getCdm8_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public CE[] getInventoryNumber() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getCdm9_InventoryNumber() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getInventoryNumberReps() {
        return this.getReps(9);
    }

    public CE getInventoryNumber(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getCdm9_InventoryNumber(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getCdm9_InventoryNumberReps() {
        return this.getReps(9);
    }

    public CE insertInventoryNumber(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertCdm9_InventoryNumber(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeInventoryNumber(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeCdm9_InventoryNumber(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public NM getResourceLoad() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getCdm10_ResourceLoad() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CK[] getContractNumber() {
        CK[] retVal = (CK[])this.getTypedField(11, new CK[0]);
        return retVal;
    }

    public CK[] getCdm11_ContractNumber() {
        CK[] retVal = (CK[])this.getTypedField(11, new CK[0]);
        return retVal;
    }

    public int getContractNumberReps() {
        return this.getReps(11);
    }

    public CK getContractNumber(int rep) {
        CK retVal = (CK)this.getTypedField(11, rep);
        return retVal;
    }

    public CK getCdm11_ContractNumber(int rep) {
        CK retVal = (CK)this.getTypedField(11, rep);
        return retVal;
    }

    public int getCdm11_ContractNumberReps() {
        return this.getReps(11);
    }

    public CK insertContractNumber(int rep) throws HL7Exception {
        return (CK)super.insertRepetition(11, rep);
    }

    public CK insertCdm11_ContractNumber(int rep) throws HL7Exception {
        return (CK)super.insertRepetition(11, rep);
    }

    public CK removeContractNumber(int rep) throws HL7Exception {
        return (CK)super.removeRepetition(11, rep);
    }

    public CK removeCdm11_ContractNumber(int rep) throws HL7Exception {
        return (CK)super.removeRepetition(11, rep);
    }

    public XON[] getContractOrganization() {
        XON[] retVal = (XON[])this.getTypedField(12, new XON[0]);
        return retVal;
    }

    public XON[] getCdm12_ContractOrganization() {
        XON[] retVal = (XON[])this.getTypedField(12, new XON[0]);
        return retVal;
    }

    public int getContractOrganizationReps() {
        return this.getReps(12);
    }

    public XON getContractOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(12, rep);
        return retVal;
    }

    public XON getCdm12_ContractOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(12, rep);
        return retVal;
    }

    public int getCdm12_ContractOrganizationReps() {
        return this.getReps(12);
    }

    public XON insertContractOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(12, rep);
    }

    public XON insertCdm12_ContractOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(12, rep);
    }

    public XON removeContractOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(12, rep);
    }

    public XON removeCdm12_ContractOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(12, rep);
    }

    public ID getRoomFeeIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getCdm13_RoomFeeIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(268));
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CK(this.getMessage());
            }
            case 11: {
                return new XON(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

