/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.model.v231.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class URD
extends AbstractSegment {
    public URD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "R/U Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(109)}, "Report Priority");
            this.add(XCN.class, true, 0, 60, new Object[]{this.getMessage()}, "R/U Who Subject Definition");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "R/U What Subject Definition");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "R/U What Department Code");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U Display/Print Locations");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "R/U Results Level");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating URD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TS getRUDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getUrd1_RUDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getUrd2_ReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getRUWhoSubjectDefinition() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public XCN[] getUrd3_RUWhoSubjectDefinition() {
        XCN[] retVal = (XCN[])this.getTypedField(3, new XCN[0]);
        return retVal;
    }

    public int getRUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public XCN getRUWhoSubjectDefinition(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getUrd3_RUWhoSubjectDefinition(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getUrd3_RUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public XCN insertRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removeRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public CE[] getRUWhatSubjectDefinition() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public CE[] getUrd4_RUWhatSubjectDefinition() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public int getRUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public CE getRUWhatSubjectDefinition(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getUrd4_RUWhatSubjectDefinition(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getUrd4_RUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public CE insertRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE[] getRUWhatDepartmentCode() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public CE[] getUrd5_RUWhatDepartmentCode() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public int getRUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public CE getRUWhatDepartmentCode(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getUrd5_RUWhatDepartmentCode(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getUrd5_RUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public CE insertRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removeRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public ST[] getRUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getUrd6_RUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getRUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST getRUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getUrd6_RUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUrd6_RUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST insertRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ID getRUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getUrd7_RUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(109));
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

