/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.RPR_I03_PRDCTD;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPR_I03
extends AbstractMessage {
    public RPR_I03() {
        this(new DefaultModelClassFactory());
    }

    public RPR_I03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RPR_I03_PRDCTD.class, true, true);
            this.add(PID.class, false, true);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPR_I03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RPR_I03_PRDCTD getPRDCTD() {
        return this.getTyped("PRDCTD", RPR_I03_PRDCTD.class);
    }

    public RPR_I03_PRDCTD getPRDCTD(int rep) {
        return this.getTyped("PRDCTD", rep, RPR_I03_PRDCTD.class);
    }

    public int getPRDCTDReps() {
        return this.getReps("PRDCTD");
    }

    public List<RPR_I03_PRDCTD> getPRDCTDAll() throws HL7Exception {
        return this.getAllAsList("PRDCTD", RPR_I03_PRDCTD.class);
    }

    public void insertPRDCTD(RPR_I03_PRDCTD structure, int rep) throws HL7Exception {
        super.insertRepetition("PRDCTD", structure, rep);
    }

    public RPR_I03_PRDCTD insertPRDCTD(int rep) throws HL7Exception {
        return (RPR_I03_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }

    public RPR_I03_PRDCTD removePRDCTD(int rep) throws HL7Exception {
        return (RPR_I03_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PID getPID(int rep) {
        return this.getTyped("PID", rep, PID.class);
    }

    public int getPIDReps() {
        return this.getReps("PID");
    }

    public List<PID> getPIDAll() throws HL7Exception {
        return this.getAllAsList("PID", PID.class);
    }

    public void insertPID(PID structure, int rep) throws HL7Exception {
        super.insertRepetition("PID", structure, rep);
    }

    public PID insertPID(int rep) throws HL7Exception {
        return (PID)super.insertRepetition("PID", rep);
    }

    public PID removePID(int rep) throws HL7Exception {
        return (PID)super.removeRepetition("PID", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

