/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.RER_RER_DEFINITION;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RER_RER
extends AbstractMessage {
    public RER_RER() {
        this(new DefaultModelClassFactory());
    }

    public RER_RER(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(RER_RER_DEFINITION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RER_RER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public RER_RER_DEFINITION getDEFINITION() {
        return this.getTyped("DEFINITION", RER_RER_DEFINITION.class);
    }

    public RER_RER_DEFINITION getDEFINITION(int rep) {
        return this.getTyped("DEFINITION", rep, RER_RER_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RER_RER_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RER_RER_DEFINITION.class);
    }

    public void insertDEFINITION(RER_RER_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", structure, rep);
    }

    public RER_RER_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RER_RER_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RER_RER_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RER_RER_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

