/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.SRR_S10_PATIENT;
import ca.uhn.hl7v2.model.v23.group.SRR_S10_RESOURCES;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.SCH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SRR_S10_SCHEDULE
extends AbstractGroup {
    public SRR_S10_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCH.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(SRR_S10_PATIENT.class, false, true, false);
            this.add(SRR_S10_RESOURCES.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SRR_S10_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public SCH getSCH() {
        SCH retVal = this.getTyped("SCH", SCH.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SRR_S10_PATIENT getPATIENT() {
        SRR_S10_PATIENT retVal = this.getTyped("PATIENT", SRR_S10_PATIENT.class);
        return retVal;
    }

    public SRR_S10_PATIENT getPATIENT(int rep) {
        SRR_S10_PATIENT retVal = this.getTyped("PATIENT", rep, SRR_S10_PATIENT.class);
        return retVal;
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<SRR_S10_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", SRR_S10_PATIENT.class);
    }

    public void insertPATIENT(SRR_S10_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public SRR_S10_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SRR_S10_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SRR_S10_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SRR_S10_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SRR_S10_RESOURCES getRESOURCES() {
        SRR_S10_RESOURCES retVal = this.getTyped("RESOURCES", SRR_S10_RESOURCES.class);
        return retVal;
    }

    public SRR_S10_RESOURCES getRESOURCES(int rep) {
        SRR_S10_RESOURCES retVal = this.getTyped("RESOURCES", rep, SRR_S10_RESOURCES.class);
        return retVal;
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SRR_S10_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SRR_S10_RESOURCES.class);
    }

    public void insertRESOURCES(SRR_S10_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", structure, rep);
    }

    public SRR_S10_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SRR_S10_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SRR_S10_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SRR_S10_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

