/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.CQ_QUANTITY;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TQ;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXE
extends AbstractSegment {
    public RXE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TQ.class, false, 0, 200, new Object[]{this.getMessage()}, "Quantity / timing");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Give Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Provider's Administration Instructions");
            this.add(CM_LA1.class, false, 1, 12, new Object[]{this.getMessage()}, "Deliver-to location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Dispense Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Dispense Units");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Number of Refills");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Ordering Provider's DEA Number");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Pharmacist Verifier ID");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Number of refills / doses dispensed");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date / time of most recent refill or dose dispensed");
            this.add(CQ_QUANTITY.class, false, 1, 10, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Needs Human Review");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Pharmacy Special Dispensing Instructions");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(CE.class, false, 1, 6, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Rate Units");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TQ[] getQuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(1, new TQ[0]);
        return retVal;
    }

    public TQ[] getRxe1_QuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(1, new TQ[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(1);
    }

    public TQ getQuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(1, rep);
        return retVal;
    }

    public TQ getRxe1_QuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(1, rep);
        return retVal;
    }

    public int getRxe1_QuantityTimingReps() {
        return this.getReps(1);
    }

    public TQ insertQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(1, rep);
    }

    public TQ insertRxe1_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(1, rep);
    }

    public TQ removeQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(1, rep);
    }

    public TQ removeRxe1_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(1, rep);
    }

    public CE getGiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRxe2_GiveCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxe3_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxe4_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getGiveUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxe5_GiveUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getGiveDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRxe6_GiveDosageForm() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE[] getProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public CE[] getRxe7_ProviderSAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(7, new CE[0]);
        return retVal;
    }

    public int getProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE getProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public CE getRxe7_ProviderSAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxe7_ProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CM_LA1 getDeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_LA1 getRxe8_DeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getRxe9_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getDispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRxe10_DispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getDispenseUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getRxe11_DispenseUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getNumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getRxe12_NumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CN getOrderingProviderSDEANumber() {
        CN retVal = (CN)this.getTypedField(13, 0);
        return retVal;
    }

    public CN getRxe13_OrderingProviderSDEANumber() {
        CN retVal = (CN)this.getTypedField(13, 0);
        return retVal;
    }

    public CN getPharmacistVerifierID() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public CN getRxe14_PharmacistVerifierID() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getRxe15_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getRxe16_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getNumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRxe17_NumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public TS getDateTimeOfMostRecentRefillOrDoseDispensed() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getRxe18_DateTimeOfMostRecentRefillOrDoseDispensed() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ_QUANTITY getTotalDailyDose() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ_QUANTITY getRxe19_TotalDailyDose() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRxe20_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getPharmacySpecialDispensingInstructions() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getRxe21_PharmacySpecialDispensingInstructions() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getRxe22_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getGiveRateAmount() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getRxe23_GiveRateAmount() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getRxe24_GiveRateUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TQ(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CM_LA1(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CN(this.getMessage());
            }
            case 13: {
                return new CN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new CQ_QUANTITY(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new CE(this.getMessage());
            }
            case 23: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

