/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CM;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORC
extends AbstractSegment {
    public ORC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 2, new Object[]{this.getMessage()}, "ORDER CONTROL");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage()}, "PLACER ORDER #");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage()}, "FILLER ORDER #");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage()}, "PLACER GROUP #");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "ORDER STATUS");
            this.add(ST.class, false, 1, 1, new Object[]{this.getMessage()}, "RESPONSE FLAG");
            this.add(CM.class, false, 1, 200, new Object[]{this.getMessage()}, "TIMING/QUANTITY");
            this.add(CM.class, false, 1, 200, new Object[]{this.getMessage()}, "PARENT");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DATE/TIME OF TRANSACTION");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "ENTERED BY");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "VERIFIED BY");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "ORDERING PROVIDER");
            this.add(CM.class, false, 1, 80, new Object[]{this.getMessage()}, "ENTERER'S LOCATION");
            this.add(TN.class, false, 2, 40, new Object[]{this.getMessage()}, "CALL BACK PHONE NUMBER");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getORDERCONTROL() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOrc1_ORDERCONTROL() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public CM getPLACERORDER() {
        CM retVal = (CM)this.getTypedField(2, 0);
        return retVal;
    }

    public CM getOrc2_PLACERORDER() {
        CM retVal = (CM)this.getTypedField(2, 0);
        return retVal;
    }

    public CM getFILLERORDER() {
        CM retVal = (CM)this.getTypedField(3, 0);
        return retVal;
    }

    public CM getOrc3_FILLERORDER() {
        CM retVal = (CM)this.getTypedField(3, 0);
        return retVal;
    }

    public CM getPLACERGROUP() {
        CM retVal = (CM)this.getTypedField(4, 0);
        return retVal;
    }

    public CM getOrc4_PLACERGROUP() {
        CM retVal = (CM)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getORDERSTATUS() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getOrc5_ORDERSTATUS() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getRESPONSEFLAG() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getOrc6_RESPONSEFLAG() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public CM getTIMINGQUANTITY() {
        CM retVal = (CM)this.getTypedField(7, 0);
        return retVal;
    }

    public CM getOrc7_TIMINGQUANTITY() {
        CM retVal = (CM)this.getTypedField(7, 0);
        return retVal;
    }

    public CM getPARENT() {
        CM retVal = (CM)this.getTypedField(8, 0);
        return retVal;
    }

    public CM getOrc8_PARENT() {
        CM retVal = (CM)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getDATETIMEOFTRANSACTION() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getOrc9_DATETIMEOFTRANSACTION() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public CN getENTEREDBY() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getOrc10_ENTEREDBY() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getVERIFIEDBY() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getOrc11_VERIFIEDBY() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getORDERINGPROVIDER() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public CN getOrc12_ORDERINGPROVIDER() {
        CN retVal = (CN)this.getTypedField(12, 0);
        return retVal;
    }

    public CM getENTERERSLOCATION() {
        CM retVal = (CM)this.getTypedField(13, 0);
        return retVal;
    }

    public CM getOrc13_ENTERERSLOCATION() {
        CM retVal = (CM)this.getTypedField(13, 0);
        return retVal;
    }

    public TN[] getCALLBACKPHONENUMBER() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public TN[] getOrc14_CALLBACKPHONENUMBER() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public int getCALLBACKPHONENUMBERReps() {
        return this.getReps(14);
    }

    public TN getCALLBACKPHONENUMBER(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public TN getOrc14_CALLBACKPHONENUMBER(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOrc14_CALLBACKPHONENUMBERReps() {
        return this.getReps(14);
    }

    public TN insertCALLBACKPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN insertOrc14_CALLBACKPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN removeCALLBACKPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public TN removeOrc14_CALLBACKPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new CM(this.getMessage());
            }
            case 2: {
                return new CM(this.getMessage());
            }
            case 3: {
                return new CM(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new CM(this.getMessage());
            }
            case 7: {
                return new CM(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new CN(this.getMessage());
            }
            case 11: {
                return new CN(this.getMessage());
            }
            case 12: {
                return new CM(this.getMessage());
            }
            case 13: {
                return new TN(this.getMessage());
            }
        }
        return null;
    }
}

