/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CM_MSG;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSH
extends AbstractSegment {
    public MSH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 1, new Object[]{this.getMessage()}, "FIELD SEPARATOR");
            this.add(ST.class, true, 1, 4, new Object[]{this.getMessage()}, "ENCODING CHARACTERS");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "SENDING APPLICATION");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "SENDING FACILITY");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "RECEIVING APPLICATION");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "RECEIVING FACILITY");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DATE/TIME OF MESSAGE");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Security");
            this.add(CM_MSG.class, true, 1, 7, new Object[]{this.getMessage()}, "MESSAGE TYPE");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "MESSAGE CONTROL ID");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(103)}, "PROCESSING ID");
            this.add(NM.class, true, 1, 8, new Object[]{this.getMessage()}, "VERSION ID");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "SEQUENCE NUMBER");
            this.add(ST.class, false, 1, 180, new Object[]{this.getMessage()}, "CONTINUATION POINTER");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MSH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getFIELDSEPARATOR() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMsh1_FIELDSEPARATOR() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getENCODINGCHARACTERS() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsh2_ENCODINGCHARACTERS() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSENDINGAPPLICATION() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getMsh3_SENDINGAPPLICATION() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSENDINGFACILITY() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getMsh4_SENDINGFACILITY() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getRECEIVINGAPPLICATION() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getMsh5_RECEIVINGAPPLICATION() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getRECEIVINGFACILITY() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getMsh6_RECEIVINGFACILITY() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getDATETIMEOFMESSAGE() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getMsh7_DATETIMEOFMESSAGE() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getSecurity() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getMsh8_Security() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_MSG getMESSAGETYPE() {
        CM_MSG retVal = (CM_MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public CM_MSG getMsh9_MESSAGETYPE() {
        CM_MSG retVal = (CM_MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getMESSAGECONTROLID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getMsh10_MESSAGECONTROLID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPROCESSINGID() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getMsh11_PROCESSINGID() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getVERSIONID() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getMsh12_VERSIONID() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getSEQUENCENUMBER() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getMsh13_SEQUENCENUMBER() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getCONTINUATIONPOINTER() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getMsh14_CONTINUATIONPOINTER() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new CM_MSG(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(103));
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

