/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DSP
extends AbstractSegment {
    public DSP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - DISPLAY DATA");
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "DISPLAY LEVEL");
            this.add(TX.class, true, 1, 300, new Object[]{this.getMessage()}, "DATA LINE");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "LOGICAL BREAK POINT");
            this.add(TX.class, false, 1, 20, new Object[]{this.getMessage()}, "RESULT ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DSP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDDISPLAYDATA() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getDsp1_SETIDDISPLAYDATA() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getDISPLAYLEVEL() {
        SI retVal = (SI)this.getTypedField(2, 0);
        return retVal;
    }

    public SI getDsp2_DISPLAYLEVEL() {
        SI retVal = (SI)this.getTypedField(2, 0);
        return retVal;
    }

    public TX getDATALINE() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public TX getDsp3_DATALINE() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getLOGICALBREAKPOINT() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getDsp4_LOGICALBREAKPOINT() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getRESULTID() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getDsp5_RESULTID() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new SI(this.getMessage());
            }
            case 2: {
                return new TX(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

