/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.llp.HL7Charsets;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.preparser.PreParser;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSetUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CharSetUtil.class);

    static Charset checkCharset(String message, Charset defaultCharset) {
        Charset charset = defaultCharset;
        try {
            String[] fields = PreParser.getFields(message, "MSH-18(0)");
            String hl7CharsetName = CharSetUtil.stripNonLowAscii(fields[0]);
            if (hl7CharsetName != null && hl7CharsetName.length() > 0) {
                charset = HL7Charsets.getCharsetForHL7Encoding(hl7CharsetName);
            }
            LOG.trace("Detected MSH-18 value \"{}\" so using charset {}", (Object)hl7CharsetName, (Object)charset.displayName());
        }
        catch (EncodingNotSupportedException e) {
            LOG.warn("Invalid or unsupported charset in MSH-18. Defaulting to {}", (Object)charset.displayName());
        }
        catch (HL7Exception e) {
            LOG.warn("Failed to parse MSH segment. Defaulting to {}", (Object)charset.displayName(), (Object)e);
        }
        return charset;
    }

    static Charset checkCharset(byte[] message, Charset defaultCharset) {
        String guessMessage = BOM.skipBOM(message);
        return CharSetUtil.checkCharset(guessMessage, defaultCharset);
    }

    private static String stripNonLowAscii(String theString) {
        if (theString == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            char next = theString.charAt(i);
            if (next <= '\u0000' || next >= '\u007f') continue;
            b.append(next);
        }
        return b.toString();
    }

    public static byte[] withoutBOM(byte[] bytes) {
        BOM bom = BOM.getBOM(bytes);
        byte[] withoutBOM = new byte[bytes.length - bom.bytes.length];
        System.arraycopy(bytes, bom.bytes.length, withoutBOM, 0, bytes.length - bom.bytes.length);
        return withoutBOM;
    }

    private static enum BOM {
        UTF_8(new byte[]{-17, -69, -65}, "UTF-8"),
        UTF_16_LE(new byte[]{-1, -2}, "UTF-16LE"),
        UTF_16_BE(new byte[]{-2, -1}, "UTF-16BE"),
        UTF_32_LE(new byte[]{-1, -2, 0, 0}, "UTF-32LE"),
        UTF_32_BE(new byte[]{0, 0, -2, -1}, "UTF-32BE"),
        NONE(new byte[0], "US-ASCII");

        private byte[] bytes;
        private Charset charset;

        private BOM(byte[] bytes, String charset) {
            this.bytes = bytes;
            this.charset = Charset.forName(charset);
        }

        public static BOM getBOM(byte[] bytes) {
            for (BOM bom : BOM.values()) {
                byte[] bytesToCompare = new byte[bom.bytes.length];
                System.arraycopy(bytes, 0, bytesToCompare, 0, bom.bytes.length);
                if (!Arrays.equals(bom.bytes, bytesToCompare)) continue;
                return bom;
            }
            return NONE;
        }

        public static String skipBOM(byte[] bytes) {
            try {
                BOM bom = BOM.getBOM(bytes);
                return new String(bytes, bom.bytes.length, bytes.length - bom.bytes.length, bom.charset.toString());
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

