/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultExecutorService {
    static ExecutorService defaultExecutorService;

    public static <V> CompletionService<V> completionService(ExecutorService executor) {
        return new ExecutorCompletionService(executor);
    }

    public static synchronized ExecutorService getDefaultService() {
        if (defaultExecutorService == null || defaultExecutorService.isShutdown()) {
            defaultExecutorService = Executors.newCachedThreadPool(new MyThreadFactory());
        }
        return defaultExecutorService;
    }

    public static boolean isDefaultService(ExecutorService service) {
        return service != null && service == defaultExecutorService;
    }

    public static void shutdown() {
        defaultExecutorService.shutdown();
    }

    public static void shutdownNow() {
        defaultExecutorService.shutdownNow();
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        private ThreadGroup group = Thread.currentThread().getThreadGroup();
        private AtomicInteger threadNum = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable theR) {
            String name = "hapi-worker-" + this.threadNum.getAndIncrement();
            Thread t = new Thread(this.group, theR, name, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

