/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.ActiveConnection;
import ca.uhn.hl7v2.concurrent.Service;
import ca.uhn.hl7v2.llp.HL7Reader;
import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Receiver
extends Service {
    private static final Logger log = LoggerFactory.getLogger(Receiver.class);
    private ActiveConnection conn;
    private HL7Reader in;

    public Receiver(ActiveConnection c, HL7Reader in) {
        super("Receiver", c.getExecutorService());
        this.conn = c;
        this.in = in;
    }

    @Override
    protected void handle() {
        try {
            String message = this.in.getMessage();
            if (message == null) {
                log.debug("Failed to read a message");
            } else {
                this.processMessage(message);
            }
        }
        catch (SocketException e) {
            this.conn.close();
            log.info("SocketException: closing Connection from " + this.describeRemoteConnection() + ", will no longer read messages with this Receiver: " + e.getMessage());
        }
        catch (IOException e) {
            this.conn.close();
            log.warn("IOException: closing Connection from " + this.describeRemoteConnection() + ", will no longer read messages with this Receiver. ", (Throwable)e);
        }
        catch (Exception e) {
            this.conn.close();
            log.error("Unexpected error, closing connection from " + this.describeRemoteConnection() + " - ", (Throwable)e);
        }
    }

    private String describeRemoteConnection() {
        return this.conn.getRemoteAddress().getHostAddress() + ":" + this.conn.getRemotePort();
    }

    protected void processMessage(String message) {
        String ackID = this.conn.getParser().getAckID(message);
        if (ackID == null) {
            log.debug("Unsolicited Message Received: {}", (Object)message);
            this.getExecutorService().submit(new Grunt(this.conn, message));
        } else if (!this.conn.isRecipientWaiting(ackID, message)) {
            log.info("Unexpected Message Received. This message appears to be an acknowledgement (MSA-2 has a value) so it will be ignored: {}", (Object)message);
        } else {
            log.debug("Response Message Received: {}", (Object)message);
        }
    }

    private static class Grunt
    implements Runnable {
        private ActiveConnection conn;
        private String m;

        public Grunt(ActiveConnection conn, String message) {
            this.conn = conn;
            this.m = message;
        }

        @Override
        public void run() {
            try {
                String response = this.conn.getResponder().processMessage(this.m);
                if (response != null) {
                    this.conn.getAckWriter().writeMessage(response);
                } else {
                    log.debug("Not responding to incoming message");
                }
            }
            catch (Exception e) {
                log.error("Error while processing message: ", (Throwable)e);
            }
        }
    }
}

