/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.model.Identifiable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenericSelectionDialog
extends TitleAreaDialog {
    private List<?> input;
    private Map<Object, Button> buttonMap = new HashMap<Object, Button>();
    private List<Object> selection = new LinkedList<Object>();
    private String title;
    private String message;

    public GenericSelectionDialog(Shell parentShell, List<?> input, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.input = input;
        this.setBlockOnOpen(true);
    }

    public GenericSelectionDialog(Shell parentShell, List<?> input) {
        this(parentShell, input, "Auswahl", null);
    }

    public void setSelection(List<Object> selection) {
        this.selection = new LinkedList<Object>(selection);
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.selection);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite ret = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(ret, 768);
        Composite child = new Composite((Composite)sc, 0);
        child.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        sc.setLayoutData((Object)data);
        for (final Object object : this.input) {
            final Button button = new Button(child, 32);
            button.setText(GenericSelectionDialog.getLabel(object));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        GenericSelectionDialog.this.selection.add(object);
                    } else {
                        GenericSelectionDialog.this.selection.remove(object);
                    }
                }
            });
            this.buttonMap.put(object, button);
        }
        sc.setMinSize(child.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)child);
        this.updateSelectionUi();
        return ret;
    }

    private void updateSelectionUi() {
        if (this.selection != null && !this.selection.isEmpty() && !this.buttonMap.isEmpty()) {
            for (Object object : this.selection) {
                this.buttonMap.get(object).setSelection(true);
            }
        }
    }

    public static String getLabel(Object object) {
        if (object instanceof Identifiable) {
            return ((Identifiable)object).getLabel();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }
}

