/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.core.ui.views.textsystem.Messages;
import ch.elexis.core.ui.views.textsystem.PlatzhalterProperties;
import ch.elexis.core.ui.views.textsystem.PlatzhalterTreeData;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.part.ViewPart;

public class PlatzhalterView
extends ViewPart {
    public static final String ID = "ch.elexis.views.textsystem.Platzhalterview";
    private TreeViewer viewer;

    private void copyToClipboard() {
        String key = this.getSelectedKey();
        if (key != null) {
            Clipboard clipboard = new Clipboard(this.getViewSite().getShell().getDisplay());
            clipboard.setContents(new Object[]{key}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private String getSelectedKey() {
        String key;
        TreeItem[] items = this.viewer.getTree().getSelection();
        if (items != null && items.length > 0 && (key = ((PlatzhalterTreeData)items[0].getData()).getKey()) != null && key.length() > 0) {
            return key;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Text txtInfo = new Text(composite, 74);
        txtInfo.setText(Messages.PlatzhalterView_message_Info);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)txtInfo);
        this.viewer = new TreeViewer(composite, 770);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PlatzhalterLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new PlatzhalterContentProvider());
        this.viewer.setInput(this.getTreeData());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        MenuManager popupMenuManager = new MenuManager();
        Menu menu = popupMenuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        final Action copyAction = new Action(Messages.PlatzhalterView_menu_copy){

            public String getId() {
                return "copyId";
            }

            public void run() {
                PlatzhalterView.this.copyToClipboard();
            }
        };
        popupMenuManager.add((IAction)copyAction);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                copyAction.setEnabled(PlatzhalterView.this.getSelectedKey() != null);
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){
            private static final int C = 99;

            private boolean isActive(int stateMask, int keyCode) {
                boolean modifiersOk = true;
                if ((stateMask & 0x40000) == 0) {
                    modifiersOk = false;
                }
                return modifiersOk && keyCode == 99;
            }

            public void keyPressed(KeyEvent e) {
                if (this.isActive(e.stateMask, e.keyCode)) {
                    PlatzhalterView.this.copyToClipboard();
                }
            }
        });
        this.viewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String key = PlatzhalterView.this.getSelectedKey();
                if (key != null) {
                    IViewReference[] iViewReferenceArray = PlatzhalterView.this.getViewSite().getPage().getViewReferences();
                    int n = iViewReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextView txtView;
                        IViewReference viewRef = iViewReferenceArray[n2];
                        if ("ch.elexis.TextView".equals(viewRef.getId()) && (txtView = (TextView)viewRef.getPart(false)) != null) {
                            txtView.getTextContainer().getPlugin().insertText((Object)null, key, 16384);
                        }
                        ++n2;
                    }
                }
            }
        });
        DragSource dragSource = new DragSource((Control)this.viewer.getTree(), 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                event.doit = PlatzhalterView.this.getSelectedKey() != null;
            }

            public void dragSetData(DragSourceEvent event) {
                String key;
                if (TextTransfer.getInstance().isSupportedType(event.dataType) && (key = PlatzhalterView.this.getSelectedKey()) != null) {
                    event.data = key;
                }
            }
        });
    }

    private SortedList<PlatzhalterTreeData> getTreeData() {
        PlatzhalterTreeData root = new PlatzhalterTreeData("Root", "", "");
        PlatzhalterProperties props = new PlatzhalterProperties();
        root.addChildren(props.getList());
        List textPlaceHolderList = Extensions.getExtensions((String)"ch.elexis.core.data.DataAccess", (String)"TextPlaceHolder");
        for (IConfigurationElement iConfigurationElement : textPlaceHolderList) {
            PlatzhalterTreeData childData;
            PlatzhalterTreeData treeData;
            boolean found = false;
            String name = iConfigurationElement.getAttribute("name");
            String type = iConfigurationElement.getAttribute("type");
            String typeName = type.substring(type.lastIndexOf(46) + 1);
            if (name != null && type != null && (treeData = root.getChild(typeName)) != null && (childData = treeData.getChild(name)) != null) {
                found = true;
            }
            if (found) continue;
            treeData = root.getChild(typeName);
            if (treeData == null) {
                treeData = new PlatzhalterTreeData(typeName, "", "");
            }
            treeData.addChild(new PlatzhalterTreeData(name, "[" + typeName + "." + name + "]", ""));
        }
        List dataAccessList = Extensions.getClasses((String)"ch.elexis.core.data.DataAccess", (String)"DataAccess", (String)"class");
        for (IDataAccess dataAccess : dataAccessList) {
            PlatzhalterTreeData treeData = new PlatzhalterTreeData(dataAccess.getName(), "", dataAccess.getDescription());
            if (dataAccess.getList() != null) {
                for (IDataAccess.Element element : dataAccess.getList()) {
                    treeData.addChild(new PlatzhalterTreeData(element.getName(), element.getPlaceholder(), element.getName()));
                }
            }
            root.addChild(treeData);
        }
        return root.getChildren();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    class PlatzhalterContentProvider
    implements ITreeContentProvider {
        PlatzhalterContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            PlatzhalterTreeData entry = (PlatzhalterTreeData)parentElement;
            SortedList<PlatzhalterTreeData> childrenList = entry.getChildren();
            return childrenList.toArray((PlatzhalterTreeData[])new PlatzhalterTreeData[childrenList.size()]);
        }

        public Object getParent(Object element) {
            PlatzhalterTreeData entry = (PlatzhalterTreeData)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private class PlatzhalterLabelProvider
    extends CellLabelProvider {
        private PlatzhalterLabelProvider() {
        }

        public String getToolTipText(Object element) {
            PlatzhalterTreeData data = (PlatzhalterTreeData)element;
            if (data != null) {
                return data.getDescription();
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            PlatzhalterTreeData data = (PlatzhalterTreeData)cell.getElement();
            if (data != null) {
                cell.setText(data.getName());
            }
        }
    }
}

