/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObjectFactory;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.LoggerFactory;

public class CodeSystemDescription {
    private String configName;
    private ICodeElement poCodeElement;
    private CodeSelectorFactory codeSelectorFactory;
    private String system;
    private String elexisClassName;

    public static Optional<CodeSystemDescription> of(IConfigurationElement configuration) {
        CodeSystemDescription ret = new CodeSystemDescription();
        try {
            ret.configName = String.valueOf(configuration.getName()) + " - " + configuration.getAttribute("name");
            ret.codeSelectorFactory = (CodeSelectorFactory)configuration.createExecutableExtension("CodeSelectorFactory");
            if (ret.codeSelectorFactory == null) {
                String error = "No CodeSelectorFactory [" + configuration.getClass().getName() + "]";
                SWTHelper.alert("Error", error);
                LoggerFactory.getLogger(CodeSystemDescription.class).error(error);
                return Optional.empty();
            }
            CoreUiUtil.injectServicesWithContext(ret.codeSelectorFactory);
            String factoryName = configuration.getAttribute("ElementFactory");
            if (factoryName != null && !factoryName.isEmpty()) {
                PersistentObjectFactory poFactory = (PersistentObjectFactory)configuration.createExecutableExtension("ElementFactory");
                ret.poCodeElement = (ICodeElement)poFactory.createTemplate(ret.codeSelectorFactory.getElementClass());
            } else {
                String system = configuration.getAttribute("system");
                if (system == null || system.isEmpty()) {
                    String error = "No system or factory [" + ret.configName + "]";
                    SWTHelper.alert("Error", error);
                    LoggerFactory.getLogger(CodeSystemDescription.class).error(error);
                    return Optional.empty();
                }
                ret.system = system;
                ret.elexisClassName = configuration.getAttribute("elexisClassName");
            }
        }
        catch (CoreException ex) {
            LoggerFactory.getLogger(CodeSystemDescription.class).error("Error creating config", (Throwable)ex);
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public String getCodeSystemName() {
        if (this.poCodeElement != null) {
            return this.poCodeElement.getCodeSystemName();
        }
        if (this.system != null) {
            return this.system;
        }
        throw new IllegalStateException("No system and no code element present [" + this.configName + "]");
    }

    public CodeSelectorFactory getCodeSelectorFactory() {
        return this.codeSelectorFactory;
    }

    public SelectionDialog getSelectionDialog(Shell parent, Object data) {
        return this.codeSelectorFactory.getSelectionDialog(parent, data);
    }

    public List<Object> getActions(Object context) {
        if (this.poCodeElement != null) {
            return this.poCodeElement.getActions(context);
        }
        return null;
    }

    public String getElexisClassName() {
        if (this.poCodeElement != null) {
            return this.poCodeElement.getClass().getName();
        }
        return this.elexisClassName;
    }
}

