/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICodeElementBlockBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.commands.ExportiereBloeckeCommand;
import ch.elexis.core.ui.dialogs.BlockSelektor;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.BlockElementViewerItem;
import ch.elexis.core.ui.views.codesystems.BlockTreeViewerItem;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.LoggerFactory;

public class BlockSelector
extends CodeSelectorFactory {
    protected static final String BLOCK_ONLY_FILTER_ENABLED = "blockselector/blockonlyfilter";
    protected static final String BLOCK_FILTER_ONLY_MANDATOR = "blockselector/blockfilteronlymandator";
    private IAction deleteAction;
    private IAction createAction;
    private IAction exportAction;
    private IAction copyAction;
    private IAction searchBlocksOnly;
    private IAction searchFilterMandator;
    private CommonViewer cv;
    private MenuManager mgr;
    static SelectorPanelProvider slp;
    int eventType = 1;
    ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            ICodeElementBlock selected = null;
            Object object = firstElement = ss.isEmpty() ? null : ss.getFirstElement();
            if (firstElement instanceof BlockTreeViewerItem) {
                selected = ((BlockTreeViewerItem)firstElement).getBlock();
            }
            BlockSelector.this.tvfa.updateSelection((Identifiable)selected);
            if (selected != null) {
                ContextServiceHolder.get().getRootContext().setTyped((Object)selected);
            }
        }
    };

    @Override
    public ViewerConfigurer createViewerConfigurer(final CommonViewer cv) {
        this.cv = cv;
        cv.setSelectionChangedListener(this.selChangeListener);
        this.makeActions();
        this.mgr = new MenuManager();
        this.mgr.setRemoveAllWhenShown(true);
        this.mgr.add((IContributionItem)new Separator("additions"));
        this.mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object selected = cv.getSelection()[0];
                if (selected instanceof BlockTreeViewerItem) {
                    manager.add((IAction)BlockSelector.this.tvfa);
                    manager.add(BlockSelector.this.deleteAction);
                    manager.add(BlockSelector.this.copyAction);
                }
                BlockSelector.this.addPopupCommandContributions(manager, cv.getSelection());
            }
        });
        cv.setContextMenu(this.mgr);
        FieldDescriptor[] lbName = new FieldDescriptor[]{new FieldDescriptor("Name")};
        Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == BlockSelector.this.eventType && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    slp.fireChangedEvent();
                }
            }
        };
        FieldDescriptor[] fieldDescriptorArray = lbName;
        int n = lbName.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor lbn = fieldDescriptorArray[n2];
            lbn.setAssignedListener(this.eventType, keyListener);
            ++n2;
        }
        slp = new SelectorPanelProvider(lbName, true);
        slp.addActions(this.createAction, this.exportAction, this.searchBlocksOnly, this.searchFilterMandator);
        ViewerConfigurer vc = new ViewerConfigurer(new BlockContentProvider(this, cv), new BlockTreeViewerItem.ColorizedLabelProvider(), slp, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(0, 0, null));
        vc.addDragSourceSelectionRenderer(new GenericObjectDragSource.ISelectionRenderer(){

            @Override
            public List<Object> getSelection() {
                IStructuredSelection selection = cv.getViewerWidget().getStructuredSelection();
                if (!selection.isEmpty()) {
                    return BlockSelector.this.collectSelections(selection);
                }
                return Collections.emptyList();
            }
        });
        return vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    @Override
    public Class<?> getElementClass() {
        return ICodeElementBlock.class;
    }

    @Override
    public void dispose() {
    }

    private void makeActions() {
        this.deleteAction = new Action("Block l\u00f6schen"){

            public void run() {
                Object selected = BlockSelector.this.cv.getSelection()[0];
                if (selected instanceof BlockTreeViewerItem) {
                    ICodeElementBlock block = ((BlockTreeViewerItem)selected).getBlock();
                    CoreModelServiceHolder.get().delete((Deleteable)block);
                    BlockSelector.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.createAction = new Action("neu erstellen"){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText("Neuen Block erstellen");
            }

            public void run() {
                String[] v = BlockSelector.this.cv.getConfigurer().getControlFieldProvider().getValues();
                if (v != null && v.length > 0 && v[0] != null && v[0].length() > 0) {
                    IQuery query = CoreModelServiceHolder.get().getQuery(ICodeElementBlock.class);
                    query.and("name", IQuery.COMPARATOR.EQUALS, (Object)v[0]);
                    if (!query.execute().isEmpty()) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Ein Block mit dem Namen [" + v[0] + "] existiert bereits"));
                    } else {
                        new ICodeElementBlockBuilder(CoreModelServiceHolder.get(), v[0]).mandator((IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)).buildAndSave();
                        BlockSelector.this.cv.notify(CommonViewer.Message.update_keeplabels);
                    }
                }
            }
        };
        this.exportAction = new Action("Bl\u00f6cke exportieren"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("Exportiert alle Bl\u00f6cke in eine SGAM-xChange-Datei");
            }

            public void run() {
                try {
                    new ExportiereBloeckeCommand().execute(null);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error exporting block", (Throwable)e);
                }
            }
        };
        this.copyAction = new Action("Block kopieren"){
            {
                this.setImageDescriptor(Images.IMG_COPY.getImageDescriptor());
                this.setToolTipText("Den Block umbenennen und kopieren");
            }

            public void run() {
                Object o = BlockSelector.this.cv.getSelection()[0];
                if (o instanceof BlockTreeViewerItem) {
                    ICodeElementBlock sourceBlock = ((BlockTreeViewerItem)o).getBlock();
                    InputDialog inputDlg = new InputDialog(Display.getDefault().getActiveShell(), "Block kopieren", "Bitte den Namen der Kopie eingeben bzw. best\u00e4tigen", String.valueOf(sourceBlock.getText()) + " Kopie", new IInputValidator(){

                        public String isValid(String newText) {
                            return newText != null && !newText.isEmpty() ? null : "Fehler, kein Name.";
                        }
                    }, 2048);
                    if (inputDlg.open() == 0) {
                        String newName = inputDlg.getValue();
                        new ICodeElementBlockBuilder(CoreModelServiceHolder.get(), sourceBlock.getCode()).mandator(sourceBlock.getMandator()).text(newName).elements(sourceBlock.getElements()).buildAndSave();
                        BlockSelector.this.cv.notify(CommonViewer.Message.update);
                    }
                }
            }
        };
        this.searchBlocksOnly = new Action("Blockinhalt nicht durchsuchen", 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText("Blockinhalt nicht durchsuchen");
                this.setChecked(ConfigServiceHolder.getUser((String)BlockSelector.BLOCK_ONLY_FILTER_ENABLED, (boolean)false));
            }

            public void run() {
                ConfigServiceHolder.setUser((String)BlockSelector.BLOCK_ONLY_FILTER_ENABLED, (boolean)this.isChecked());
            }
        };
        this.searchFilterMandator = new Action("Nur Bl\u00f6cke des aktiven Mandanten", 2){
            {
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
                this.setToolTipText("Nur Bl\u00f6cke des aktiven Mandanten");
                this.setChecked(ConfigServiceHolder.getUser((String)BlockSelector.BLOCK_FILTER_ONLY_MANDATOR, (boolean)false));
            }

            public void run() {
                ConfigServiceHolder.setUser((String)BlockSelector.BLOCK_FILTER_ONLY_MANDATOR, (boolean)this.isChecked());
                if (BlockSelector.this.cv.getConfigurer().getContentProvider() instanceof BlockContentProvider) {
                    BlockContentProvider blockContentProvider = (BlockContentProvider)BlockSelector.this.cv.getConfigurer().getContentProvider();
                    blockContentProvider.refreshViewer();
                }
            }
        };
    }

    @Override
    public SelectionDialog getSelectionDialog(Shell parent, Object data) {
        return new BlockSelektor(parent, data);
    }

    @Override
    public String getCodeSystemName() {
        return "Block";
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.cv.getViewerWidget();
    }

    @Override
    public MenuManager getMenuManager() {
        return this.mgr;
    }

    @Override
    public IDoubleClickListener getDoubleClickListener() {
        return new BlockDoubleClickListener();
    }

    private List<Object> collectSelections(IStructuredSelection selection) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object selected : selection.toList()) {
            if (selected instanceof BlockTreeViewerItem) {
                ret.add(((BlockTreeViewerItem)selected).getBlock());
                continue;
            }
            if (!(selected instanceof BlockElementViewerItem) || !(((BlockElementViewerItem)selected).getFirstElement() instanceof Identifiable)) continue;
            ret.add((Identifiable)((BlockElementViewerItem)selected).getFirstElement());
        }
        return ret;
    }

    public static class BlockContentProvider
    implements ViewerConfigurer.ICommonViewerContentProvider,
    ITreeContentProvider {
        private BlockSelector selector;
        private CommonViewer cv;
        private String queryFilter;
        private HashMap<ICodeElementBlock, BlockTreeViewerItem> blockItemMap;

        @Optional
        @Inject
        public void udpateBlock(@UIEventTopic(value="info/elexis/model/update") ICodeElementBlock block) {
            if (block != null && this.cv != null && this.cv.getViewerWidget() != null && !this.cv.getViewerWidget().getControl().isDisposed()) {
                BlockTreeViewerItem item = this.blockItemMap.get(block);
                this.cv.getViewerWidget().refresh((Object)item, true);
            }
        }

        BlockContentProvider(BlockSelector selector, CommonViewer cv) {
            this.cv = cv;
            this.selector = selector;
            CoreUiUtil.injectServicesWithContext(this);
        }

        @Override
        public void startListening() {
            this.cv.getConfigurer().getControlFieldProvider().addChangeListener(this);
        }

        @Override
        public void stopListening() {
            this.cv.getConfigurer().getControlFieldProvider().removeChangeListener(this);
        }

        public Object[] getElements(Object inputElement) {
            IQuery query = CoreModelServiceHolder.get().getQuery(ICodeElementBlock.class);
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"Version");
            if (this.queryFilter != null && this.queryFilter.length() > 2) {
                if (this.selector.searchBlocksOnly.isChecked()) {
                    query.and("name", IQuery.COMPARATOR.LIKE, (Object)("%" + this.queryFilter + "%"));
                } else {
                    query.startGroup();
                    query.and("name", IQuery.COMPARATOR.LIKE, (Object)("%" + this.queryFilter + "%"));
                    query.or("services", IQuery.COMPARATOR.LIKE, (Object)("%" + this.queryFilter + "%"));
                    query.andJoinGroups();
                }
            }
            query.orderBy("name", IQuery.ORDER.ASC);
            this.blockItemMap = new HashMap();
            List list = query.execute().stream().filter(b -> this.applyMandatorFilter((ICodeElementBlock)b)).map(b -> {
                BlockTreeViewerItem item = BlockTreeViewerItem.of(b);
                this.blockItemMap.put((ICodeElementBlock)b, item);
                return item;
            }).collect(Collectors.toList());
            return list.toArray();
        }

        private boolean applyMandatorFilter(ICodeElementBlock b) {
            if (this.selector.searchFilterMandator.isChecked()) {
                IMandator mandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
                IMandator blockMandator = b.getMandator();
                if (blockMandator != null && mandator != null) {
                    return blockMandator.getId().equals(mandator.getId());
                }
            }
            return true;
        }

        public void dispose() {
            this.stopListening();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        public void changed(HashMap<String, String> vals) {
            this.queryFilter = vals.get("Name");
            this.refreshViewer();
        }

        private void refreshViewer() {
            this.cv.getViewerWidget().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = cv.getViewerWidget();
                    if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        viewer.setSelection((ISelection)new StructuredSelection());
                        viewer.getControl().setRedraw(false);
                        viewer.refresh();
                        if (queryFilter != null && queryFilter.length() > 2) {
                            if (!selector.searchBlocksOnly.isChecked() && viewer instanceof TreeViewer) {
                                ((TreeViewer)viewer).expandAll();
                            }
                        } else {
                            ((TreeViewer)viewer).collapseAll();
                        }
                        viewer.getControl().setRedraw(true);
                    }
                }
            });
        }

        @Override
        public void reorder(String field) {
        }

        @Override
        public void selected() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof BlockTreeViewerItem) {
                BlockTreeViewerItem item = (BlockTreeViewerItem)element;
                return item.getChildren().toArray();
            }
            return Collections.emptyList().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BlockTreeViewerItem) {
                BlockTreeViewerItem item = (BlockTreeViewerItem)element;
                return item.hasChildren();
            }
            return false;
        }

        @Override
        public void init() {
        }
    }

    private class BlockDoubleClickListener
    implements IDoubleClickListener {
        private BlockDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = BlockSelector.this.cv.getViewerWidget().getStructuredSelection();
            if (!selection.isEmpty()) {
                List ret = BlockSelector.this.collectSelections(selection);
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                for (Object o : ret) {
                    target.codeSelected(o);
                }
            }
        }
    }
}

