/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObject;
import java.util.Hashtable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class ArtikelView
extends ViewPart
implements IActivationListener {
    private static final String KEY_CE = "ce";
    private static final String KEY_DETAIL = "detail";
    public static final String ID = "ch.elexis.artikelview";
    private CTabFolder ctab;
    private IAction importAction;
    private ViewMenus viewmenus;
    private Hashtable<String, ImporterPage> importers;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.ctab = new CTabFolder(parent, 0);
        this.importers = new Hashtable();
        new FavoritenCTabItem(this.ctab, 0);
        this.addPagesFor("ch.elexis.core.ui.Verrechnungscode");
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setSelection(0);
        }
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem selected = ArtikelView.this.ctab.getSelection();
                if (selected instanceof FavoritenCTabItem) {
                    return;
                }
                if (selected != null) {
                    String t = selected.getText();
                    MasterDetailsPage page = (MasterDetailsPage)selected.getControl();
                    if (page == null) {
                        try {
                            IDetailDisplay det = (IDetailDisplay)selected.getData(ArtikelView.KEY_DETAIL);
                            IConfigurationElement ce = (IConfigurationElement)selected.getData(ArtikelView.KEY_CE);
                            CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                            if (codeSelectorFactory != null) {
                                CoreUiUtil.injectServices(codeSelectorFactory);
                            }
                            String a = ce.getAttribute("ImporterClass");
                            ImporterPage ip = null;
                            if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                                ArtikelView.this.importers.put(det.getTitle(), ip);
                            }
                            page = new MasterDetailsPage((Composite)ArtikelView.this.ctab, codeSelectorFactory, det);
                            selected.setControl((Control)page);
                            selected.setData((Object)det);
                        }
                        catch (Exception ex) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating pages", (Throwable)ex);
                            return;
                        }
                    }
                    ArtikelView.this.importAction.setEnabled(ArtikelView.this.importers.get(t) != null);
                    ViewerConfigurer vc = page.cv.getConfigurer();
                    vc.getControlFieldProvider().setFocus();
                }
            }
        });
        this.makeActions();
        this.viewmenus = new ViewMenus(this.getViewSite());
        this.viewmenus.createMenu(this.importAction);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    private void makeActions() {
        this.importAction = new Action(Messages.ArtikelView_importAction){

            public void run() {
                ImporterPage top;
                CTabItem it = ArtikelView.this.ctab.getSelection();
                if (it != null && (top = (ImporterPage)ArtikelView.this.importers.get(it.getText())) != null) {
                    ImportDialog dlg = new ImportDialog(ArtikelView.this.getViewSite().getShell(), top);
                    dlg.create();
                    dlg.setTitle(top.getTitle());
                    dlg.setMessage(top.getDescription());
                    dlg.getShell().setText(Messages.ArtikelView_importCaption);
                    if (dlg.open() == 0) {
                        top.run(false);
                    }
                }
            }
        };
    }

    private void addPagesFor(String point) {
        List list = Extensions.getExtensions((String)point);
        IDetailDisplay detailDisplay = null;
        CodeSelectorFactory codeSelector = null;
        boolean headerDone = false;
        int i = 0;
        while (i < list.size()) {
            IConfigurationElement ce = (IConfigurationElement)list.get(i);
            try {
                if ("Artikel".equals(ce.getName())) {
                    if (!headerDone) {
                        detailDisplay = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                        String a = ce.getAttribute("ImporterClass");
                        ImporterPage ip = null;
                        if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                            this.importers.put(detailDisplay.getTitle(), ip);
                        }
                        codeSelector = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                        MasterDetailsPage page = new MasterDetailsPage((Composite)this.ctab, codeSelector, detailDisplay);
                        CTabItem ct = new CTabItem(this.ctab, 0);
                        ct.setText(detailDisplay.getTitle());
                        ct.setControl((Control)page);
                        ct.setData((Object)detailDisplay);
                        page.sash.setWeights(new int[]{30, 70});
                        headerDone = true;
                        if (codeSelector != null) {
                            CoreUiUtil.injectServicesWithContext(codeSelector);
                        }
                        if (detailDisplay != null) {
                            CoreUiUtil.injectServicesWithContext(detailDisplay);
                        }
                    } else {
                        detailDisplay = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                        CTabItem ct = new CTabItem(this.ctab, 0);
                        ct.setText(detailDisplay.getTitle());
                        ct.setData(KEY_CE, (Object)ce);
                        ct.setData(KEY_DETAIL, (Object)detailDisplay);
                        if (detailDisplay != null) {
                            CoreUiUtil.injectServicesWithContext(detailDisplay);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating pages", (Throwable)ex);
                MessageBox mb = new MessageBox(this.getViewSite().getShell(), 33);
                mb.setText(Messages.ArtikelView_errorCaption);
                mb.setMessage(String.valueOf(Messages.ArtikelView_errorText) + ce.getName() + ":\n" + ex.getLocalizedMessage());
                mb.open();
            }
            ++i;
        }
    }

    public void setFocus() {
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setFocus();
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        if (this.ctab != null && !this.ctab.isDisposed()) {
            CTabItem[] cTabItemArray = this.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem ct = cTabItemArray[n2];
                MasterDetailsPage page = (MasterDetailsPage)ct.getControl();
                page.cv.getConfigurer().getContentProvider().stopListening();
                page.dispose();
                ++n2;
            }
        }
    }

    @Override
    public void activation(boolean mode) {
        CTabItem selected = this.ctab.getSelection();
        if (selected instanceof FavoritenCTabItem) {
            return;
        }
        if (selected != null) {
            MasterDetailsPage page = (MasterDetailsPage)selected.getControl();
            ViewerConfigurer vc = page.cv.getConfigurer();
            if (mode) {
                vc.getControlFieldProvider().setFocus();
            } else {
                vc.getControlFieldProvider().clearValues();
            }
        }
    }

    @Override
    public void visible(boolean mode) {
        System.out.println(String.valueOf(this.getClass().getName()) + " visible " + mode);
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    private class ImportDialog
    extends TitleAreaDialog {
        ImporterPage importer;

        public ImportDialog(Shell parentShell, ImporterPage i) {
            super(parentShell);
            this.importer = i;
        }

        protected Control createDialogArea(Composite parent) {
            return this.importer.createPage(parent);
        }

        protected void okPressed() {
            this.importer.collect();
            super.okPressed();
        }
    }

    class MasterDetailsPage
    extends Composite {
        SashForm sash;
        CommonViewer cv;
        IDetailDisplay detailDisplay;
        ElexisEventListenerImpl eeli_div;

        MasterDetailsPage(Composite parent, CodeSelectorFactory master, IDetailDisplay detail) {
            super(parent, 0);
            if (PersistentObject.class.isAssignableFrom(detail.getElementClass())) {
                this.eeli_div = new ElexisUiEventListenerImpl(detail.getElementClass(), 16){

                    @Override
                    public void runInUi(ElexisEvent ev) {
                        MasterDetailsPage.this.detailDisplay.display(ev.getObject());
                    }
                };
                ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_div});
            }
            this.setLayout((Layout)new FillLayout());
            this.sash = new SashForm((Composite)this, 0);
            this.cv = new CommonViewer();
            this.cv.create(master.createViewerConfigurer(this.cv), (Composite)this.sash, 0, ArtikelView.this.getViewSite());
            detail.createDisplay((Composite)this.sash, ArtikelView.this.getViewSite());
            this.cv.getConfigurer().getContentProvider().startListening();
            this.detailDisplay = detail;
        }

        public void dispose() {
            if (this.eeli_div != null) {
                ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_div});
            }
        }
    }
}

